/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   source.cpp
implementation
of class        :   Source
author          :   Andreas Rinkel

version         :   1.0
history         :   23.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <strstrea.h>

// TOOPS library

// Project header
#include "source.h"   


//------------------------------------------------------------------------
Source  :: Source (ToopsProcessor *cpu, ToopsChannel *chan, char *name)
	    : ToopsProcess(cpu, 1, name)
{
    String    _text;

    // Definition of the member objects
    _text   = name;
    _text  += "_socket";
    _socket = new Synchron_Socket (_text, this, chan);
}

//------------------------------------------------------------------------
Source:: ~Source()
{ 
    delete _socket;
}

//------------------------------------------------------------------------
void 
Source:: behavior (void) 
{ 
    TextMessage     *_msg;

    _msg    = new TextMessage("Hello");
    while (1)
    {
        cout << name() << ": passing message to SAP: " << time() << endl;
        // send message over syncronous channel (service access point)
        // to the service provider
        _socket->send (_msg);  
        
        consumeTime(1);
    }
}

