/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   manager.cpp
implementation
of class        :   Manager
author          :   Andreas Rinkel

version         :   1.0
history         :   25.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <iostream.h>

// TOOPS library
#include <toops.h>
#include <message.h>

// Project header
#include "manager.h"   

//------------------------------------------------------------------------
Manager:: Manager(ToopsProcess    *entity,
					ToopsSocket     *to_peer,
                  Synchron_Socket *to_user,
                  Protocol        *prot)
{
	// Set the member objects
	_entity   				= entity;
	_peer_access			= to_peer;
	_user_access			= to_user;
	_prot					= prot;
}

//------------------------------------------------------------------------
void Manager:: trigger(void)
{  
	// pointer to possible messages
	ToopsMessage *_msg;
	
	// check, if the message was received from the peer entity,
	// get the message, check its type and pass on to the
	// appropriate protocol handler
	if ( _peer_access->hasMessage() )
	{ 
		cout << ToopsSimulation::time() << " " << _entity->name()
			 << ": port manager: received a message on " 
			 << _peer_access->name() << endl ;
		_msg = _peer_access->getMsg();

		switch ( ((PDU *)_msg)-> pdu())
		{
			case data:	_prot-> handler ( (Data*) _msg );
						break;

			case ack :	_prot-> handler ( (ACK*)_msg ); 
						break;
		}
	}
	// check, if the message was received from the user,
	// get the message, check its type and pass on to the
	// appropriate protocol handler
	else if (_user_access->hasMessage())
	{
		cout << ToopsSimulation::time() << " " << _entity->name()
			 << ": port manager: received a message on " 
			 << _user_access->name() << endl ;
		
		_msg =  _user_access->receive();
		switch ( ((SDU *)_msg)->sdu() )
		{
			case data_req:	_prot-> handler( (DataReq*)_msg);
							break;
		}
	}
	// if no message has been received, the timer must have 
	// expired
	else
	{
		_prot->timerHasExpired();
	}
}
