/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   entity.cpp
implementation
of class        :   Entity
author          :   Andreas Rinkel

version         :   1.0
history         :   25.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <iostream.h>

// TOOPS library

// Project header
#include "entity.h"


//------------------------------------------------------------------------
Entity::Entity(	ToopsProcessor	*cpu,
					ToopsChannel	*chan_service, 
					ToopsChannel 	*chan_partner,
					char			*name)
		: ToopsProcess(cpu, 1, name)
{
	String _text;

	// Definition of the member objects
	_text			 = name;
	_text			+= " peer entity access";
	_peer_access	 = new ToopsSocket (_text, this, chan_partner);

	_text			 = name;
	_text			+= " service access";
	_user_access	 = new Synchron_Socket(_text, this, chan_service);

	_prot			 = new Protocol (this, _peer_access, _user_access);
	_manager		 = new Manager  (this, _peer_access, _user_access, _prot);
}

Entity:: ~Entity()
{ 
	delete		_peer_access;
	delete		_user_access;
	delete		_manager;
	delete		_prot;
}

//------------------------------------------------------------------------
void Entity:: behavior (void)
{
	while (1)
	{
		// wait for a message on any socket or for an expired timer 
		// (see tprocess.h for explanations)
		synchronize();  			
		
		// call the port manager that handles the message received
		_manager -> trigger();
	}
}




