/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
filename:       abprot.cpp

documentation:  This program simulates the "Alternating Bit Protocol".

                For a simulation using a simple protocol, see the sample 
                program "simpprot" that simulates a simple protocol.
                
                See the header files of each class for further details.
                
author:         Andreas Rinkel
version      :  1.0
                This main program file is identical to simpprot.cpp
                in sample program simpprot.
history      :  23.04.96  Manfred Kraess
                clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <iostream.h>

// TOOPS library
#include <toops.h>
#include <socket.h>
#include <channel.h>


// Project header
#include "sink.h"
#include "source.h"
#include "entity.h"

int main()
{ 
    simtime duration = 30;

    // create model processors 
    ToopsProcessor source_CPU("source_cpu");
    ToopsProcessor sink_CPU ("sink_cpu");
    ToopsProcessor entity_A_CPU("entity_A_cpu");
    ToopsProcessor entity_B_CPU("entity_B_cpu");

    // create channels
    ToopsChannel sap_A ("SAP_A");
    ToopsChannel sap_B ("SAP_B");
    ToopsChannel line  ("line");

    // create processes that model the protocol entities
    Source producer (&source_CPU, &sap_A, "source");
    Sink   sink   (&sink_CPU,  &sap_B, "sink");
    Entity entity_A (&entity_A_CPU, &sap_A, &line, "entity_A");
    Entity entity_B (&entity_B_CPU, &sap_B, &line, "entity_B");

    // Definition of a variable for the return value of the simulation
    ToopsSimulation::stopReason reason;

    // Start of the simulation
    reason = ToopsSimulation::start(duration);

    // Output reporting the successful completion of the simulation.
    cout << "\n Simulation simpprot completed. Return value is: ";
    cout <<  (int)reason << "\n";
    
    // Wait for user input
    // (may cause a comiler warning: "variable is set but never used")
    cout << "\n -> Press <return> to continue: ";
    char in;
    in = cin.get ();              
        
    return reason;
}
