#if !defined(TNO_LIST_H)
#define TNO_LIST_H

#if !defined(TO_LIST_H)
#include "to_list.h"
#endif

class ToopsNamedObject; // declared in toops.h

//-----------------------------------------------------------------------------
// ToopsNamedObjectLink (source code -> tno_list.cpp)
// ==============================================
// Set up a link to a ToopsNamedObject.
class ToopsNamedObjectLink : public ToopsObjectLink
{
public:
    ToopsNamedObjectLink( ToopsNamedObject* t) : 
       ToopsObjectLink(( ToopsObject*)t) {}
    const char * name(void) const
        { return ((ToopsNamedObject*)_object())->name(); }
    virtual void write(int depth=0, int mode=0) const;
    
    DECLARE_CLASSINFO(ToopsNamedObjectLink); // pt 9.94
    
private:
    // prevent compiler from using copy / default constructor and assignment
    ToopsNamedObjectLink();
    //ToopsNamedObjectLink(const ToopsNamedObjectLink&); //mjk 280895 
    void operator=(const ToopsNamedObjectLink&) {}
};

//-----------------------------------------------------------------------------
// ToopsNamedObjectList (source code -> tno_list.cpp)
// ==============================================
class ToopsNamedObjectList : public ToopsObjectList
{
public:
    // Set up a new (empty) ToopsNamedObjectList. Current is reset.
    ToopsNamedObjectList() : ToopsObjectList() {}
    ~ToopsNamedObjectList() {}

    // Return a pointer to a ToopsNamedObject, if one with the name <who> is held
    // in the list, otherwise 0.
    ToopsNamedObject * _search(const char * who);

    // Check, if the <n> is:
    // - not 0
    // - not empty
    // - unique in the list
    // This function is used only for the system lists to validate a new
    // ToopsNamedObject's name.
    int isNameValid(const char* n);

    virtual void write(int depth = 0, int mode = 0) const;
    
    DECLARE_CLASSINFO(ToopsNamedObjectList); // pt 9.94
    
private:
    // prevent compiler from using copy constructor and assignment
    ToopsNamedObjectList(const ToopsNamedObjectList&) {}
    void operator=(const ToopsNamedObjectList&) {}  
};
#endif
