


#ifndef JUMP_H_INCLUDED
#define JUMP_H_INCLUDED
      

//--------------------------------------------------------------------------
#ifdef _MSC_VER
/***
*setjmp.h - definitions/declarations for setjmp/longjmp routines
*
*   Copyright (c) 1985-1993, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   This file defines the machine-dependent buffer used by
*   setjmp/longjmp to save and restore the program state, and
*   declarations for those routines.
*   [ANSI/System V]
*
****/

#ifndef _INC_SETJMP

#if (_MSC_VER <= 600)
#define __cdecl     _cdecl
#define __far       _far
#endif 

extern "C" {

/* define the buffer type for holding the state information */

#define _JBLEN  9  /* bp, di, si, sp, ret addr, ds */

#ifndef _JMP_BUF_DEFINED
typedef  int  jmp_buf[_JBLEN];
#define _JMP_BUF_DEFINED
#endif 

/* ANSI requires setjmp be a macro */

#define setjmp  _setjmp

/* function prototypes */

//int  __cdecl _setjmp(jmp_buf);
//void __cdecl longjmp(jmp_buf, int);
int   _setjmp(jmp_buf);
void longjmp(jmp_buf, int);
}

#define _INC_SETJMP
#endif 

/* End _MSC_VER */
//--------------------------------------------------------------------------
#elif __hpux
       
// Kopie aus /usr/include/CC
/* @(#) $Revision: 1.101 $ */
#ifndef _SETJMP_INCLUDED /* allow multiple inclusions */
#define _SETJMP_INCLUDED

// The following silly construction is necessary to work around a bug
// in Microsoft Visual C++'s Dependency Checker. Manfred Kraess 22 05 95.
#define _STDSYMS <sys/stdsyms.h>
#include _STDSYMS
             
#ifdef __cplusplus
extern "C" {
#endif

#ifdef _INCLUDE__STDC__
#  ifdef __hp9000s300
#    define _JBLEN 100
#    define _EHLEN 3
#    define _EHCONTEXT_START _JBLEN
     typedef int jmp_buf[_JBLEN + _EHLEN];
#  endif /* __hp9000s300 */
#  ifdef __hp9000s800
#    define _JBLEN 50
#    define _EHLEN 3
#    define _EHCONTEXT_START _JBLEN/2
     typedef double jmp_buf[_JBLEN/2 + _EHLEN];
#  endif /* _p9000s800 */

#  if defined(__STDC__) || defined(__cplusplus)
     extern int setjmp(jmp_buf);
     extern void longjmp(jmp_buf, int);
#  else /* not __STDC__ || __cplusplus */
     extern int setjmp();
     extern void longjmp();
#  endif /* __STDC__ || __cplusplus */

#if defined(__cplusplus)
//   jmp_buf * __EH_JMPBUF_TEMP; / pt 9.94
   extern jmp_buf * __EH_JMPBUF_TEMP;

#define Setjmp(jmpbuf) \
 ( __EH_JMPBUF_TEMP = &(jmpbuf),\
   __eh_save_context(*(jmp_buf*)__EH_JMPBUF_TEMP),\
   setjmp(*__EH_JMPBUF_TEMP))

#define Longjmp(jmpbuf, retval) \
  __EH_JMPBUF_TEMP = &(jmpbuf); \
  __eh_restore_context((*(jmp_buf*) __EH_JMPBUF_TEMP)); \
  longjmp( *__EH_JMPBUF_TEMP, retval); 
#endif /* __cplusplus */
#endif /* _INCLUDE__STDC__ */

#ifdef _INCLUDE_POSIX_SOURCE
#  ifdef __hp9000s800
     typedef double sigjmp_buf[_JBLEN/2];
#  endif /* __hp9000s800 */
#  ifdef __hp9000s300
     typedef int sigjmp_buf[_JBLEN];
#  endif /* __hp9000s300 */

#    if defined(__STDC__) || defined(__cplusplus)
       extern int sigsetjmp(sigjmp_buf, int);
       extern void siglongjmp(sigjmp_buf, int);
#    else /* not __STDC__ || __cplusplus */
       extern int sigsetjmp();
       extern void siglongjmp();
#    endif /* __STDC__ || __cplusplus*/
#endif /* _INCLUDE_POSIX_SOURCE */

#ifdef _INCLUDE_HPUX_SOURCE
#  if defined(__STDC__) || defined(__cplusplus)
     extern int _setjmp(jmp_buf);
     extern void _longjmp(jmp_buf, int);
#  else /* not __STDC__ || __cplusplus */
     extern int _setjmp();
     extern void _longjmp();
#  endif /* __STDC__ || __cplusplus */
#endif /* _INCLUDE_HPUX_SOURCE */

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern void __eh_save_context(jmp_buf);
extern void __eh_restore_context(jmp_buf);
#endif
#endif /*_SETJMP_INCLUDED */
/* End __hpux */
//--------------------------------------------------------------------------

// All other compilers:
//#elif __BCPLUSPLUS__
#else

#include <setjmp.h>

#endif 
/* End #else-part */
//--------------------------------------------------------------------------


#endif // JUMP_H_INCLUDED