#if !defined(TMESSAGE_H)
#define TMESSAGE_H

#if !defined(TOOPS_H)
#include "toops.h"
#endif

#if !defined(TO_LIST_H)
#include "to_list.h"
#endif

class ToopsMessage;
class ToopsChannel;
class ToopsSocket;

//-----------------------------------------------------------------------------
// ToopsMessageLink (declared in message.h)
// ====================================
// Set up a link to a ToopsMessage. See also to_list.h, tno_list.h.
class ToopsMessageLink : public ToopsObjectLink
{
public:
    ToopsMessageLink (ToopsMessage *p) : ToopsObjectLink((ENTRY)p) {}
    virtual void write(int depth = 0, int mode = 0) const;
    ToopsMessage* object(void) { return (ToopsMessage*) _object();}

    DECLARE_CLASSINFO(ToopsMessageLink); // pt 9.94
    
private:
    // prevent compiler from using copy / default constructor and assignment
    ToopsMessageLink();
    //ToopsMessageLink(const ToopsMessageLink&); //mjk 280895
    void operator=(const ToopsMessageLink&);

};


//-----------------------------------------------------------------------------
// ToopsMessage (source code -> message.cpp)
// =====================================
//
// Each instance of a class derived from ToopsMessage _must_ be created
// on the heap (free store, call new). This is crucial for a correct
// ToopsMessage processing of TOOPS, because ToopsMessages will be duplicated
// (see below) and deleted. You know maybe the effects of deleting objects
// that have not been allocated with new.
//
//class ToopsMessage : private ToopsMessageLink / pt 9.94
class ToopsMessage : public ToopsMessageLink
{
friend class ToopsSocket;  
   // accesses only m_timeToopsoReceive( ToopsSocket::send())
public:
    ToopsMessage();
    virtual ~ToopsMessage();

    // This function _must_ be implemented for each ToopsMessage derived class
    // for processing ToopsMessages by TOOPS. It must return an exact copy
    // of a this ToopsMessage !!!!. Don't call ToopsMessage::duplicate() from
    // your own function.
    virtual ToopsMessage* duplicate ();
    simtime receivedAt() const { return m_timeToReceive; }
    virtual void write(int depth = 0, int mode = 0) const;

    DECLARE_CLASSINFO(ToopsMessage); // pt 9.94
    
private:
    ToopsMessageLink sysLink;  // link it in the system list
    simtime m_timeToReceive;

    static ToopsError fOnlyWhenSimStarted;
    static ToopsError fNoDuplicate;

};

//-----------------------------------------------------------------------------
// ToopsMessageList (source code -> message.cpp)
// =========================================
// For explanation see timer.h, to_list.h and tno_list.h
class ToopsMessageList : public ToopsObjectList
{
public:
    ToopsMessageList() : ToopsObjectList() {}
    ~ToopsMessageList() {}
    void insert(ToopsMessageLink &r) { insert(&r); }
    void insert(ToopsMessageLink *p) { _insert((ToopsObjectLink*)p); }
    void append(ToopsMessageLink &r) { append(&r); }
    void append(ToopsMessageLink *p) { _append((ToopsObjectLink*)p); }
    void inserthere(ToopsMessageLink &r) { inserthere(&r); }
    void inserthere(ToopsMessageLink *p) { _inserthere((ToopsObjectLink*)p); }
    void appendhere(ToopsMessageLink &r) { appendhere(&r); }
    void appendhere(ToopsMessageLink *p) { _appendhere((ToopsObjectLink*)p); }
    ToopsMessage *current(void) { return (ToopsMessage*) _current(); }
    ToopsMessage *first(void) { return (ToopsMessage*) _first(); }
    ToopsMessage *last(void) { return (ToopsMessage*) _last(); }
    ToopsMessage *currentLink(void) { return (ToopsMessage*) _currentLink(); }
    ToopsMessage *firstLink(void) { return (ToopsMessage*) _firstLink(); }
    ToopsMessage *lastLink(void) { return (ToopsMessage*) _lastLink(); }

    int next(ToopsMessage*& rp)
    {
        if (_setnext())
        {
            rp = (ToopsMessage*) _current();
            return 1;
        }
        else
            { rp = 0; return 0; }
    }
    int prev(ToopsMessage*& rp)
    {
        if (_setprev())
        {
            rp = (ToopsMessage*) _current();
            return 1;
        }
        else
            { rp = 0; return 0; }
    }
    int getnext(ToopsMessage*& rp)
    {
        ToopsMessage * pptmp;
        if ((pptmp = (ToopsMessage*) _getnext()) != 0)
        {
            rp = pptmp;
            return 1;
        }
        else
            { rp = 0; return 0; }
    }
    int getprev(ToopsMessage*& rp)
    {
        ToopsMessage* pptmp;
        if ((pptmp = (ToopsMessage*) _getprev()) != 0)
        {
            rp = pptmp;
            return 1;
        }
        else
            { rp = 0; return 0; }
    }
    int next(ToopsMessageLink*& rpl)
    {
        if (_setnext())
        {
            rpl = (ToopsMessageLink*) _currentLink();
            return 1;
        }
        else
            { rpl = 0; return 0; }
    }
    int prev(ToopsMessageLink*& rpl)
    {
        if (_setprev())
        {
            rpl = (ToopsMessageLink*) _currentLink();
            return 1;
        }
        else
            return 0;
    }
    int getnext(ToopsMessageLink*& rpl)
    {
        ToopsMessageLink * pptmp;
        if ((pptmp = (ToopsMessageLink*) _getnextlink()) != 0)
        {
            rpl = pptmp;
            return 1;
        }
        else
            { rpl = 0; return 0; }
    }
    int getprev(ToopsMessageLink*& rpl)
    {
        ToopsMessageLink* pptmp;
        if ((pptmp = (ToopsMessageLink*) _getprevlink()) != 0)
        {
            rpl = pptmp;
            return 1;
        }
        else
            { rpl = 0; return 0; }
    }
    
    void remove(ToopsMessageLink* t) { _remove((ToopsObjectLink*)t); }
    ToopsMessage* get(instance_counter num = 0)
        { return (ToopsMessage*)_get(num); }
    ToopsMessage* touch(instance_counter num = 0)
        { return (ToopsMessage*)_touch(num); }
    void del(instance_counter num = 0)
        { _del(num); }
    void write(int depth = 0, int mode = 0) const;
    
    DECLARE_CLASSINFO(ToopsMessageList); // pt 9.94
    
private:
    // prevent compiler from using copy constructor and assignment
    //ToopsMessageList(const ToopsMessageList&); //mjk 280895
    void operator=(const ToopsMessageList&);

};



#endif
