/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                        Modul Description
                        ==================
file name       :  simpproc.cpp
implementation
of class        :  SimpleProcess
author          :  A.Rinkel
version         :  1.0,    date: 09.09. 93
history         :  change, date, name
cardinality     :  n
--------------------------------------------------------------------------*/

// C++ standards
#include <assert.h>
#include <strstrea.h>

// TOOPS simulation base class library
#include <toops.h>
#include <tprocess.h>

// project header
#include "simpproc.h"

//--------------------------------------------------------------------------
SimpleProcess:: SimpleProcess( ToopsProcessor processor, uint prio,
                   const char *name )
              :  ToopsProcess( processor, prio, name )
{  
    // Definition of the member objects
}

SimpleProcess:: ~SimpleProcess()
{
    // Delete the member objects
}


//------------------------------------------------------------------------
void SimpleProcess:: writeProcessInfo( void )
{
    cout << " Process " << name()  << " is running, "
         << " current time: " << time()  << " \n " << flush;
}



//------------------------------------------------------------------------
void SimpleProcess:: behavior(void)
{
    while (1)     // defines the process loop
    {  writeProcessInfo (); // atomic unit,
                            // execution needs no virtual time
       consumeTime (3);     // explicit description of time
    }
}
