#ifndef MULTPROCESS_H
#define MULTPROCESS_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   multprocess.h
class name      :   MultipleProcess
author          :   Andreas Rinkel

documentation   :   At first, describes simple process behavior,
                    realizes output describing the time progress
                    and comsumes time.
                  
                    After a predefined time, 3 processes are created and
                    managed according to the time-slice concept.

version         :   1.0, 09.09.94
history         :   01.04.96  Manfred Kraess
                    clean-up and modification
                  
--------------------------------------------------------------------------*/

// C++ standards
#include <strstrea.h>

// TOOPS simulation class library
#include <tprocess.h>

// project header
#include "process.h"


/* Member Description  ----------------------------------------------------
version       : 1.0,    date: 09.09. 93
history       : change, date, name
cardinality   : n
documentation :
--------------------------------------------------------------------------*/

class MultipleProcess : public ToopsProcess
{
public:
    // constructor and destructor
    MultipleProcess (ToopsProcessor &processor, uint prio, const char *name);
    ~MultipleProcess ();

    // functions that describe the execution flow of this process
    // (see process.h)
    virtual void behavior (void);
    void writeProcessInfo (char *text);

private:
    // pointer to additional processes 
    Process *subProcess1;
    Process *subProcess2;
    Process *subProcess3;
};
#endif
