#include "toops.h"
#include "to_error.h"
#include "strstrea.h"
#include <iomanip.h>
#include <stdlib.h>

// initialize the static var
ToopsError::ERRFUNC ToopsError::userErrorHandler = 0;

ToopsError::ToopsError(int errno, severity s, const char *who, 
    const char *desc) :
    whocausedit(who), description(desc)
{
    number = errno;
    sev = s;
}

void ToopsError::setErrorHandler(ERRFUNC uEH)
{
     userErrorHandler = uEH;
}

void ToopsError::err(const char * xwho, const char * xdesc1,
                 const char * xdesc2, const char * xdesc3,
                 const char * xdesc4, const char * xdesc5)
{
    if (sev == ignore)
        return;

    ostrstream o;
    o << "TOOPS ";
    switch (sev)
         {
         case fatal:
         o << "fatal";
         break;
         case error:
         o << "error";
         break;
         case warning:
         o << "warning";
         break;
		 default:  ; //NOP   mjk 310895
        }
    o << " " << setw(4) << setfill('0') << number << " ";
    o << whocausedit;
    if (xwho)
        o << " " << xwho << " ";
    o << ": " << description;
    if (xdesc1)
        o << " " << xdesc1;
    if (xdesc2)
        o << " " << xdesc2;
    if (xdesc3)
        o << " " << xdesc3;
    if (xdesc4)
        o << " " << xdesc4;
    if (xdesc5)
        o << " " << xdesc5;
    o << ends << o.flush();  // "flush" replaced by "o.flush()" mjk 280895
    char *text = o.str();
// "errno" replaced by "number" mjk 280895  
// (looks like most compilers so far took errno from <stdlib.h> instead of 
//  the local variable "number", so far!!!)  
//    if (userErrorHandler)
//        (*userErrorHandler) (errno, sev, text);
    if (userErrorHandler)
        (*userErrorHandler) (number, sev, text);
    else
        cerr << text << endl;
    delete text;

    if (sev == fatal)
        ::exit(1);
    if (sev == error)
    {
        ToopsSimulation::stopWithError();
    }
}

ToopsError::severity ToopsError::setSeverity( ToopsError::severity newSeverity)
{
    severity tmp = sev;
    sev = newSeverity;
    return tmp;
}
