/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   entity.cpp
implementation
of class        :   Entity
author          :   Andreas Rinkel

version         :   1.0
history         :   23.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/


// C++ standards
#include <strstrea.h>

// TOOPS library

// Project header
#include "entity.h"


//------------------------------------------------------------------------
Entity::Entity(ToopsProcessor *cpu, ToopsChannel *chan_service, 
               ToopsChannel *chan_partner, char *name)
	    : ToopsProcess(cpu, 1, name)
{
    String    _text;

    // Socket that connects the entity to peer entity:
    _text   = name;
    _text  += "peer entity access";
    _peer_entity_access = new ToopsSocket (_text, this, chan_partner);

    // Socket that connects the entity to SAP:
    _text   = name;
    _text  += "service access";
    _service_access     = new Synchron_Socket (_text, this, chan_service);
}

//------------------------------------------------------------------------
Entity:: ~Entity()
{ 
    delete _peer_entity_access;
    delete _service_access;
}

//------------------------------------------------------------------------
void Entity:: behavior (void)
{ 
    ToopsMessage      *_msg;
 
    while (1)
    {
        // Wait for a message on any socket.
        // The behavior of the synchronize() function is defined in toops.h. 
        synchronize(); 

        // If message arrived from peer entity, then 
        //  * get message from the socket
        //  * write a note to stdout
        //  * consume 4 time units
        //    (simulation of protocol processing time in this entity)
        //  * pass the same messge to the SAP (in a "real protocol" this
        //    would be the service primitive "Data.ind")
        //  * deallocate _msg
        if (_peer_entity_access->hasMessage())
        {
            _msg = (TextMessage*) _peer_entity_access->getMsg();

            cout << name() << ": received a message from peer entity at: "
                 << time() << endl;

            consumeTime(4);

            cout << name() << ": passing on message to service user: "
                 << time() << endl;

            _service_access-> send (_msg);
            delete _msg; 
        }
        // If message arrived from the SAP, then 
        //  * get message from the socket
        //  * write a note to stdout
        //  * consume 4 time units
        //    (simulation of protocol processing time in this entity)
        //  * pass the same messge to the peer entity
        //  * deallocate _msg       
        else if (_service_access->hasMessage())
        {
            _msg = (TextMessage*) _service_access->receive();

            cout << name() << ": received message from service user at: "
            << time() << endl;

            consumeTime(4);

            cout << name() << ": passing on message to peer entity: "
                 << time() << endl;

            _peer_entity_access-> send (_msg);
            delete _msg;
        }
        else  cout << "some thing went wrong !";
    }
}

