#ifndef MANAGER_H
#define MANAGER_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   manager.h
class name      :   Manager
author          :   Andreas Rinkel

documentation   :   Port manager class. An object of this class manages all 
					  ports of an Entity object. The main method of this class,
					  trigger(), gets messages from the sockets, checks the 
					  type of message and passes it on to the protocol handler
					  (class Protocol).

version         :   1.0
history         :   25.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards

// TOOPS library
#include <message.h>
#include <procunit.h>
#include <socket.h>
#include <str.h>

// Project header
#include "synsoc.h"
#include "pdu.h"
#include "sdu.h"
#include "protocol.h"


//------------------------------------------------------------------------
class Manager
{
public:
	// Constructor: Sets the member objects _peer_entity_access,
	// _user_access and _prot  
	Manager( ToopsProcess    *entity,
			  ToopsSocket     *to_peer,
			  Synchron_Socket *to_user,
			  Protocol        *prot      );
			  
	// The trigger() method gets any message from any socket of the
	// two sockets _peer_access or _user_access, checks the type
	// of message and passes the received message on to the appropriate
	// protocol handler _prot->handler().
	// Call syncronize() before this function to make sure that there are
	// messages waiting on the sockets.
	void trigger(void);

private:

	// reference to the process using this port manager and to the sockets
	ToopsProcess		*_entity;
	ToopsSocket     	*_peer_access;
	Synchron_Socket	*_user_access;

	// protocol definition
	Protocol			*_prot;
};
#endif
