/****************************************************************************/
/*                                                                          */
/* wammtracelib.c - libreria instrumentata di WAMM                          */
/*                                                                          */
/****************************************************************************/

/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */


#ifndef _wamm_H_
#  define _wamm_H_

#  ifdef __cplusplus
	 extern "C" {
#  endif
    int wamm_setsampling   __ProtoGlarp__(( int, int ));
    int wamm_close           __ProtoGlarp__(( void ));
	int wamm_open           __ProtoGlarp__(( void ));
    int wamm_chprefix        __ProtoGlarp__(( char * ));
    int wamm_scanstring    __ProtoGlarp__(( char * , char *));
    int wamm_scanint       __ProtoGlarp__(( char * , int *));
    int wamm_scanlong      __ProtoGlarp__(( char * , long *));
    int wamm_scanfloat     __ProtoGlarp__(( char * , float *));
    int wamm_scandouble    __ProtoGlarp__(( char * , double *));
    int wamm_print           __ProtoGlarp__(( char * ));
#  ifdef __cplusplus
    int wammOL_print         __ProtoGlarp__(( char * ... ));	
#  else
    int wammOL_print         __ProtoGlarp__(( char *,  ... ));
#  endif


#  ifdef __cplusplus
      }
#  endif

#    define pvm_mytid wamm_mytid
#    define pvm_exit wamm_exit
#    define pvm_recv wamm_recv
#    define pvm_nrecv wamm_nrecv
#    define pvm_trecv wamm_trecv
#    define pvm_send wamm_send
#    define pvm_mcast wamm_mcast
#    define pvm_psend wamm_psend
#    define pvm_precv wamm_precv
#    define pvm_parent wamm_parent

#    ifdef __cplusplus
       extern "C" {
#    endif
     int wamm_mytid           __ProtoGlarp__(( void ));
     int wamm_exit            __ProtoGlarp__(( void ));
     int wamm_recv            __ProtoGlarp__(( int, int ));
     int wamm_nrecv           __ProtoGlarp__(( int, int ));
     int wamm_trecv           __ProtoGlarp__(( int, int, struct timeval * ));
     int wamm_send            __ProtoGlarp__(( int, int ));
     int wamm_mcast           __ProtoGlarp__(( int *, int, int ));
     int wamm_psend           __ProtoGlarp__(( int, int, void *, int, int ));
     int wamm_parent          __ProtoGlarp__(( void ));
     int wamm_precv           __ProtoGlarp__(( int, int, void *, int, int, int *,int *, int * ));
#    ifdef __cplusplus
       }
#    endif

#endif






