/******************************************************************************\
*																			   *
*  util.c - funzioni di utilita` generale			                           *
*																			   *
\******************************************************************************/

/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */


#include "util.h"

/********************************************************/
/* CompressDir (dir, cruncher) - comprime una directory */
/********************************************************/

char * CompressDir (char * dir, int cruncher)
{
	char * tmpname;
	char * ext = "";
	char * finalname;
	char buffer [500];
	int res;
	
	tmpname = tmpnam(NULL);
	sprintf (buffer, "tar cf %s %s", tmpname, dir);
	res = system (buffer);
	if (res) return NULL;
	
	switch (cruncher) {
	
		case 0:	sprintf (buffer, "compress %s", tmpname);
				ext = ".Z";
				break;
				
		case 1: sprintf (buffer, "gzip %s", tmpname);
				ext = ".gz";
				break;
	}
	
	res = system (buffer);
	if (res) {
		unlink (tmpname);
		return NULL;
	}
	
	finalname = calloc (strlen(tmpname)+strlen(ext)+1, 1);	/* ext+NUL */
	sprintf (finalname, "%s%s", tmpname, ext);
	return finalname;
}

/**********************************************************/
/* ReadFile - legge un file e lo restituisce in un buffer */
/**********************************************************/

int ReadFile (char * name, char ** buf)
{
	struct stat * st;
	FILE * fh;
	int len;
	
	st = malloc (sizeof (struct stat));
	if (stat (name, st)) {
		free (st);
		return -1;
	}
	len = st->st_size;
	free (st);
	
	fh = fopen (name, "r");
	if (!fh) return -1;
	*buf = calloc (len+1, 1);
	fread (*buf, 1, len, fh);
	(*buf)[len] = 0;
	fclose (fh);
	
	return (len);
}
