/*****************************************************************************\
*                                                                             *
*  modSpawn.c - Gestione tasks			                                      *
*                                                                             *
\*****************************************************************************/

/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */


#include "modSpawn.h"
#include "modMON.h"

/*********************/
/* Strutture private */
/*********************/

#define STARTSLAVE 500		/* al Tasker per far partire lo slave */ 
#define OK        1
#define CANCEL    2

/*****************************/
/* Variabili globali private */
/*****************************/

static Widget Wtoplevel, dialog, Wfiletext;
static int btn;
static int montype_old; /*contiene il tipo di monitoraggio della precedente spawn */


/*********************/
/* Variabili globali */
/*********************/

int montype;
int *tids_array;
char path_str[64];
int mon_end=1; /* =1 indica che il monitoraggio di una precedente spawn e' terminato */
/***********************/
/* Variabili importate */
/***********************/

extern Widget topshell_mon;
extern int	numhosts;
extern int	maxprocs;
extern int	lung_array;
extern int	done_count;
extern loadentry *loads;
extern hostentry * hosts;

/**********************/
/* Funzioni importate */
/**********************/

extern void initialize_views(Widget);
extern int cerca_file(void);

/********************/
/* Funzioni private */
/********************/

static Boolean SpawnDialog (Widget, char **, char ***, int *, char **, int *, int *);
static void NFY_Start_Slave(void);
static void init_monitor(int);
static void crea_path(Widget);

/**********************/
/* Funzioni pubbliche */
/**********************/

void end_monitoring(void);

/*********************/
/* Callbacks private */
/*********************/

static void ButtonsCB (Widget, int, int);
static void dialogCB(Widget, int, XmSelectionBoxCallbackStruct *);

/***************************************/
/* SpawnInit - inizializzazione modulo */
/***************************************/

void SpawnInit (Widget toplevel)
{
	Wtoplevel = toplevel;
}

/*********************************/
/* SpawnEnd - distruzione modulo */
/*********************************/

void SpawnEnd (void)
{
	/* XXX per ora nulla */
}

/*******************************/
/* SpawnWindow - finestra task */
/*******************************/

void SpawnWindow (struct NetworkObj * no)
{
	Widget Wwait;

	int res, n, ncopies /* YYY */;
	char * tmp;

	char * task;		/* nome task */
	char ** argv;		/* argomenti */
	int flag;			/* flag PVM */
	char * where;		/* host o architettura */
	int ntask;					/* numero copie */
	int output;					/* 1 = cattura l'output */

	int * tids;					/* tid tasks */
	int dtid;					/* dtid host su cui si trova un task */
	struct NetworkObj * taskno;	/* nodo su cui si trova un task */
	
	/*************/
	/* Parametri */
	/*************/
	
	/**** defaults ****/
	
	output = 1;
	
	if (no -> type == NET_HOST) {
		where = no->addr;
		flag = PvmTaskHost;
	}
	
	else {
		flag = PvmTaskDefault;
		where = NULL;
	}
	path_str[0] = '\0';
	
	res = SpawnDialog (no->Wshell, &task, &argv, &flag, &where, &ntask, &output);	
	if (!res) return;
	
	/*********/
	/* spawn */
	/*********/
	
	Wwait = MotifWait (no->Wshell, "Spawn", "Spawning tasks, please wait...");
	
		
	/**** spawn ****/
		
	tids = calloc (ntask, sizeof(int));
	
	if (output) {
		pvm_setopt (PvmOutputTid, PVMTid());
		pvm_setopt (PvmOutputCode, T_TASK_OUT);
	}
	
		
	ncopies = pvm_spawn (task, (char **)argv, flag, where, ntask, tids); /* 
	YYY */
	pvm_setopt (PvmOutputTid, 0);

	XtUnmanageChild (Wwait);
	XtDestroyWidget (Wwait);
	
	
	/******* se fai monitoraggio on line mappa il monitor in primo piano *****/
	if (ncopies != ntask) { 
		montype =0; /* YYY */
		}
	if (montype > 1) {
		XMapRaised(XtDisplay(topshell_mon), XtWindow(topshell_mon));
		NFY_Start_Slave(); /* YYY */
		mon_end =0; /* YYY */
	}
	if (montype ==1) { /* YYY */
		mon_end =0;
		}
	
	/**********************/
	/* mostra i risultati */
	/**********************/
	
	for (n = 0; n<ntask; n++) {
	
		if (tids[n]>0) {
		
			dtid = pvm_tidtohost (tids[n]);
			taskno = NetworkObjFindByDtid (dtid);
			MotifStatusMsg (no->Wstatus, "%s: Tid %x on %s\n", task, tids[n], (taskno ? taskno->addr : (char *)"--------"));
		}
		
		else {	
			tmp = PVMError (tids[n]);
			MotifStatusMsg (no->Wstatus, "%s: FAILED! (%s)\n", task, tmp);
			free (tmp);
		}
	}
	
	/**** rilascia le stringhe ****/
		
	if (argv) while (*argv) {
		free (*argv);
		argv++;
	}
	free (task);
	free (where);	
}

/****************************************/
/* SpawnDialog - dialog argomenti spawn */
/****************************************/

Boolean SpawnDialog (Widget Wshell, char ** task, char ** argv[], int * flag, char ** where, int * ntask, int * output)
{
	Arg args[20];
	int n, i, j;
	
	Widget Wdialog;
	Widget Wtasklabel, Wtasktext;
	Widget Warglabel, Wargtext;
	Widget Wntasklabel, Wntasktext;
	Widget Wsep;
	Widget Wwhere, Wmenupane, Wnoteq, Whosttext;
	Widget Woutput, Wdebug, WMPP, Wtracing, Wsampling;
	Widget Wrcflags;
	Widget Wok, Wcancel;
	Widget Wmenupane1,Wfilename;
	
	char * copies;
	char * arg;
	char * ptr;
	int argc;
	Boolean set;
	int cc;
	int flag1 = 0; 			/* =0 indica il file di traccia di default */
	char str[64];
	/**********/
	/* Dialog */
	/**********/
	
	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate("Spawn", DEFSET)); n++;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_MODELESS); n++;
	XtSetArg (args[n], XmNwidth, 570); n++;
	XtSetArg (args[n], XmNheight, 440); n++;
	XtSetArg (args[n], XmNnoResize, TRUE); n++; /* XXXX Max */
	XtSetArg (args[n], XmNresizePolicy, XmRESIZE_GROW); n++;
	XtSetArg (args[n], XmNautoUnmanage, False); n++;
	Wdialog = XmCreateFormDialog (Wshell, "spawndialog", args, n);
	XtManageChild (Wdialog);

	/********/
	/* Task */
	/********/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("Name:", DEFSET)); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	Wtasklabel = XmCreateLabel (Wdialog, "tasklabel", args, n);
	XtManageChild (Wtasklabel);
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	Wtasktext = XmCreateText (Wdialog, "tasktext", args, n);
	XtManageChild (Wtasktext);

	/***********************/
	/* Argomenti programma */
	/***********************/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("Arguments:", DEFSET)); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	Warglabel = XmCreateLabel (Wdialog, "arglabel", args, n);
	XtManageChild (Warglabel);
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	Wargtext = XmCreateText (Wdialog, "argtext", args, n);
	XtManageChild (Wargtext);

	/*********/
	/* Copie */
	/*********/

	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("Copies:", DEFSET)); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Warglabel); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	Wntasklabel = XmCreateLabel (Wdialog, "ntasklabel", args, n);
	XtManageChild (Wntasklabel);
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Warglabel); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNcolumns, 3); n++;
	Wntasktext = XmCreateText (Wdialog, "ntasktext", args, n);
	XtManageChild (Wntasktext);

	/**** separatore ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wntasklabel); n++;
	XtSetArg (args[n], XmNtopOffset, 30); n++;
	Wsep = XmCreateSeparator (Wdialog, "sep", args, n);
	XtManageChild (Wsep);

	/********/
	/* Dove */
	/********/
	
	n = 0;
	Wmenupane = XmCreatePulldownMenu (Wdialog, "menu", args, n);
	
	if ((*flag & 3) == PvmTaskDefault) {
		MotifAddMenuItem (Wmenupane, "Auto", 0, (XtCallbackProc)ButtonsCB, (void *)1);
		MotifAddMenuItem (Wmenupane, "Arch", 0, (XtCallbackProc)ButtonsCB, (void *)2);
		MotifAddMenuItem (Wmenupane, "Host", 0, (XtCallbackProc)ButtonsCB, (void *)3);
	}
	
	else if ((*flag & 3) == PvmTaskArch) {
		MotifAddMenuItem (Wmenupane, "Arch", 0, (XtCallbackProc)ButtonsCB, (void *)2);
		MotifAddMenuItem (Wmenupane, "Host", 0, (XtCallbackProc)ButtonsCB, (void *)3);
		MotifAddMenuItem (Wmenupane, "Auto", 0, (XtCallbackProc)ButtonsCB, (void *)1);
	}
	
	else {
		MotifAddMenuItem (Wmenupane, "Host", 0, (XtCallbackProc)ButtonsCB, (void *)3);
		MotifAddMenuItem (Wmenupane, "Arch", 0, (XtCallbackProc)ButtonsCB, (void *)2);
		MotifAddMenuItem (Wmenupane, "Auto", 0, (XtCallbackProc)ButtonsCB, (void *)1);
	}
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Where:", DEFSET)); n++;
	XtSetArg (args[n], XmNsubMenuId, Wmenupane); n++;
	Wwhere = XmCreateOptionMenu (Wdialog, "where", args, n);
	XtManageChild (Wwhere);

	/**** != ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wwhere); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNset, *flag & PvmHostCompl); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("!=", DEFSET)); n++;
	Wnoteq = XmCreateToggleButton (Wdialog, "noteq", args, n);
	XtManageChild (Wnoteq);
	XtAddCallback (Wnoteq, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)4);
	
	/**** host/architettura ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wnoteq); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	if (*where) { XtSetArg (args[n], XmNvalue, *where); n++; }
	Whosttext = XmCreateText (Wdialog, "hosttext", args, n);
	XtManageChild (Whosttext);
	
	if ((*flag & 3) == PvmTaskDefault) XtSetSensitive (Whosttext, False);

	/**** separatore ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Whosttext); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	Wsep = XmCreateSeparator (Wdialog, "sep", args, n);
	XtManageChild (Wsep);

	/*********/
	/* Flags */
	/*********/

	/**** RowColumn ****/
	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++;
	XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg (args[n], XmNnumColumns, 1); n++;
	XtSetArg (args[n], XmNspacing, 5); n++;
	XtSetArg (args[n], XmNadjustLast, True); n++;
	Wrcflags = XmCreateRowColumn (Wdialog, "rowcol", args, n); n++;
	XtManageChild (Wrcflags);

	/**** output ****/
	
	n = 0;
	XtSetArg (args[n], XmNset, *output); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Output", DEFSET)); n++;
	Woutput = XmCreateToggleButton (Wrcflags, "output", args, n);
	XtManageChild (Woutput);
	XtAddCallback (Woutput, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)5);

	/**** debug ****/
	
	n = 0;
	XtSetArg (args[n], XmNset, *flag & PvmTaskDebug); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Debug", DEFSET)); n++;
	Wdebug = XmCreateToggleButton (Wrcflags, "debug", args, n);
	XtManageChild (Wdebug);
	
	
	XtAddCallback (Wdebug, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)6);

	/**** MPP ****/
	
	n = 0;
	XtSetArg (args[n], XmNset, *flag & PvmMppFront); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("MPP", DEFSET)); n++;
	WMPP = XmCreateToggleButton (Wrcflags, "MPP", args, n);
	XtManageChild (WMPP);
	XtAddCallback (WMPP, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)7);

	/**** Tracing ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Tracing", DEFSET)); n++;
	Wtracing = XmCreateToggleButton (Wrcflags, "tracing", args, n);
	XtManageChild (Wtracing);
	XtAddCallback (Wtracing, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void
	*)10);
	
	
	/**** Sampling ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Sampling", DEFSET)); n++;
	Wsampling = XmCreateToggleButton (Wrcflags, "sampling", args, n);
	XtManageChild (Wsampling);
	XtAddCallback (Wsampling, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)9);
	
	/******************* filename ******************/
	
	n = 0;
	Wmenupane1 = XmCreatePulldownMenu (Wdialog, "menu", args, n);
	if (!flag1)  {
		MotifAddMenuItem (Wmenupane1, "Default", 0, (XtCallbackProc)ButtonsCB, (void
		*)11);
		MotifAddMenuItem (Wmenupane1, "Filename", 0, (XtCallbackProc)ButtonsCB, (void
		*)12);
	}
	else {
		MotifAddMenuItem (Wmenupane1, "Filename", 0, (XtCallbackProc)ButtonsCB, (void
		*)12);
		MotifAddMenuItem (Wmenupane1, "Default", 0, (XtCallbackProc)ButtonsCB, (void
		*)11);
	}
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wrcflags); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Tracefile name:", DEFSET)); n++;
	XtSetArg (args[n], XmNsubMenuId, Wmenupane1); n++;
	XtSetArg (args[n], XmNsensitive, False); n++;
	Wfilename = XmCreateOptionMenu (Wdialog, "filename", args, n);
	XtManageChild (Wfilename);

	/**** File di traccia ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wfilename); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wrcflags); n++;
	XtSetArg (args[n], XmNtopOffset, 15); n++;
	XtSetArg (args[n], XmNvalue, "/tmp/wammfile"); n++; 
	Wfiletext = XmCreateText (Wdialog, "filetext", args, n);
	XtManageChild (Wfiletext);
	XtSetSensitive (Wfiletext, False);

	/**** separatore ****/
	
	n = 0;
	/*XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wfilename); n++;
	XtSetArg (args[n], XmNtopOffset, 10); n++;	*//* XXX */
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 70); n++;
	Wsep = XmCreateSeparator (Wdialog, "sep", args, n);
	XtManageChild (Wsep);

	/**** OK *****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 25); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Spawn!", DEFSET)); n++;
	Wok = XmCreatePushButton (Wdialog, "ok", args, n);
	XtManageChild (Wok);
	XtAddCallback (Wok, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)1000);

	/**** Cancel *****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 55); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Cancel", DEFSET)); n++;
	Wcancel = XmCreatePushButton (Wdialog, "cancel", args, n);
	XtManageChild (Wcancel);
	XtAddCallback (Wcancel, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)999);

	/**** Situazione iniziale ****/

	btn = -1;
	
	/**** Chiusura = Cancel ****/
	
	MotifProtectShell (XtParent(Wdialog), (XtCallbackProc)ButtonsCB, (void *)999);

	/**** Main Loop ****/
	
	for (;;) {
		XtAppProcessEvent (XtWidgetToApplicationContext(Wdialog), XtIMAll);
		switch (btn) {
		
			case -1:	/* nessun bottone */
						break;
			
			case 1:		/* automatico */
						*flag &= ~3;
						*flag |= PvmTaskDefault;
						XtSetSensitive (Whosttext, False);
						break;
						
			case 2:		/* architettura */
						*flag &= ~3;
						*flag |= PvmTaskArch;
						XtSetSensitive (Whosttext, True);
						break;
						
			case 3:		/* host */
						*flag &= ~3;
						*flag |= PvmTaskHost;						
						XtSetSensitive (Whosttext, True);
						break;
						
			case 4:		/* != */
						*flag ^= PvmHostCompl;
						break;
			
			case 5:		/* output */
						*output ^= 1;
						break;
			
			case 6:		/* debug */
						*flag ^= PvmTaskDebug;
						break;
						
			case 7:		/* MPP */
						*flag ^= PvmMppFront;
						break;
						
			
			case 9:	    /* sampling */
						n=0;
						XtSetArg(args[n], XmNset, &set); n++;
						XtGetValues(Wsampling, args, n);
						if (set) {
							montype = montype + 2;
						}
						else montype = montype - 2;
						break;
						
			case 10:	/* tracing */
						n =0;
						XtSetArg(args[n], XmNset, &set); n++;
						XtGetValues(Wtracing, args, n); 
						if (set) {
							XtSetSensitive(Wfilename, True);
							montype = montype + 1;
						}
						else {
							XtSetSensitive(Wfilename, False);
							montype = montype - 1;
						}
						break;
						
			case 11:	/* filename default */
						path_str[0] = '\0';
						XmTextSetString(Wfiletext,"/tmp/wammfile");
						XtSetSensitive (Wfiletext, False);
						break;
						
			case 12:	/* filename */
						XtSetSensitive (Wfiletext, True);
						if(!dialog) {
							crea_path(Wshell);
						}
						break;
									
			
			case 1000:	/* lancia! */
						
						/**** nome del task ****/
						
						*task = XmTextGetString (Wtasktext);
						if (!*task[0]) {
							XBell (XtDisplay(Wdialog), 0);
							XmTextSetString (Wtasktext, "??? Missing name!");
							free (*task);
							break;
						}
						
						/**** numero di copie ****/
						
						copies = XmTextGetString (Wntasktext);
						if (!*copies) {
							XBell (XtDisplay(Wdialog), 0);
							XmTextSetString (Wntasktext, "???");
							free (copies);
							free (*task);
							break;
						}

						n = 0;
						while (n<strlen(copies) && isdigit(copies[n])) n++;
						if (n<strlen(copies)) {
							XBell (XtDisplay(Wdialog), 0);
							XmTextSetString (Wntasktext, "???");
							free (copies);
							free (*task);
							break;
						}
						*ntask = atoi (copies);
						if (!*ntask) {
							XBell (XtDisplay(Wdialog), 0);
							XmTextSetString (Wntasktext, "???");
							free (copies);
							free (*task);
							break;
						}
						free (copies);
						
						/**** host/architettura ****/
						
						*where = XmTextGetString (Whosttext);
						if (!*where[0] && ((*flag) & 3)) {
							XBell (XtDisplay(Wdialog), 0);
							if (*flag & PvmTaskHost) XmTextSetString (Whosttext, "??? Missing host!");
							else XmTextSetString (Whosttext, "??? Missing architecture!");
							free (*task);
							free (*where);
							break;
						}
						
						/**** argomenti ****/
						
						arg = XmTextGetString (Wargtext);
						
						argc = 0;
						*argv = NULL;
						ptr = strtok(arg, " \t");
						
						while (ptr) {
							argc++;
							*argv = realloc (*argv, argc * sizeof (char *));
							(*argv)[argc-1] = strdup (ptr); 
							ptr = strtok (NULL, " \t");
						}
						
						/**** l'ultimo e` un NULL ****/
						
						if (argc) {
							*argv = realloc (*argv, (argc + 1) * sizeof (char *));
							(*argv)[argc] = NULL;
						}
						
						free (arg);						
						
						init_monitor(montype_old);
						montype_old = montype;
						/**** inserisci il tipo di monitoraggio */
						if ((cc = pvm_insert("monitor", 0, montype)) == PvmDupEntry){
							pvm_delete("monitor", 0);
							pvm_insert("monitor", 0, montype);
						}
						
						/**** chiude tutto ****/
						
						XtUnmapWidget (XtParent(Wdialog));
						XtDestroyWidget (XtParent(Wdialog));
						return True;
						break;
						
			case 999:	/* cancella */
						montype = 0;
						XtUnmapWidget (XtParent(Wdialog));
						XtDestroyWidget (XtParent(Wdialog));
						return False;
		}
		btn = -1;
	}						
}

/*************************************************/
/* ButtonsCB - callback per il "feel" dei dialog */
/*************************************************/

void ButtonsCB (Widget W, int val, int dummy)
{
	btn = val;
}

/***************************************************************/
/* NFY_Start_Slave - avverte i tasker di far partire gli slave */
/***************************************************************/

void NFY_Start_Slave()
{
struct NetworkObj * no;

no = NetworkObjFirst ();
	while (no) {
	
		if (no->type == NET_HOST && no->taskertid) {
			pvm_initsend(PvmDataDefault);			
			pvm_send(no->taskertid, STARTSLAVE);
		}
		no = no->next;
	}
}


/**************************************************************************/
/* init_monitor - inizializza le strutture utilizzate per il monitoraggio */
/**************************************************************************/

void init_monitor(int m_old)
{
	switch (m_old){
			
		case 1:	numhosts = 0;
				maxprocs = 0;
				lung_array = 0;
				done_count = 0;
				free(tids_array);
				break;
	
		case 2:
		case 3:	numhosts = 0;
				maxprocs = 0;
				lung_array = 0;
				done_count = 0;
				free(loads);
				free(hosts);
				free(tids_array);
				XtUnmapWidget(topshell_mon);
				XtDestroyWidget(topshell_mon);
				break;
	
		default: break;
	}

	if (montype == 1){
		tids_array = (int *) calloc(200, sizeof(int));
	}
	else if (montype > 1){
		tids_array = (int *) calloc(200, sizeof(int));
		initialize_views(Wtoplevel);
		
		/* avverto i tasker di attivare gli slaves */
		
		 /* NFY_Start_Slave();	*/ /* YYY */
	}
}	


void end_monitoring(void)
{
mon_end = 1;
montype = 0;
}

void crea_path(Widget w)
{	
	int n;
	Arg args[20];
	
	n = 0;
	XtSetArg(args[n],XmNdialogTitle, XmStringCreate("Tracefile name",DEFSET)); n++;
    dialog=XmCreateFileSelectionDialog(w,"dialog",args,n);
    XtAddCallback(dialog,XmNokCallback,(XtCallbackProc) dialogCB,(void *) OK);
    XtAddCallback(dialog,XmNcancelCallback,(XtCallbackProc) dialogCB,(void *) CANCEL);
    XtUnmanageChild(XmSelectionBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
 	XtManageChild(dialog);
}

void dialogCB(w,client_data,call_data)
    Widget w;
    int client_data;
    XmSelectionBoxCallbackStruct *call_data;
/* callback function for the dialog box */
{
    char *s;
    int found;
    Boolean ris;

    switch (client_data)
    {
        case OK:
         	s=(char *)calloc(50, sizeof(char));
            XmStringGetLtoR(call_data->value, DEFSET ,&s);
            sprintf(path_str,"%s",s);
            found = cerca_file();
            if (!found) {
            	XmTextSetString(Wfiletext, path_str);
            	free(s);
            }
            else {
            	ris = MotifQuestion(w, "overwrite", "The file already exist!\nDo you want overwrite it?");
				if (ris) {
					XmTextSetString(Wfiletext, path_str);
            		free(s);
            	}
            }
            break;
        case CANCEL:
            break;
          
        default: break;
    }
    XtUnmanageChild(w);
    dialog =0;
    XtDestroyWidget(w);
}




