/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */


#include <stdio.h>
#include <Xm/DrawingA.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/List.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <math.h>
#include "modMON.h"
#include "modRedraw.h"

#define  SHOW_COUNT 0
#define  SHOW_BYTES 1
#define  SHOW_AGG_MATRIX 0
#define  SHOW_INT_MATRIX 1


/********************************/
/*   funzioni globali (private) */
/********************************/

double mylog(double);

/*************************************/
extern hostentry *hosts;
extern int numhosts;
#define MAXRANGECHOICES 7
extern rangeentry rangechoices[MAXRANGECHOICES];
extern int commlegendrangelevel;
extern int intcommlegendrangelevel;
extern int maxprocs;
extern int loadxoffset;
extern int loadyoffset;
extern int loadheight;
extern int loadwidth;
extern int loadheightinterval;
extern int  hostutilxoffset;
extern int  hostutilyoffset;
extern int  hostutilheight;
extern int  hostutilwidth;
extern unsigned int hostutilheightinterval;
extern int   memusexoffset;
extern int   memuseyoffset;
extern int   memuseheight;
extern int   memusewidth;
extern unsigned int memuseheightinterval;
extern int utilrecwidth;
extern int utilreccushion;
extern int utilheight;
extern int utilwidth;
extern int utilxoffset;
extern int utilyoffset;

extern int  matrixcommsqwidth; /* vars specific to matrix comm view */
extern int  matrixcommsqcushion;
extern int  matrixcommheight;
extern int  matrixcommwidth;
extern int  matrixcommxoffset;
extern int  matrixcommyoffset;

extern int  commlegendsqwidth; /* vars specific to comm legend */
extern int  commlegendsqcushion;
extern int  commlegendheight;
extern int  commlegendwidth;
extern int  commlegendxoffset;
extern int  commlegendyoffset;

extern int   hostlistsqwidth; /* vars specific to hostlist */
extern int   hostlistsqcushion;
extern int   hostlistycushion;
extern int   hostlistxcushion;
extern int   hostlistheight;
extern int   hostlistwidth;
extern int   hostlistxoffset;
extern int   hostlistyoffset;

extern loadentry *loads;
extern GC mygc, mygcmicro, busygc, idlegc, sendgc, redgc, bluegc;
extern GC grayscalegc[8];


int show_messagesent_value=0;
int show_matrixcomm_value=0;


int matrixcommgrayvalue(int value);
int intmatrixcommgrayvalue(int value);

/**********/
/* mylog  */
/**********/

double mylog(double x)
{
    if (x < 1) return (0.0);
    else return(log(x));
}

/*********************/
/* redrawLoadWindow  */
/*********************/

void redrawLoadWindow(XEvent *event)
{

    double count;
    int xvalue;
    char str[10];
    int i;
    Window root;
    int x,y;
    unsigned int width, height, theight;
    unsigned int border_width;
    unsigned int depth;
    Pixmap pixmap;
    
    if (numhosts == 0) return;  /* happens if 1st event is a scan */
    XGetGeometry(event->xexpose.display, event->xexpose.window,
		 		&root, &x, &y, &width, &height, &border_width, &depth);
    loadwidth = width;
    theight= height - 2*hostlistyoffset;
    loadheightinterval = theight/ (numhosts);
    loadheight = height;
 



    /*  try pix map stuff */
    pixmap = XCreatePixmap (event->xexpose.display,event->xexpose.window,
			    width, height, depth);

    XFillRectangle(event->xexpose.display, pixmap, grayscalegc[0],
		   0,0, width, height);

    for (count=1.0; count <= 1.1; count+=0.5)  {
		xvalue = (int) (log10(count+1.0)*(width)/2.0);
		XDrawLine (event->xexpose.display, pixmap, mygc, 
                xvalue, 0, xvalue, loadheight-1);
        sprintf(str,"%d",(int) count);
		XDrawImageString(event->xexpose.display, pixmap, mygcmicro,
	    				xvalue, loadheight-10,str, strlen(str) );
    }
    count = 2.0;
    xvalue = (int) (log10(count+1.0)*(((float)width)/2.0));
    XDrawLine (event->xexpose.display, pixmap, mygc, 
	       xvalue, 0, xvalue, loadheight-1);

    sprintf(str,"%d",(int) count);
    XDrawImageString(
	event->xexpose.display, pixmap, mygcmicro,
	xvalue, loadheight-10, 
	str, strlen(str) );

    count = 5.0;
    xvalue = (int) (log10(count+1.0)*(((float)width)/2.0));
    XDrawLine (event->xexpose.display, pixmap, mygc, 
	       xvalue, 0, xvalue, loadheight-1);

    sprintf(str,"%d",(int) count);
    XDrawImageString(
	event->xexpose.display, pixmap, mygcmicro,
	xvalue, loadheight-10, 
	str, strlen(str) );

    count = 10.0;
    xvalue = (int) (log10(count+1.0)*(((float)width)/2.0));
    XDrawLine (event->xexpose.display, pixmap, mygc, 
	       xvalue, 0, xvalue, loadheight-1);

    sprintf(str,"%d",(int) count);
    XDrawImageString(
	event->xexpose.display, pixmap, mygcmicro,
	xvalue, loadheight-10, 
	str, strlen(str) );

    for (count=20.0; count <= 70.0; count+=20.0)  {
		xvalue = (int) (log10(count+1.0)*(((float)width)/2.0));
		XDrawLine (event->xexpose.display, pixmap, mygc, 
		   			xvalue, 0, xvalue, loadheight-1);
		sprintf(str,"%d",(int) count);
		XDrawImageString(event->xexpose.display, pixmap, mygcmicro,
			 			xvalue, loadheight-10,str, strlen(str) );
    }

    for (i=0;i<numhosts;i++) {
		xvalue = ((int)(log10(hosts[i].loadvalue+1.0)*(((float)width)/2.0)));
        if (xvalue <= 0) {/*show at least a little rect*/
	    	xvalue = 2;
        }
		XFillRectangle(event->xexpose.display, pixmap, bluegc, 0, 
						hostlistyoffset+(loadheightinterval)*i,xvalue,
						loadheightinterval);
		XDrawRectangle(event->xexpose.display, pixmap, mygc,0, 
						hostlistyoffset+(loadheightinterval)*i,
		       			xvalue,loadheightinterval);
    }
    XCopyArea (event->xexpose.display, pixmap,event->xexpose.window,
	       		mygc, 0, 0, width, height, 0, 0);
    XFreePixmap (event->xexpose.display, pixmap);
}

/************************/
/* redrawHostUtilWindow */
/************************/

void redrawHostUtilWindow(XEvent *event, int index)
{

    /* if index== -1 no need to clear area */
    char str[10];
    int i,j;
    Window root;
    int x,y;
    unsigned int width, height, twidth, theight, heightinterval;
    unsigned int border_width, hostutilwidthinterval;
    unsigned int depth;
    int idlewidth, computewidth, sendwidth;
    Pixmap pixmap;
    
    if (numhosts == 0) return;  /* happens if 1st event is a scan   */

    XGetGeometry(event->xexpose.display, event->xexpose.window,
		 &root, &x, &y, &width, &height, &border_width, &depth);
    hostutilwidth = width;
    hostutilheight = height; 
    twidth= width-hostutilxoffset;
    hostutilwidthinterval = twidth/ (10);
    
    theight= height - 2*hostlistyoffset;
    heightinterval = theight/ (numhosts);
    
    /* get rid of flicker !!! */
    pixmap = XCreatePixmap (event->xexpose.display,event->xexpose.window,
			    width, height, depth);

    XFillRectangle(event->xexpose.display, pixmap, grayscalegc[0],
		   0,0, width, height);  

    for (i=10, twidth = hostutilwidthinterval; 
			twidth <=(10 * hostutilwidthinterval); 
			i+=10,twidth+=hostutilwidthinterval)  {
		XDrawLine (event->xexpose.display, pixmap, mygcmicro, 
		   	twidth, 0, twidth, hostutilheight);
		sprintf(str,"%d%%",i);
		if (i==100)
	    	XDrawImageString(event->xexpose.display, pixmap, 
			     mygcmicro,twidth, hostutilheight-10,str, strlen(str) );
    	}

    
    for (j=0;j<numhosts;j++) {
	hosts[j].totidle_time = 0;
	hosts[j].totprog_time = 0.000000001;
	hosts[j].totsend_time = 0;
	hosts[j].totcompute_time = 0;
	for (i=0; i< maxprocs ;i++) {
	    if (loads[i].hostname != NULL) { 
		if (!strcmp(hosts[j].hostname,loads[i].hostname)) {
		    hosts[j].totidle_time += loads[i].totidle_time;
		    hosts[j].totsend_time += loads[i].totsend_time;
		    hosts[j].totprog_time += loads[i].totprog_time;
		    hosts[j].totcompute_time += loads[i].totcompute_time;
		}
	    }
	}
	idlewidth = (int) (hosts[j].totidle_time / 
			   hosts[j].totprog_time * (10 * hostutilwidthinterval));
	sendwidth = (int) (hosts[j].totsend_time / 
			    hosts[j].totprog_time * (10 * hostutilwidthinterval));
	computewidth = (int) (hosts[j].totcompute_time / 
			       hosts[j].totprog_time * (10 * hostutilwidthinterval));

	XFillRectangle(event->xexpose.display, pixmap, redgc, 
		       0,
		       hostutilyoffset+(heightinterval)*j,
		       idlewidth, heightinterval);
	
	XFillRectangle(event->xexpose.display, pixmap, sendgc, 
		       0+idlewidth,
		       hostutilyoffset+(heightinterval)*j,
		       sendwidth, heightinterval);
	
	XFillRectangle(event->xexpose.display, pixmap, busygc, 
		       0+idlewidth+sendwidth,
		       hostutilyoffset+(heightinterval)*j,
		       computewidth, heightinterval);
	XDrawRectangle(event->xexpose.display, pixmap, mygc, 
		       0,
		       hostutilyoffset+(heightinterval)*j,
		       computewidth+idlewidth+sendwidth, heightinterval);

    }
    XCopyArea (event->xexpose.display, pixmap,event->xexpose.window,
	       mygc, 0, 0, width, height, 0, 0);
    XFreePixmap (event->xexpose.display, pixmap);
}

/*********************/
/*redrawMemUseWindow */
/*********************/

void redrawMemUseWindow(XEvent *event)
{


    char str[10];
    int i,j;
    Window root;
    int x,y;
    unsigned int width, height, twidth, theight, heightinterval;
    unsigned int border_width;
    unsigned int depth;
    int maxrsswidth;
    double scalex;
    Pixmap pixmap;    

    if (numhosts == 0) return;  /* happens if 1st event is a scan */
    XGetGeometry(event->xexpose.display, event->xexpose.window,
		 &root, &x, &y, &width, &height, &border_width, &depth);
    memusewidth = width;
    memuseheight = height; 
    twidth= width-memusexoffset;

    scalex = twidth/ mylog(1.0e9);
    theight= height - 2*hostlistyoffset;
    heightinterval = theight/ (numhosts);
 
    /*  try pix map stuff */
    pixmap = XCreatePixmap (event->xexpose.display,event->xexpose.window,
			    width, height, depth);

    XFillRectangle(event->xexpose.display, pixmap, grayscalegc[0],
		   0,0, width, height);



    for (i=1000; i <= 1.0e8; i*=10)  {
	XDrawLine (event->xexpose.display, pixmap, mygcmicro, 
		   ((int)(mylog(i)*scalex)), 0, ((int)(mylog(i)*scalex)), memuseheight);
	if (i < 1.0e6)
	    sprintf(str,"%dK",i/1000);
	else 
	    sprintf(str,"%dM",(int)(i/1.0e6));
	XDrawImageString(
			 event->xexpose.display, pixmap, 
			 mygcmicro,
			 ((int)(mylog(i)*scalex)), memuseheight-10, 
			 str, strlen(str) );
    }

    
    for (j=0;j<numhosts;j++) {
	hosts[j].maxrss = 0;
	for (i=0; i< maxprocs ;i++) {
	    if (loads[i].hostname != NULL) { 
		if (!strcmp(hosts[j].hostname,loads[i].hostname)) {
		    hosts[j].maxrss += loads[i].maxrss;
		}
	    }
	}
	maxrsswidth = (int) (mylog((double)(hosts[j].maxrss*hosts[j].pagesize))
			     *scalex);

	XFillRectangle(event->xexpose.display, pixmap, bluegc, 
		       0,
		       memuseyoffset+(heightinterval)*j,
		       maxrsswidth, heightinterval);
	XDrawRectangle(event->xexpose.display, pixmap, mygc, 
		       0,
		       memuseyoffset+(heightinterval)*j,
		       maxrsswidth, heightinterval);
    }

    XCopyArea (event->xexpose.display, pixmap,event->xexpose.window,
	       mygc, 0, 0, width, height, 0, 0);
    XFreePixmap (event->xexpose.display, pixmap);

}


/************************/
/*redrawTotalUtilWindow */
/************************/

void redrawTotalUtilWindow(XEvent *event)
{

    
    int yvalue;
    char str[10];
    int i;
    int idleheight, sendheight, computeheight;
    Window root;
    int x,y;
    unsigned int width, height;
    unsigned int border_width;
    unsigned int depth;
    int twidth, theight, heightinterval;
    Pixmap pixmap;


    if (numhosts == 0) return;  /* happens if 1st event is a scan */
    XGetGeometry(event->xexpose.display, event->xexpose.window,
		 &root, &x, &y, &width, &height, &border_width, &depth);
		 
		
    pixmap = XCreatePixmap (event->xexpose.display,event->xexpose.window,
			    width, height, depth);
		
    XFillRectangle(event->xexpose.display, pixmap, grayscalegc[0],
		   0,0, width, height);
		
    twidth = width - utilxoffset;
    
                 
    utilrecwidth=utilreccushion = twidth /(2 * maxprocs);
    utilheight = height;
    utilwidth = width;
    heightinterval = (utilheight-utilyoffset) / 10;
    XDrawLine (event->xexpose.display, pixmap, mygc, 
                utilxoffset-2, 0, utilxoffset-2, utilheight-1);
              
    for (i=10, theight = heightinterval; 
	 theight <=(10 * heightinterval); i+=10, theight+=heightinterval)  {
	XDrawLine (event->xexpose.display, pixmap, mygc, 
                0, theight, utilwidth, theight);
        sprintf(str,"%d%%",100-i);
	XDrawImageString(
	    event->xexpose.display, pixmap, mygcmicro,
	    5, theight, 
	    str, strlen(str) );
    }



    for (i=0;i<maxprocs;i++) {
	yvalue = utilheight - (utilyoffset/4);
        
      sprintf(str,"%d",i);
      if (i%2==0)
	  XDrawImageString(
			   event->xexpose.display, 
			   pixmap, mygcmicro,
			   utilxoffset+(utilrecwidth+utilreccushion)*i, 
			   yvalue, 
			   str, strlen(str) );
		 
		 		
	idleheight = (int) (loads[i].totidle_time / 
			    loads[i].totprog_time * (10 * heightinterval));
		 

	sendheight = (int) (loads[i].totsend_time / 
			    loads[i].totprog_time * (10 * heightinterval));

	computeheight = (int) (loads[i].totcompute_time / 
			    loads[i].totprog_time * (10 * heightinterval));
		 
   
	XFillRectangle(event->xexpose.display, pixmap, redgc, 
		       utilxoffset+(utilrecwidth+utilreccushion)*i,
		       (10 * heightinterval)-idleheight,
		       utilrecwidth, idleheight);

	XFillRectangle(event->xexpose.display, pixmap, sendgc, 
		       utilxoffset+(utilrecwidth+utilreccushion)*i,
		       (10 * heightinterval)-(idleheight+sendheight),
		       utilrecwidth, sendheight);

	XFillRectangle(event->xexpose.display, pixmap, busygc, 
		       utilxoffset+(utilrecwidth+utilreccushion)*i,
		       (10 * heightinterval)-(idleheight+sendheight+
						 computeheight),
		       utilrecwidth, computeheight);
		
   }
    XCopyArea (event->xexpose.display, pixmap,event->xexpose.window,
	       mygc, 0, 0, width, height, 0, 0);
    XFreePixmap (event->xexpose.display, pixmap);
    
    
    
}

/***************************/
/* redrawMessageSentWindow */
/***************************/

void redrawMessageSentWindow(XEvent *event)
{

    int yvalue;
    char str[10];
    int i;

    Window root;
    int x,y;
    unsigned int width, height;
    unsigned int border_width;
    unsigned int depth;
    int twidth, theight, messagewidth;
    double scaley;
    Pixmap pixmap;

    if (numhosts == 0) return;  /* happens if 1st event is a scan */
    XGetGeometry(event->xexpose.display, event->xexpose.window,
		 &root, &x, &y, &width, &height, &border_width, &depth);

    pixmap = XCreatePixmap (event->xexpose.display,event->xexpose.window,
			    width, height, depth);

    XFillRectangle(event->xexpose.display, pixmap, grayscalegc[0],
		   0,0, width, height);



    if (show_messagesent_value == SHOW_COUNT) {
	twidth = width - utilxoffset;
	utilrecwidth=utilreccushion = twidth /(2 * maxprocs);
	utilheight = height;
	utilwidth = width;
	theight = height - utilyoffset;
	scaley = theight/ mylog(1.0e5);
	
	XDrawLine (event->xexpose.display, pixmap, 
		   grayscalegc[2], 
		   utilxoffset-2, 0, utilxoffset-2, utilheight-1);
	
	for (i=1; i <= 11; i+=10) { 
	    XDrawLine (event->xexpose.display, pixmap, 
		       grayscalegc[2], 
		       0,theight-((int)(mylog((double)i)*scaley)) , utilwidth,
		       theight-((int)(mylog((double)i)*scaley)) );
	    sprintf(str,"%d",i-1);
	    if (i==11 || i==1)
		XDrawImageString(
				 event->xexpose.display, 
				 pixmap, mygc,
				 5, theight-((int)(mylog(i)*scaley)), 
				 str, strlen(str) );
	}
	
	for (i=100; i <= 10000; i*=10) { 
	    XDrawLine (event->xexpose.display, pixmap, 
		       grayscalegc[2], 
		       0,theight-((int)(mylog((double)i)*scaley)) , utilwidth,
		       theight-((int)(mylog((double)i)*scaley)) );
	    sprintf(str,"%d",i);
	    XDrawImageString(
			     event->xexpose.display, pixmap, 
			     mygc,
			     5, theight-((int)(mylog((double)i)*scaley)), 
			     str, strlen(str) );
	}
	
	for (i=0;i<maxprocs;i++) {
	    yvalue = utilheight - (utilyoffset/4);
	    
	    sprintf(str,"%d",i);
	    if (i%2==0)
		XDrawImageString(
				 event->xexpose.display, 
				 pixmap, mygcmicro,
				 utilxoffset+(utilrecwidth+utilreccushion)*i, 
				 yvalue, 
				 str, strlen(str) );
	    
	    messagewidth = ((int)(mylog((double)(loads[i].interval_sent+1))
				  *scaley));
	    XFillRectangle(event->xexpose.display, pixmap, 
			   bluegc, 
			   utilxoffset+(utilrecwidth+utilreccushion)*i,
			   theight-messagewidth,
			   utilrecwidth, messagewidth);
	    
	}
    }
    else {
	twidth = width - utilxoffset;
	utilrecwidth=utilreccushion = twidth /(2 * maxprocs);
	utilheight = height;
	utilwidth = width;
	theight = height - utilyoffset;
	scaley = theight/ mylog(1.0e8);
	
	XDrawLine (event->xexpose.display, pixmap, 
		   grayscalegc[2], 
		   utilxoffset-2, 0, utilxoffset-2, utilheight-1);
	
	for (i=1; i <= 1001; i+=1000) { 
	    XDrawLine (event->xexpose.display, pixmap, 
		       grayscalegc[2], 
		       0,theight-((int)(mylog((double)i)*scaley)) , utilwidth,
		       theight-((int)(mylog((double)i)*scaley)) );
	    sprintf(str,"%dK",(i-1)/1000);
	    if (i==1001 || i==1)
		XDrawImageString(
				 event->xexpose.display, 
				 pixmap, mygcmicro,
				 5, theight-((int)(mylog(i)*scaley)), 
				 str, strlen(str) );
	}
	
	for (i=10000; i < 1e8; i*=10) { 
	    XDrawLine (event->xexpose.display, pixmap, 
		       grayscalegc[2], 
		       0,theight-((int)(mylog((double)i)*scaley)) , utilwidth,
		       theight-((int)(mylog((double)i)*scaley)) );
	    sprintf(str,"%dK",i/1000);
	    if (i >= 1000000) sprintf(str,"%dM",i/1000000); 
	    XDrawImageString(
			     event->xexpose.display, pixmap, 
			     mygcmicro,
			     5, theight-((int)(mylog((double)i)*scaley)), 
			     str, strlen(str) );
	}
	
	for (i=0;i<maxprocs;i++) {
	    yvalue = utilheight - (utilyoffset/4);
	    
	    sprintf(str,"%d",i);
	    if (i%2==0)
		XDrawImageString(
				 event->xexpose.display, 
				 pixmap, mygcmicro,
				 utilxoffset+(utilrecwidth+utilreccushion)*i, 
				 yvalue, 
				 str, strlen(str) );
	    
	    messagewidth = ((int)(mylog((double)(loads[i].interval_bytes_sent+1))
				  *scaley));
	    XFillRectangle(event->xexpose.display, pixmap, 
			   bluegc, 
			   utilxoffset+(utilrecwidth+utilreccushion)*i,
			   theight-messagewidth,
			   utilrecwidth, messagewidth);
	    
	}

    }

        XCopyArea (event->xexpose.display, pixmap,event->xexpose.window,
		   mygc, 0, 0, width, height, 0, 0);
        XFreePixmap (event->xexpose.display, pixmap);

}

/**************************/
/* redrawMatrixCommWindow */
/**************************/

void redrawMatrixCommWindow(XEvent *event)
{

    int i,j;
    char str[40];
    Window root;
    int x,y;
    unsigned int width, height;
    unsigned int border_width;
    unsigned int depth;
    int twidth, theight;
    Pixmap pixmap;


    if (numhosts == 0) return;  /* happens if 1st event is a scan */
    XGetGeometry(event->xexpose.display, event->xexpose.window,
		 &root, &x, &y, &width, &height, &border_width, &depth);
    pixmap = XCreatePixmap (event->xexpose.display,event->xexpose.window,
			    width, height, depth);

    XFillRectangle(event->xexpose.display, pixmap, grayscalegc[0],
		   0,0, width, height);


    twidth = width - matrixcommxoffset;
    theight= height - matrixcommyoffset;
    matrixcommsqcushion =1;
    theight = theight - (maxprocs * matrixcommsqcushion);
    twidth  = twidth  - (maxprocs * matrixcommsqcushion);
    if (twidth < theight) 
	matrixcommsqwidth =twidth /(maxprocs);
    else 
	matrixcommsqwidth = theight / maxprocs;
    matrixcommwidth = width;
    matrixcommheight = height;
    if (show_matrixcomm_value== SHOW_AGG_MATRIX) {	
	/* legend stuff */
	for (i=1; i< 8;i++) {
	    XFillRectangle(event->xexpose.display, pixmap, 
			   grayscalegc[i], 
			   commlegendxoffset,
			   commlegendyoffset+
			   (commlegendsqwidth+
			    commlegendsqcushion)*i,
			   commlegendsqwidth, commlegendsqwidth);
	    
	    if (rangechoices[commlegendrangelevel].rangemax[i-1] == 
		(rangechoices[commlegendrangelevel].rangemax[i]-1))
		sprintf(str," %d", rangechoices[commlegendrangelevel].rangemax[i]-1);	    
	    else 
		sprintf(str," %d - %d",
			rangechoices[commlegendrangelevel].rangemax[i-1],
			rangechoices[commlegendrangelevel].rangemax[i]-1);
	    
	    XDrawImageString(
			     event->xexpose.display, pixmap, mygcmicro,
			     commlegendxoffset+commlegendsqwidth
			     +commlegendsqcushion+1, 
			     commlegendyoffset+
			     (commlegendsqwidth+commlegendsqcushion)*(i+1), 
			     str, strlen(str) );
	}
	
	XDrawRectangle(event->xexpose.display, pixmap, 
		       mygc, 
		       commlegendxoffset,
		       commlegendyoffset+
		       (commlegendsqwidth+commlegendsqcushion)*0,
		       commlegendsqwidth, commlegendsqwidth);
	
	sprintf(str," 0 Messages");
	XDrawImageString(
			 event->xexpose.display, pixmap, mygcmicro,
			 commlegendxoffset+commlegendsqwidth
			 +commlegendsqcushion+1, 
			 commlegendyoffset+
			 (commlegendsqwidth+commlegendsqcushion)*(1), 
			 str, strlen(str) );
	
	/* matrix view */
	for (i=0; i< maxprocs; i++) {
	    sprintf(str,"%d",i);
	    if (i%2==0)
		XDrawImageString(
				 event->xexpose.display, pixmap, mygcmicro,
				 matrixcommxoffset+
				 (matrixcommsqwidth+matrixcommsqcushion)*i, 
				 matrixcommyoffset/2, 
				 str, strlen(str) );
	    XDrawLine (event->xexpose.display, pixmap, mygc, 
		       matrixcommxoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*i-
		       matrixcommsqcushion,
		       matrixcommyoffset-matrixcommsqcushion,
		       matrixcommxoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*i-
		       matrixcommsqcushion,
		       matrixcommyoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*
		       maxprocs-matrixcommsqcushion);
	}
	
	for (i=1; i<= maxprocs; i++) {
	    sprintf(str,"%d",i-1);
	    if ((i-1) %2==0)
		XDrawImageString(
				 event->xexpose.display, pixmap, mygcmicro,
				 matrixcommxoffset-15, 
				 matrixcommyoffset+
				 (matrixcommsqwidth+matrixcommsqcushion)*i, 
				 str, strlen(str) );
	    
	    XDrawLine (event->xexpose.display, pixmap, mygc, 
		       matrixcommxoffset-matrixcommsqcushion,
		       matrixcommyoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*i-
		       matrixcommsqcushion,
		       matrixcommxoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*
		       maxprocs-matrixcommsqcushion,		   
		       matrixcommyoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*i-
		       matrixcommsqcushion);

	}
	
	for (i=0; i< maxprocs ;i++) {
	    for (j=0; j< maxprocs; j++) {
		XFillRectangle(event->xexpose.display, pixmap, 
			       grayscalegc[matrixcommgrayvalue(loads[i].send_vector[j])], 
			       matrixcommxoffset+
			       (matrixcommsqwidth+matrixcommsqcushion)*j,
			       matrixcommyoffset+
			       (matrixcommsqwidth+matrixcommsqcushion)*i,
			       matrixcommsqwidth, matrixcommsqwidth);
	    }
	}
    }

    else {  /*  INTERVAL MATRIX STUFF */
	/* legend stuff */
	for (i=1; i< 8;i++) {
	    XFillRectangle(event->xexpose.display, pixmap, 
			   grayscalegc[i], 
			   commlegendxoffset,
			   commlegendyoffset+
			   (commlegendsqwidth+commlegendsqcushion)*i,
			   commlegendsqwidth, commlegendsqwidth);
	    /*  */
	    if (rangechoices[intcommlegendrangelevel].rangemax[i-1] == 
		(rangechoices[intcommlegendrangelevel].rangemax[i]-1))
		sprintf(str," %d", rangechoices[intcommlegendrangelevel].rangemax[i]-1);	    
	    else 
		sprintf(str," %d - %d",
			rangechoices[intcommlegendrangelevel].rangemax[i-1],
			rangechoices[intcommlegendrangelevel].rangemax[i]-1);
	    
	    XDrawImageString(
			     event->xexpose.display, pixmap, mygcmicro,
			     commlegendxoffset+commlegendsqwidth
			     +commlegendsqcushion+1, 
			     commlegendyoffset+
			     (commlegendsqwidth+commlegendsqcushion)*(i+1), 
			     str, strlen(str) );
	}
	
	XDrawRectangle(event->xexpose.display, pixmap, 
		       mygc, 
		       commlegendxoffset,
		       commlegendyoffset
		       +(commlegendsqwidth+commlegendsqcushion)*0,
		       commlegendsqwidth, commlegendsqwidth);
	
	sprintf(str," 0 Messages");
	XDrawImageString(
			 event->xexpose.display, pixmap, mygcmicro,
			 commlegendxoffset+commlegendsqwidth
			 +commlegendsqcushion+1, 
			 commlegendyoffset+
			 (commlegendsqwidth+commlegendsqcushion)*(1), 
			 str, strlen(str) );
	
	/* matrix view (INTERVAL) */
	for (i=0; i< maxprocs; i++) {
	    sprintf(str,"%d",i);
	    if (i%2==0)
		XDrawImageString(
				 event->xexpose.display, pixmap, mygcmicro,
				 matrixcommxoffset+
				 (matrixcommsqwidth+matrixcommsqcushion)*i, 
				 matrixcommyoffset/2, 
				 str, strlen(str) );
	    XDrawLine (event->xexpose.display, pixmap, mygc, 
		       matrixcommxoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*i-
		       matrixcommsqcushion,
		       matrixcommyoffset-matrixcommsqcushion,
		       matrixcommxoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*i-
		       matrixcommsqcushion,
		       matrixcommyoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*
		       maxprocs-matrixcommsqcushion);
	}
	
	for (i=1; i<= maxprocs; i++) {
	    sprintf(str,"%d",i-1);
	    if ((i-1) %2==0)
		XDrawImageString(
				 event->xexpose.display, pixmap, mygcmicro,
				 matrixcommxoffset-15, 
				 matrixcommyoffset+
				 (matrixcommsqwidth+matrixcommsqcushion)*i, 
				 str, strlen(str) );
	    
	    XDrawLine (event->xexpose.display, pixmap, mygc, 
		       matrixcommxoffset-matrixcommsqcushion,
		       matrixcommyoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*i-
		       matrixcommsqcushion,
		       matrixcommxoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*
		       maxprocs-matrixcommsqcushion,		   
		       matrixcommyoffset+
		       (matrixcommsqwidth+matrixcommsqcushion)*i-
		       matrixcommsqcushion);
	}
	
	for (i=0; i< maxprocs ;i++) {
	    for (j=0; j< maxprocs; j++) {
		XFillRectangle(event->xexpose.display, pixmap, 
			       grayscalegc[intmatrixcommgrayvalue(loads[i].int_send_vector[j])], 
			       matrixcommxoffset+
			       (matrixcommsqwidth+matrixcommsqcushion)*j,
			       matrixcommyoffset+
			       (matrixcommsqwidth+matrixcommsqcushion)*i,
			       matrixcommsqwidth, matrixcommsqwidth);
	    }
	}
    }

    XCopyArea (event->xexpose.display, pixmap,event->xexpose.window,
	       mygc, 0, 0, width, height, 0, 0);
    XFreePixmap (event->xexpose.display, pixmap);

}

/************************/
/* redrawHostListWindow */
/************************/

void redrawHostListWindow(XEvent *event)
{

    int i,j,first_time;
    char str[30];
    char hlist[300];
    Window root;
    int x,y;
    unsigned int width, height;
    unsigned int border_width;
    unsigned int depth;
    int theight, heightinterval;
    if (numhosts == 0) return;  /* happens if 1st event is a scan */
    XGetGeometry(event->xexpose.display, event->xexpose.window,
		 &root, &x, &y, &width, &height, &border_width, &depth);
    XClearArea(event->xexpose.display, event->xexpose.window, 0,0,0,0,False);
    theight= height - 2*hostlistyoffset;
    heightinterval = theight/ (numhosts);

    for (i=1; i<= numhosts; i++) {
	sprintf(str,"%d",i-1);
	XDrawImageString(
	    event->xexpose.display, event->xexpose.window, mygcmicro,
	    2, 
	    hostlistyoffset+(heightinterval)*i, 
	    hosts[i-1].hostname, strlen(hosts[i-1].hostname) );
    }

    for (j=1; j <= numhosts; j++) {
	first_time=1;
	sprintf(hlist, " ");
	for (i=0; i< maxprocs ;i++) {
	    if (loads[i].hostname != NULL) { 
		if (!strcmp(hosts[j-1].hostname,loads[i].hostname)) {
		    if (first_time) {
			sprintf(hlist, "%d", i);
			first_time = 0;	

		    }
		    else {
			sprintf(str, ",%d",i);
			strcat(hlist,str);
		    }
		}
	    }
	}
	XDrawImageString(
	    event->xexpose.display, event->xexpose.window, mygcmicro,
	    hostlistxoffset, 
	    hostlistyoffset+(heightinterval)*j, 
	    hlist, strlen(hlist) );
    }
	    

}

/************************/
/* matrixcommgrayvalue  */
/************************/

int matrixcommgrayvalue(int value)
{

    if (value < rangechoices[commlegendrangelevel].rangemax[0]) 
	return 0;
    else if (value < rangechoices[commlegendrangelevel].rangemax[1])
	return 1;
    else if (value < rangechoices[commlegendrangelevel].rangemax[2])
	return 2;
    else if (value < rangechoices[commlegendrangelevel].rangemax[3])
	return 3;
    else if (value < rangechoices[commlegendrangelevel].rangemax[4])
	return 4;
    else if (value < rangechoices[commlegendrangelevel].rangemax[5])
	return 5;
    else if (value < rangechoices[commlegendrangelevel].rangemax[6])
	return 6;
    else  return 7;

}

/**************************/
/* intmatrixcommgrayvalue */
/**************************/

int intmatrixcommgrayvalue(int value)
{

    if (value < rangechoices[intcommlegendrangelevel].rangemax[0]) 
	return 0;
    else if (value < rangechoices[intcommlegendrangelevel].rangemax[1])
	return 1;
    else if (value < rangechoices[intcommlegendrangelevel].rangemax[2])
	return 2;
    else if (value < rangechoices[intcommlegendrangelevel].rangemax[3])
	return 3;
    else if (value < rangechoices[intcommlegendrangelevel].rangemax[4])
	return 4;
    else if (value < rangechoices[intcommlegendrangelevel].rangemax[5])
	return 5;
    else if (value < rangechoices[intcommlegendrangelevel].rangemax[6])
	return 6;
    else  return 7;

}







