/*****************************************************************************\
*                                                                             *
*  modPVM.h - gestione PVM							                          *
*                                                                             *
\*****************************************************************************/

/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */


#ifndef MODPVM_H
#define MODPVM_H

#include <pvm3.h>
#include <pvmtev.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/socket.h>		/* per rexec */
#include <pwd.h>			/* per getpwuid (PVMRepair) */
#include <sys/resource.h>

#include <stddef.h>
#include <dirent.h>
	
#include "motifutil.h"
#include "tags.h"
#include "version.h"


/********/
/* Defs */
/********/

#define PVM_ENDSOFT	0		/* uscita "soft" */
#define PVM_ENDHARD	1		/* uscita "hard" (halt) */
#define PVM_ENDFAIL	2		/* uscita di emergenza! */

/***********/
/* Esterni */
/***********/

extern void pvmendtask (void);
extern void end_monitoring(void);

/**********/
/* Moduli */
/**********/

#include "modTasks.h"
#include "modMake.h"
#include "modSpawn.h"
#include "modWAN.h"
#include "modMAN.h"
#include "modLAN.h"
#include "modNetworkObj.h"

/********/
/* Init */
/********/

void PVMInit (struct NetworkObj *, Widget);

/*******/
/* End */
/*******/

void PVMEnd (int);

/**********************/
/* Funzioni pubbliche */
/**********************/

int				PVMTid (void);
char * 			PVMError (int);
void 			PVMCmd (struct HostCmd *);
void			PVMAdd (struct NetworkObj *, int, char **, Boolean *);
void			PVMDel (struct NetworkObj *, int, char **, Boolean *);
void			PVMCheck (struct NetworkObj *, int, char **, Boolean *);
void			PVMRepair (struct NetworkObj *, int, char **, Boolean *);

#endif
