/*****************************************************************************\
*                                                                             *
*  modNetworkObj.c - Lista generale rete			                          *
*                                                                             *
\*****************************************************************************/

/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */
 

#include "modNetworkObj.h"

/*********************/
/* strutture private */
/*********************/

struct NetworkObjList {
	struct NetworkObj * first;
	struct NetworkObj * last;
	int num;
};

/*******************************/
/* variabili globali (private) */
/*******************************/

struct NetworkObjList * NOL;

/******************/
/* NetworkObjInit */
/******************/

void NetworkObjInit (void)
{
	NOL = calloc (1, sizeof (struct NetworkObjList));
}

/*****************/
/* NetworkObjEnd */
/*****************/

void NetworkObjEnd (void)
{
	/* XXX niente per ora */
}

/*****************/
/* NetworkObjAdd */
/*****************/

struct NetworkObj * NetworkObjAdd (char * name, int type)
{
	struct NetworkObj * no;
	
	no = calloc (1, sizeof (struct NetworkObj));
	no -> name = strdup (name);
	no -> type = type;
		
	if (!NOL->num) NOL->first = no;
	else NOL->last->next = no;
	NOL->last = no;
	
	NOL->num++;
	return no;
}

/******************/
/* NetworkObjFind */
/******************/

/* name=NULL fa da jolly... */

struct NetworkObj * NetworkObjFind (char * name, int type)
{
	struct NetworkObj * no;
	
	no = NOL->first;
	if (!name) while (no && no->type != type) no = no->next;	
	else while (no && (strcmp(no->name,name) || no->type != type)) no = no->next;
	return no;
}

/************************/
/* NetworkObjFindByAddr */
/************************/

struct NetworkObj * NetworkObjFindByAddr (char * addr)
{
	struct NetworkObj * no;
	
	no = NOL->first;
	while (no && (no->type != NET_HOST || strcmp(no->addr,addr))) no = no->next;
	return no;
}

/************************/
/* NetworkObjFindByDtid */
/************************/

struct NetworkObj * NetworkObjFindByDtid (int dtid)
{
	struct NetworkObj * no;
	
	no = NOL->first;
	while (no && ((no->type != NET_HOST) || (no->dtid != dtid))) no = no->next;
	return no;
}


/*******************/
/* NetworkObjFirst */
/*******************/

struct NetworkObj * NetworkObjFirst (void)
{
	return NOL->first;
}
