/*****************************************************************************\
*                                                                             *
*  modInizialize.c - inizialize monitior for Wamm			                  *
*                                                                             *
\*****************************************************************************/

/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */


#include "modInitialize.h"
#include "modTasks.h"
#include "motifutil.h"
#include "pvm3.h"
#include "modMON.h"

#define DEFSET XmSTRING_DEFAULT_CHARSET
#define MAXRANGECHOICES 7
#define OL_MODIFYMINSECS 11
#define INTERACTTAG 0x22cb173d

#define  SHOW_COUNT 0
#define  SHOW_BYTES 1
#define  SHOW_AGG_MATRIX 0
#define  SHOW_INT_MATRIX 1

/*********************/
/* strutture private */
/*********************/

struct TaskList_mon {
	struct Task_mon * first;	/* primo task della lista */
	struct Task_mon * last;		/* ultimo task della lista */
	int ntask_mon;				/* numero di tasks */
};

struct Task_mon {
	struct Task_mon * next;		/* task successivo nella lista */
	int tid;				/* tid del task */
};

struct Task {
	struct Task * prev;		/* task precedente nella lista */
	struct Task * next;		/* task successivo nella lista */
	int tid;				/* tid del task */
	int zombie;				/* 1=task terminato */
	int system;				/* 1=task di sistema (PVMHoster, PVMTasker, PVMMaker) */
	char * name;			/* nome del task */
	char * host;			/* indirizzo del'host su cui gira il task */
	char * out;				/* output prodotto dal task */
	Widget Woutshell;		/* finestra output (0 = non aperta) */
	Widget Wouttext;		/* text output (0 = non aperta) */
};

/******************************/
/* Funzioni globali (private) */
/******************************/

static void create_GC();
static void initialize_rangelevels();
static void anim_trf(char *);

/**********************/
/* funzioni importate */
/**********************/

extern void NFY_Sample_Delay(int);
extern  struct Task * FindTaskByTid (int);

/*********************/
/* variabili globali */
/*********************/

loadentry *loads;
hostentry *hosts;
rangeentry rangechoices[MAXRANGECHOICES];

int intcommlegendrangelevel;
GC mygc, mygcmicro, busygc, idlegc, sendgc, redgc, bluegc;
GC grayscalegc[8];

int loadxoffset;
int loadyoffset=0;
int loadheight;
int loadwidth;
unsigned int loadheightinterval;
int hostutilxoffset;
int hostutilyoffset=0;
int hostutilheight;
int hostutilwidth;
unsigned int hostutilheightinterval;
int memusexoffset;
int memuseyoffset=0;
int memuseheight;
int memusewidth;
unsigned int memuseheightinterval;

int	utilrecwidth;   /* vars specific to utilization views*/
int utilreccushion;
int utilheight;
int utilwidth;
int utilxoffset;
int utilyoffset;


int matrixcommsqwidth; /* vars specific to matrix comm view*/
int matrixcommsqcushion;
int matrixcommheight;
int matrixcommwidth;
int matrixcommxoffset;
int matrixcommyoffset;
  

int commlegendsqwidth; /* vars specific to comm legend*/
int commlegendsqcushion;
int commlegendheight;
int commlegendwidth;
int commlegendxoffset;
int commlegendyoffset;

int hostlistsqwidth; /* vars specific to hostlist*/
int hostlistycushion;
int hostlistxcushion;
int hostlistsqcushion;
int hostlistheight;
int hostlistwidth;
int hostlistxoffset;
int hostlistyoffset;

/*****************************/
/* variabili globali private */
/*****************************/

static Display *display;
static Widget dialog;

/***********************/
/* variabili importate */
/***********************/

extern rangeentry rangechoices[MAXRANGECHOICES];
extern int commlegendrangelevel;
extern int *tids_array;
extern int lung_array;	/* specifica la dimensione di tids_array */
extern int done_count;
extern struct TaskList_mon * TL_mon;	/* la lista dei tasks */
extern XmTextPosition wpr_position;
extern int show_messagesent_value;
extern int show_matrixcomm_value;
extern int numhosts;

/*******************/
/* widgets globali */
/*******************/

Widget  topshell_mon, loadinfo,form, text_output;
Widget  totalutil;
Widget  messagesent;
Widget  matrixcomm;
Widget  hostlist;
Widget  hostutil;
Widget  memuse;
Widget 	messagesentbutton, matrixcommbutton;
Widget 	totalutillabel,hostlistlabel ;
Widget 	hostutillabel,memuselabel, loadinfolabel;
Widget 	scale;
Widget 	tasklistlabel, tasklist,tasklistlabel2,scalelabel;
Widget  paned,topform;
Widget  menubar, menupane;
Widget  legend, legendshell;

/*Callback*/



/***********/
/* CloseCB */
/***********/

void CloseCB (Widget w, XtPointer client_data, XmAnyCallbackStruct *call_data)
{	
	XtUnmapWidget (topshell_mon);
	XtUnmapWidget (legendshell);
}

/**************/
/* TasksWinCB */
/**************/

void TasksWinCB (Widget w,XtPointer client_data, XmAnyCallbackStruct *call_data)
{
	TasksWindow();
}

/*****************/
/* ClearStatusCB */
/*****************/

void ClearStatusCB (Widget w,XtPointer client_data, XmAnyCallbackStruct *call_data)
{	
	MotifClearText (text_output);
}


/*****************/
/* samplescaleCB */
/*****************/

void samplescaleCB(Widget widget,XtPointer data, 
		    XmScaleCallbackStruct *cbs)
{
    int type=OL_MODIFYMINSECS;
    
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&type, 1, 1);
    pvm_pkint(&cbs->value, 1, 1);
    pvm_mcast(tids_array,lung_array,INTERACTTAG);
    NFY_Sample_Delay(cbs->value);
}

/**************/
/* exposureCB */
/**************/

void exposureCB (Widget widget,XtPointer client_data,XtPointer call_data)
{	
	char *str;
	str = calloc(40,1);
	XFillRectangle(XtDisplay(legendshell), XtWindow(legend), grayscalegc[0], 0, 0, 300,
	200);			
	XFillRectangle(XtDisplay(legendshell), XtWindow(legend), busygc, 20, 20, 20,20);
	XFillRectangle(XtDisplay(legendshell), XtWindow(legend), sendgc, 20, 90, 20,20);
	XFillRectangle(XtDisplay(legendshell), XtWindow(legend), redgc, 20, 160, 20,20);
	XDrawRectangle(XtDisplay(legendshell), XtWindow(legend), mygc, 20, 20, 20,20);
	XDrawRectangle(XtDisplay(legendshell), XtWindow(legend), mygc, 20, 90, 20,20);
	XDrawRectangle(XtDisplay(legendshell), XtWindow(legend), mygc, 20, 160, 20,20);
	sprintf(str,"%s","Computing");
	XDrawImageString(XtDisplay(legendshell), XtWindow(legend), mygcmicro, 60, 40,
	str, strlen(str)); 
	sprintf(str,"%s","Sending PVM messages");
	XDrawImageString(XtDisplay(legendshell), XtWindow(legend), mygcmicro, 60, 110,
	str, strlen(str));
	sprintf(str,"%s","Idle waiting to receive PVM messages");
	XDrawImageString(XtDisplay(legendshell), XtWindow(legend), mygcmicro, 60, 180,
	str, strlen(str)); 
	free(str);
}

/****************/
/* ShowLegendCB */
/****************/

void ShowLegendCB(void)
{
	XMapRaised(XtDisplay(legendshell), XtWindow(legendshell));
}

/****************/
/* HidelegendCB */
/****************/

void HideLegendCB(void)
{
	XtUnmapWidget(legendshell);
}

/************/
/* OutputCB */
/************/

void OutputCB(Widget w,int dummy1, int dummy2)
{
	int * list;
	int n, num, tid;
	Boolean mem;
	struct Task * task;
	
	/******************************/
	/* Preleva i task dalla lista */
	/******************************/
	
	num = 0;
	mem = XmListGetSelectedPos (tasklist, &list, &num);
	for (n=0; n<num; n++) {
		tid = FindTaskByPos(list[n]);
		task = FindTaskByTid(tid);
		if (task) {
			OutputWindow(task);
		}	
	}		
	
}


/***************/
/* ConverterCB */
/***************/

void ConverterCB (Widget w, struct NetworkObj * no, int dummy)
{
	Converter(w);
}

/************/
/* dialogCB */
/************/

void dialogCB(w,client_data,call_data)
    Widget w;
    int client_data;
    XmSelectionBoxCallbackStruct *call_data;
/* callback function for the dialog box */
{
    char *s;
   
    switch (client_data)
    {
        case 1:
        	s=(char *)calloc(50, sizeof(char));
            XmStringGetLtoR(call_data->value, DEFSET ,&s);
            anim_trf(s);
            free(s);
            break;
        case 2:
            break;
          
        default: 
        	break;
    }
    XtUnmanageChild(w);
    XtDestroyWidget(w);
}

/****************/
/*  anim_trf()  */
/****************/

void anim_trf(char *s)
{
	int child;
	char comm[256];
	char *p1=NULL, *p2=NULL;
	
	p1 = getenv("PVM_ROOT");
	p2 = getenv("PVM_ARCH");
	child = fork();
	if (!child){
		sprintf(comm,"%s/bin/%s/PVANIM2PG",p1,p2);
		execl(comm, comm,s, NULL);
		printf("errore nella exec di PVANIM2PG\n");
	}	
}
	



/****************/
/* SelectPoint  */
/****************/


void
SelectPoint(Widget w, XtPointer xtp , XEvent *event, Boolean *bool)
{
    static char buf[500];
    int i;
    int valid_i =0;
	XmString xmstr;
   
    if (w==hostutil || w==loadinfo || w==hostlist || w==memuse) {
		for (i=0; i<numhosts; i++) {
	    	if ((event->xbutton.y >= loadyoffset+(loadheightinterval)*i)
				&& event->xbutton.y<
				loadyoffset+(loadheightinterval)*(i+1)) {
				valid_i = 1;
				break;
	    	}
		}
    }
    
    if (valid_i) {
		sprintf(buf,"%d\tHost=%s\t#Users=%d\tLoad=%lf\tMemory Use=%ldK\n"
				,i, hosts[i].hostname,
		hosts[i].users, hosts[i].loadvalue, 
		hosts[i].maxrss*hosts[i].pagesize/1000);
		XmTextInsert(text_output, wpr_position, buf);
    	wpr_position += strlen(buf);
    	XtVaSetValues(text_output, XmNcursorPosition, wpr_position, NULL);
		XmTextShowPosition(text_output, wpr_position);	

    }
}


/********************/
/* SelectRangeLevel */
/********************/

void
SelectRangeLevel(Widget w, XtPointer xtp ,XEvent *event, Boolean *bool)
{
    XEvent event2;
	Display *display;
	
	display = XtDisplay(w);
    if (show_matrixcomm_value == SHOW_AGG_MATRIX) return;

    if (event->xbutton.button == 1) {
		intcommlegendrangelevel--;
        if (intcommlegendrangelevel < 0 ) intcommlegendrangelevel = 6;
    }
    else {
		intcommlegendrangelevel++;
        if (intcommlegendrangelevel > 6 ) intcommlegendrangelevel = 0;

    }
	event2.xexpose.display = display;
	event2.xexpose.window  = XtWindow(matrixcomm);
	redrawMatrixCommWindow(&event2);
}

/****************/
/* switchviewCB */
/****************/

void 
switchviewCB(Widget widget,XtPointer data , XmDrawingAreaCallbackStruct * cbs)
{
    XEvent event;
    XmString xmstr;
    Display *display;
	
	display = XtDisplay(widget);
    if (widget == messagesentbutton) {
		event.xexpose.display = display;
		event.xexpose.window  = XtWindow(messagesent);
		if (show_messagesent_value == SHOW_COUNT) {  
	    	show_messagesent_value = SHOW_BYTES;
	    	xmstr = XmStringCreate("BYTES SENT/mess sent",
				  					 XmSTRING_DEFAULT_CHARSET);
	    
		}
		else {
	    	show_messagesent_value = SHOW_COUNT;
	    	xmstr = XmStringCreate("MESS SENT/bytes sent",
				   					XmSTRING_DEFAULT_CHARSET);
		}
		XtVaSetValues(widget, XmNlabelString, xmstr, NULL);
		XmStringFree(xmstr);
		redrawMessageSentWindow(&event);
    }
    else if (widget == matrixcommbutton) {
		event.xexpose.display = display;
		event.xexpose.window  = XtWindow(matrixcomm);
		if (show_matrixcomm_value == SHOW_AGG_MATRIX) {  
	    	show_matrixcomm_value = SHOW_INT_MATRIX;
	    	xmstr = XmStringCreate("INT MAT COMM/tot mat comm",
				   					XmSTRING_DEFAULT_CHARSET);
	    
		}
		else {
	    	show_matrixcomm_value = SHOW_AGG_MATRIX;
	    	xmstr = XmStringCreate("TOT MAT COMM/int mat comm",
				   					XmSTRING_DEFAULT_CHARSET);
		}
		XtVaSetValues(widget, XmNlabelString, xmstr, NULL);
		XmStringFree(xmstr);
		redrawMatrixCommWindow(&event);
    }

}


/***************/
/*  refreshCB  */
/***************/

void 
refreshCB(Widget widget, XtPointer call, XmDrawingAreaCallbackStruct *cbs)
{
    static Position x,y;
    XEvent *event = cbs->event;
    Display *dpy = event->xexpose.display;
    
    if (cbs->reason == XmCR_EXPOSE) {
		if (widget==loadinfo) {
	    	redrawLoadWindow(event);
		}
		else if (widget == hostutil) {
	    	redrawHostUtilWindow(event, -1);
		}
		else if (widget == memuse) {
	    	redrawMemUseWindow(event);
		}
		else if (widget == totalutil) {
	    	redrawTotalUtilWindow(event);
		}
		else if (widget == messagesent) {
	    	redrawMessageSentWindow(event);
		}
		else if (widget == matrixcomm) {
	    	redrawMatrixCommWindow(event);
		}
		else if (widget == hostlist) {
	    	redrawHostListWindow(event);
		}
    }
	

}

/*************/
/* resizeCB  */
/*************/

void 
resizeCB(Widget widget, XtPointer  call, XmDrawingAreaCallbackStruct *cbs)
{
    XEvent event;
    Display *display;
	
	display = XtDisplay(widget);
    event.xexpose.display = display;
    event.xexpose.window  = XtWindow(widget);
    if (event.xexpose.window == (Window) NULL) return;
    if (widget==loadinfo) {
		XClearArea(event.xexpose.display, event.xexpose.window, 0,0,0,0,False);
		redrawLoadWindow(&event);
    }
    else if (widget == hostutil) {
		XClearArea(event.xexpose.display, event.xexpose.window, 0,0,0,0,False);
		redrawHostUtilWindow(&event, -1);
    }
    else if (widget == memuse) {
		XClearArea(event.xexpose.display, event.xexpose.window, 0,0,0,0,False);
		redrawMemUseWindow(&event);
    }
    else if (widget==totalutil) {
		XClearArea(event.xexpose.display, event.xexpose.window, 0,0,0,0,False);
		redrawTotalUtilWindow(&event);
    }
    else if (widget==messagesent) {
		XClearArea(event.xexpose.display, event.xexpose.window, 0,0,0,0,False);
		redrawMessageSentWindow(&event);
    }
    else if (widget==matrixcomm) {
		XClearArea(event.xexpose.display, event.xexpose.window, 0,0,0,0,False);
		redrawMatrixCommWindow(&event);
    }
    else if (widget==hostlist) {
		XClearArea(event.xexpose.display, event.xexpose.window, 0,0,0,0,False);
		redrawHostListWindow(&event);
    }
}

/************************ funzioni *****************/

/*****************/
/* FindTaskByPos */
/*****************/

int FindTaskByPos (int pos)
{
	struct Task_mon * task;
	int i=1;
	
	task = TL_mon->first;
	while (i!=pos) {
		task = task->next;
		i++;
	}
	return task->tid;
}	



/********************/
/* initialize_views */
/********************/

void initialize_views(Widget toplevel)
{
	Arg args[40];
    XmString xmstr;
    int i,n,j;
    XFontStruct *font, *font2;
    XmFontList fontlist, fontlist2;
    struct pvmhostinfo *hostp;
	int nhost;
	int narch;
	int maxprocs;
	
    pvm_config( &nhost, &narch, &hostp );
    maxprocs=200; /* XXX NASTY HACK */
    loads = (loadentry *)realloc(NULL,(sizeof(loadentry))*maxprocs);
    for (i=0;i<maxprocs;i++) {
        loads[i].intsend_time = 0;
		loads[i].intcompute_time = 0;
		loads[i].intidle_time = 0;
		loads[i].intprog_time = 0;
		loads[i].totsend_time = 0;
    	loads[i].totcompute_time = 0;
		loads[i].totidle_time = 0;
		loads[i].totprog_time = 0.00001;
		loads[i].send_vector = (int *) calloc(maxprocs,sizeof(int));
    	loads[i].int_send_vector = (int *) calloc(maxprocs,sizeof(int));    
		loads[i].send_byte_vector = (int *) calloc(maxprocs,sizeof(int));
		loads[i].receive_vector = (int *) calloc(maxprocs,sizeof(int));
		loads[i].receive_byte_vector = (int *) calloc(maxprocs,sizeof(int));
		loads[i].hostname= NULL;
		loads[i].interval_sent = 0;
		loads[i].interval_bytes_sent = 0;
		for (j=0; j< maxprocs; j++) {
	    	loads[i].send_vector[j] = 0;
	    	loads[i].int_send_vector[j] = 0;
	    	loads[i].send_byte_vector[j] = 0;
	    	loads[i].receive_vector[j] =0;
	    	loads[i].receive_byte_vector[j] = 0;
		}
    }
     
    /*malloc space for info arrays*/
       
    /* XXX possible overwrite*/
    hosts = (hostentry *)  realloc(NULL,(sizeof(hostentry))*nhost);
    for (i=0; i< nhost; i++) {
		hosts[i].loadvalue = 0.0;
		hosts[i].users = 0;
    }

    maxprocs=20; /* XXX NASTY HACK*/
    initialize_rangelevels();
    loadxoffset = 0;
    utilxoffset = 40;
    utilyoffset = 15;
 
    matrixcommxoffset = 20+140;
    matrixcommyoffset = 20;
    matrixcommsqwidth = 10;
    matrixcommsqcushion = 1;

    hostlistxoffset = 85;
    memuseyoffset =hostutilyoffset = loadyoffset = hostlistyoffset = 20;

    commlegendsqwidth = 10;
    commlegendsqcushion = 0;
    commlegendxoffset = 2;
    commlegendyoffset = 10;

    if (maxprocs < 10) {
		hostlistsqwidth  = 13;
		hostlistsqcushion = 0;
		utilrecwidth = 5;
		utilreccushion = 5;
    }
    else if (maxprocs < 20) {
		hostlistsqwidth = 13;
		hostlistsqcushion =0;
		utilrecwidth = 5;
		utilreccushion = 7;

	 }
    else {
		hostlistsqwidth = 13;
		hostlistsqcushion = 0;
		utilrecwidth = 5;
		utilreccushion = 7;
    }
    
    hostlistheight=loadheight=hostutilheight=memuseheight=
	(hostlistsqwidth+hostlistsqcushion)*((nhost > 23) ? 23 : nhost)+
     hostlistyoffset+hostlistyoffset; 

    loadwidth = 150; /*XXX*/
    hostutilwidth = 250;
    memusewidth = 250;
    memusexoffset=20;
    hostutilxoffset = 20;
   
    utilwidth=(utilrecwidth+utilreccushion)*maxprocs+utilxoffset; 
    if (utilwidth < 145){ utilwidth= 145;}
    utilheight = 115;
    
    matrixcommheight = (matrixcommsqwidth+matrixcommsqcushion)*maxprocs +
	matrixcommyoffset;
    
	matrixcommwidth = (matrixcommsqwidth+matrixcommsqcushion)*maxprocs +
	matrixcommxoffset;

    if (matrixcommwidth < 145) matrixcommwidth = 145;
    
    hostlistwidth = (hostlistsqwidth+hostlistsqcushion)*(maxprocs/2) +
	hostlistxoffset;


    commlegendheight =  (commlegendsqwidth + commlegendsqcushion)*8 +
	commlegendyoffset;

    commlegendwidth =  commlegendsqwidth + commlegendsqwidth*8  +
	commlegendxoffset;

    maxprocs=0;
    n = 0;
    /* Motif stuff */
    XtSetArg(args[n], XmNtitle, "Monitor"); n++;
    
	display = XtDisplay(toplevel);
   

    font = XLoadQueryFont (display, "6x10");
    fontlist = XmFontListCreate(font,"charset1");

    font2 = XLoadQueryFont (display, "8x13bold");
    fontlist2 = XmFontListCreate(font2,"charset2");
    /* create  shell */
    topshell_mon = XtAppCreateShell("monitor","topshell_mon", applicationShellWidgetClass, 
				XtDisplay(toplevel), args, n);
	MotifProtectShell (topshell_mon, (XtCallbackProc)CloseCB, NULL);
				
    n=0;
    XtSetArg(args[n], XmNheight,830);n++;
    XtSetArg(args[n], XmNwidth,820);n++;
	XtSetValues(topshell_mon,args, n);
		
	
	 /* crea la form principale */
	
	n=0;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(topshell_mon)));n++;
    XtSetArg(args[n], XmNbackground,BlackPixelOfScreen(XtScreen(topshell_mon)));n++;
    topform = XtCreateManagedWidget("topform", xmFormWidgetClass, topshell_mon, 
				 args, n);
	
	
	/* crea la barra del menu */
				 
	n=0;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	menubar = XmCreateMenuBar(topform, "menubar", args, n);
	
	
	/*controllare i NULL*/
	menupane = MotifCreateMenu(menubar, "File", 'F', 0, 0);
	/*MotifAddMenuItem(menupane, "Quit", 'Q', (XtCallbackProc)quitCB, NULL);*/
	MotifAddMenuItem(menupane, "Close", 'C', (XtCallbackProc)CloseCB, NULL);
	
	menupane = MotifCreateMenu(menubar, "Windows", 'W', 0, 0);
	MotifAddMenuItem(menupane, "Tasks", 'T', (XtCallbackProc)TasksWinCB, NULL);
	
	menupane = MotifCreateMenu(menubar, "Monitor", 'M', 0, 0);
	MotifAddMenuItem(menupane, "Show legend", 'S',(XtCallbackProc)ShowLegendCB, NULL);
	MotifAddMenuItem(menupane, "Hide legend", 'H',(XtCallbackProc)HideLegendCB, NULL);
	MotifAddMenuItem(menupane, "Converter", 'C',(XtCallbackProc)ConverterCB, NULL);

	menupane = MotifCreateMenu(menubar, "Misc", 's', 0, 0);
	MotifAddMenuItem(menupane, "Clear messages", 'C',(XtCallbackProc)ClearStatusCB, NULL);
	/*menupane = MotifCreateMenu(menubar, "Help", 'H', 1, 0);
	
	
	MotifAddMenuItem(menupane, "On version...", 'V',(XtCallbackProc)HelpVersionCB, NULL);
	MotifAddMenuItem(menupane, "On distribution...",'D',(XtCallbackProc)HelpDistributionCB, NULL);
	*/
	
	
	/* crea il paned */
	n=0;
	XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(topform)));n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, menubar); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNbottomAttachment,XmATTACH_FORM); n++;
    paned =XmCreatePanedWindow(topform, "paned", args, n);
    
	
	
    /* create form */
    n=0;
    XtSetArg(args[n], XmNheight,600);n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(topshell_mon)));n++;
    XtSetArg(args[n], XmNbackground,BlackPixelOfScreen(XtScreen(topshell_mon)));n++;
	
    form = XtCreateManagedWidget("topform", xmFormWidgetClass, paned, 
				 args, n);

    n=0;
    xmstr = XmStringCreate("Host List",DEFSET);
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 25); n++;
    hostlistlabel = XtCreateManagedWidget("hostlistlabel", 
					  xmLabelWidgetClass,form, args, n);
    XmStringFree(xmstr);


    n=0;
    xmstr = XmStringCreate("Load Info",DEFSET);
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, hostlistlabel); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 45); n++;
    loadinfolabel = XtCreateManagedWidget("loadinfolabel", 
					  xmLabelWidgetClass,form, args, n);
    XmStringFree(xmstr);

    n=0;
    xmstr = XmStringCreate("Host Util",DEFSET);
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, loadinfolabel); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 65); n++;
    hostutillabel = XtCreateManagedWidget("hostutillabel", 
					  xmLabelWidgetClass,form, args, n);
    XmStringFree(xmstr);

    n=0;
    xmstr = XmStringCreate("Memory Use",DEFSET);
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 85); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, hostutillabel); n++;
    memuselabel = XtCreateManagedWidget("memuselabel", 
					xmLabelWidgetClass,form, args, n);
    XmStringFree(xmstr);
    
    
    n=0;
    xmstr = XmStringCreate("Task List",DEFSET);
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget,memuselabel); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    tasklistlabel = XtCreateManagedWidget("tasklistlabel", 
					  xmLabelWidgetClass,form, args, n);
    XmStringFree(xmstr);
	
	
    /* create drawing area */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, hostlistlabel); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNbottomPosition, 50); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 25); n++;
    XtSetArg(args[n], XmNwidth, hostlistwidth); n++;
    XtSetArg(args[n], XmNheight,hostlistheight); n++;
    XtSetArg(args[n], XmNbackground,WhitePixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNscrollingPolicy,XmAUTOMATIC);n++;
    XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED);n++;

    hostlist= XtCreateManagedWidget("animwindow",
				xmDrawingAreaWidgetClass,form, args, n);
	

    /* add associated callbacks and handlers */
    XtAddCallback(hostlist, XmNexposeCallback,(XtCallbackProc) refreshCB, NULL);
    XtAddCallback(hostlist, XmNresizeCallback,(XtCallbackProc) resizeCB, NULL);


    /* create drawing area */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, loadinfolabel); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNbottomPosition, 50); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, hostlist); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 45); n++;
    XtSetArg(args[n], XmNwidth, loadwidth); n++;
    XtSetArg(args[n], XmNheight, loadheight); n++;
    XtSetArg(args[n], XmNbackground,WhitePixelOfScreen(XtScreen(form)));n++;
    loadinfo = XtCreateManagedWidget("animwindow", xmDrawingAreaWidgetClass,
				form, args, n);

    /* add associated callbacks and handlers */
    XtAddCallback(loadinfo, XmNexposeCallback,(XtCallbackProc) refreshCB, NULL);    
    XtAddCallback(loadinfo, XmNresizeCallback,(XtCallbackProc) resizeCB, NULL);   
    XtAddEventHandler(loadinfo, ButtonPressMask, FALSE, SelectPoint,
					(XtPointer)NULL);


    /* create drawing area */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, hostutillabel); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNbottomPosition, 50); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, loadinfo); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 65); n++;
    XtSetArg(args[n], XmNbackground,WhitePixelOfScreen(XtScreen(form)));n++;
    hostutil= XtCreateManagedWidget("animwindow", xmDrawingAreaWidgetClass,
				form, args, n);

    /* add associated callbacks and handlers */
    XtAddCallback(hostutil, XmNexposeCallback,(XtCallbackProc) refreshCB, NULL);    
    XtAddCallback(hostutil, XmNresizeCallback,(XtCallbackProc) resizeCB, NULL);   
    XtAddEventHandler(hostutil, ButtonPressMask, FALSE, SelectPoint, 
		      		(XtPointer)NULL);

    /* Create Memory use view create drawing area */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, memuselabel); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNbottomPosition, 50); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, hostutil); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 85); n++;
    XtSetArg(args[n], XmNwidth, memusewidth); n++;
    XtSetArg(args[n], XmNheight, memuseheight); n++;
    XtSetArg(args[n], XmNbackground,WhitePixelOfScreen(XtScreen(form)));n++;
    memuse= XtCreateManagedWidget("animwindow", xmDrawingAreaWidgetClass,
				     				form, args, n);

    /* add associated callbacks and handlers */
    XtAddCallback(memuse, XmNexposeCallback, (XtCallbackProc) refreshCB, NULL);
    XtAddCallback(memuse, XmNresizeCallback, (XtCallbackProc) resizeCB, NULL);
    XtAddEventHandler(memuse, ButtonPressMask, FALSE, SelectPoint, 
					(XtPointer)NULL);	
 

    n=0;
    xmstr = XmStringCreate("Task Summary",DEFSET);
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, hostlist); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 40); n++; 
    totalutillabel = XtCreateManagedWidget("totalutillabel", 
						xmLabelWidgetClass,form, args, n);
    XmStringFree(xmstr);
    
    n=0;
    xmstr = XmStringCreate("TOT MAT COMM/int mat comm",
							DEFSET);
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, memuse); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, totalutillabel); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 85); n++;
	matrixcommbutton = XtCreateManagedWidget("matrixcommbutton", 
						xmPushButtonWidgetClass,form, args, n);
    XtAddCallback(matrixcommbutton, XmNactivateCallback,  
					(XtCallbackProc) switchviewCB, NULL); 
    XmStringFree(xmstr);


  /*create total utilization view *******************

    
    create drawing area */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, totalutillabel); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNbottomPosition, 75); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 40); n++;
    XtSetArg(args[n], XmNwidth, utilwidth); n++;
    XtSetArg(args[n], XmNheight,utilheight); n++;
    XtSetArg(args[n], XmNbackground,WhitePixelOfScreen(XtScreen(form)));n++;
    totalutil= XtCreateManagedWidget("animwindow", xmDrawingAreaWidgetClass,
				form, args, n);

    /*add associated callbacks and handlers*/
    XtAddCallback(totalutil, XmNexposeCallback, (XtCallbackProc) refreshCB,
					NULL);
    XtAddCallback(totalutil, XmNresizeCallback, (XtCallbackProc) resizeCB, 
					NULL);
    XtAddEventHandler(totalutil, ButtonPressMask, FALSE, SelectPoint, 
		      		(XtPointer)NULL);

    n=0;
	xmstr = XmStringCreate("MESS SENT/bytes sent",DEFSET);
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNborderColor,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, totalutil); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 40); n++;
    messagesentbutton = XtCreateManagedWidget("messagesent", 
							xmPushButtonWidgetClass,form, args, n);
    XtAddCallback(messagesentbutton, XmNactivateCallback,  
					(XtCallbackProc) switchviewCB, NULL);
    XmStringFree(xmstr);
    
	/* create Mwssage Sent view create drawing area */
    
	n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, messagesentbutton); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 40); n++;
    XtSetArg(args[n], XmNbackground,WhitePixelOfScreen(XtScreen(form)));n++;
    messagesent= XtCreateManagedWidget("animwindow", xmDrawingAreaWidgetClass,
				     form, args, n);

    /* add associated callbacks and handlers*/
    XtAddCallback(messagesent, XmNexposeCallback,(XtCallbackProc) refreshCB,
 					NULL);
    XtAddCallback(messagesent, XmNresizeCallback,(XtCallbackProc) resizeCB, 
					NULL);

    
    XtAddEventHandler(messagesent, ButtonPressMask, FALSE, SelectPoint, 
		      (XtPointer)NULL);
    
    /* create Matrix Communication view create drawing area */
   
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, matrixcommbutton); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNbottomPosition, 92); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, totalutil); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 85); n++;
    XtSetArg(args[n], XmNwidth, matrixcommwidth); n++;
    XtSetArg(args[n], XmNheight,matrixcommheight); n++;
    XtSetArg(args[n], XmNbackground,WhitePixelOfScreen(XtScreen(form)));n++;
    matrixcomm= XtCreateManagedWidget("animwindow", 
				      xmDrawingAreaWidgetClass,form, args, n);

    /* add associated callbacks and handlers*/
    XtAddCallback(matrixcomm, XmNexposeCallback, (XtCallbackProc) refreshCB,
				 NULL);
    XtAddCallback(matrixcomm, XmNresizeCallback, (XtCallbackProc) resizeCB,
				 NULL);
    XtAddEventHandler(matrixcomm, ButtonPressMask, FALSE, SelectRangeLevel, 
		      (XtPointer)NULL);


    n=0;
    xmstr = XmStringCreate("Sampling Interval (seconds)",DEFSET);
    XtSetArg(args[n], XmNtitleString, xmstr);n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNborderColor,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNfontList,fontlist); n++;
    XtSetArg(args[n], XmNmaximum, 180); n++;
    XtSetArg(args[n], XmNminimum, 1); n++;
    XtSetArg(args[n], XmNshowValue, True); n++;
    XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, matrixcomm); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 85); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget, messagesent); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    scale = XtCreateManagedWidget("Sampling Interval", 
				  xmScaleWidgetClass,form, args, n);
    XtAddCallback(scale, XmNvalueChangedCallback,  (XtCallbackProc) samplescaleCB,
					 NULL);
	XmStringFree(xmstr);
    
	
	n=0;
    xmstr = XmStringCreate("Pos   Tid     Name",DEFSET);
    XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
    XtSetArg(args[n], XmNlabelString, xmstr); n++;
    XtSetArg(args[n], XmNbackground,WhitePixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNforeground,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, tasklistlabel); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNleftWidget,memuse); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNheight,10); n++;
    XtSetArg(args[n], XmNborderColor,BlackPixelOfScreen(XtScreen(form)));n++;
    XtSetArg(args[n], XmNfontList,fontlist); n++;
    tasklistlabel2 = XtCreateManagedWidget("tasklistlabel2",xmLabelWidgetClass,form, args, n); 
    XmStringFree(xmstr);
	
	
 	
 	n = 0;
    XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
    XtSetArg(args[n], XmNfontList,fontlist); n++;
    XtSetArg(args[n], XmNforeground,WhitePixelOfScreen(XtScreen(form)));n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, tasklistlabel2); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNleftWidget, memuse); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNselectionPolicy, XmEXTENDED_SELECT); n++;
    XtSetArg(args[n], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); n++;
    tasklist = XmCreateScrolledList(form, "tasklist",args, n);
    XtAddCallback(tasklist, XmNdefaultActionCallback, (XtCallbackProc)OutputCB, NULL);
	
	
	
    /*  Create Info Box*/
    
    n = 0;
    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNeditable, False); n++;
    XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
   
    text_output = XmCreateScrolledText(paned, "text_out",args, n);
	
	
    /* create graphics contexts */
	
    create_GC();
    	
			
	 /* creo la legend */
	 
	legendshell = XtAppCreateShell("Legend","legendshell", applicationShellWidgetClass, 
				XtDisplay(topshell_mon), args, n);
	n=0;
    XtSetArg(args[n], XmNheight,200);n++;
    XtSetArg(args[n], XmNwidth,300);n++;
    XtSetArg(args[n], XmNmaxHeight,200);n++;
    XtSetArg(args[n], XmNmaxWidth,300);n++;
	XtSetValues(legendshell,args, n);
	
	 /* create drawing area */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    legend = XtCreateManagedWidget("legendwindow", xmDrawingAreaWidgetClass,
				legendshell, args, n);
	XtManageChild(legend); 
	XtAddCallback(legend, XmNexposeCallback,(XtCallbackProc)exposureCB, NULL);
	XtSetMappedWhenManaged(legendshell, False); 
	 
     
    /* manage child widgets */
    
    XtManageChild(text_output); 
    XtManageChild(tasklist);
    XtManageChild(topform);
    XtManageChild(paned);
    XtManageChild(menubar);
    
    /* realize topshell_mon widgets */
    
    XtSetMappedWhenManaged(topshell_mon, False); 
    XtRealizeWidget(topshell_mon);
    XtRealizeWidget(legendshell);    
}


/***************/
/* ShowMonitor */
/***************/

void ShowMonitor(Widget toplevel)
{	
	if (topshell_mon) {
		XMapRaised (XtDisplay(topshell_mon), XtWindow(topshell_mon));
	}
	else {
		MotifWarning(toplevel, "Warning", "The monitor is NOT yet actived");
	}
}	


/*************/
/* Converter */
/*************/

void Converter(Widget w)
{	
	int n;
	Arg args[20];
	
	n = 0;
	XtSetArg(args[n],XmNdirMask,XmStringCreate("*.anim",DEFSET)); n++;
	XtSetArg(args[n],XmNdialogTitle,XmStringCreate("Converter",DEFSET)); n++;
    dialog=XmCreateFileSelectionDialog(w,"dialog",args,n);
    XtAddCallback(dialog,XmNokCallback,(XtCallbackProc) dialogCB,(void *) 1);
    XtAddCallback(dialog,XmNcancelCallback,(XtCallbackProc) dialogCB,(void *) 2);
    XtUnmanageChild(XmSelectionBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
 	XtManageChild(dialog);
 	
}
	
/**************************/
/* initialize_rangelevels */
/**************************/

void initialize_rangelevels()
{
    commlegendrangelevel=0;
    intcommlegendrangelevel=0;

    rangechoices[0].rangemax[0] = 1;
    rangechoices[0].rangemax[1] = 2;
    rangechoices[0].rangemax[2] = 3;    
    rangechoices[0].rangemax[3] = 4;
    rangechoices[0].rangemax[4] = 5;
    rangechoices[0].rangemax[5] = 6;
    rangechoices[0].rangemax[6] = 8;
    rangechoices[0].rangemax[7] = 10;

    rangechoices[1].rangemax[0] = 1;
    rangechoices[1].rangemax[1] = 20;
    rangechoices[1].rangemax[2] = 30;   
    rangechoices[1].rangemax[3] = 40;
    rangechoices[1].rangemax[4] = 50;
    rangechoices[1].rangemax[5] = 60;
    rangechoices[1].rangemax[6] = 80;
    rangechoices[1].rangemax[7] = 100;

    rangechoices[2].rangemax[0] =1; 
    rangechoices[2].rangemax[1] =100; 
    rangechoices[2].rangemax[2] =200; 
    rangechoices[2].rangemax[3] =300; 
    rangechoices[2].rangemax[4] =400; 
    rangechoices[2].rangemax[5] =600; 
    rangechoices[2].rangemax[6] =800; 
    rangechoices[2].rangemax[7] =1000;

    rangechoices[3].rangemax[0] =1; 
    rangechoices[3].rangemax[1] =1000; 
    rangechoices[3].rangemax[2] =2000;     
    rangechoices[3].rangemax[3] =3000; 
    rangechoices[3].rangemax[4] =4000; 
    rangechoices[3].rangemax[5] =6000; 
    rangechoices[3].rangemax[6] =8000; 
    rangechoices[3].rangemax[7] =10000;

    rangechoices[4].rangemax[0] =1;
    rangechoices[4].rangemax[1] =10000; 
    rangechoices[4].rangemax[2] =20000;     
    rangechoices[4].rangemax[3] =30000; 
    rangechoices[4].rangemax[4] =40000; 
    rangechoices[4].rangemax[5] =60000; 
    rangechoices[4].rangemax[6] =80000; 
    rangechoices[4].rangemax[7] =100000;

    rangechoices[5].rangemax[0] =1;
    rangechoices[5].rangemax[1] =100000; 
    rangechoices[5].rangemax[2] =200000;     
    rangechoices[5].rangemax[3] =300000; 
    rangechoices[5].rangemax[4] =400000; 
    rangechoices[5].rangemax[5] =600000;
    rangechoices[5].rangemax[6] =800000;
    rangechoices[5].rangemax[7] =1000000;

    rangechoices[6].rangemax[0] =1; 
    rangechoices[6].rangemax[1] =10; 
    rangechoices[6].rangemax[2] =100;     
    rangechoices[6].rangemax[3] =1000; 
    rangechoices[6].rangemax[4] =10000; 
    rangechoices[6].rangemax[5] =100000; 
    rangechoices[6].rangemax[6] =1000000; 
    rangechoices[6].rangemax[7] =10000000;

}

/*************/
/* create_GC */
/*************/

void create_GC()
{
    Font font;
    Colormap cmap;
    Pixel redcolor, sendcolor, busycolor, idlecolor, graycolor;
    XColor color;
   /* create grahics contexts XXX
     Assume for now a color display */
    mygc = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), mygc, 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), mygc, 
		    BlackPixelOfScreen(XtScreen(loadinfo)));
    XSetLineAttributes(XtDisplay(loadinfo), mygc, 0, LineSolid,
		       CapNotLast, JoinMiter);

    /* set default color map */
    cmap = DefaultColormap(display, DefaultScreen(display));
    font = XLoadFont (display, "6x13");
    XSetFont (display, mygc, font);

    /* Assume for now a color display */
    mygcmicro = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), mygcmicro, 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), mygcmicro, 
		    BlackPixelOfScreen(XtScreen(loadinfo)));
    XSetLineAttributes(XtDisplay(loadinfo), mygcmicro, 0, LineSolid,
		       CapNotLast, JoinMiter);
    font = XLoadFont (display, "6x10");
    XSetFont (display, mygcmicro, font);


   /* create blue graphics context */
    if (!XParseColor(display,cmap,"SteelBlue", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET blue  COLOR\n");
    }
    
    bluegc = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), bluegc, 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), bluegc, color.pixel);
    XSetLineAttributes(XtDisplay(loadinfo), bluegc, 0, LineSolid,
		       CapNotLast, JoinMiter);


    /* create red graphics context */
    if (!XParseColor(display,cmap,"red", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET RED  COLOR\n");
    }
    else {
		redcolor = color.pixel;
    }
    
    redgc = XCreateGC (XtDisplay(loadinfo), 
				RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), redgc, 
				WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), redgc,redcolor);
    XSetLineAttributes(XtDisplay(loadinfo), redgc, 0, LineSolid,
		       CapNotLast, JoinMiter);

    
    /* create idle  graphics context */
    if (!XParseColor(display,cmap,"red", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET IDLE COLOR\n");
    }
    else {
		idlecolor = color.pixel;
    }
    
    idlegc = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), idlegc, 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), idlegc,idlecolor);
    XSetLineAttributes(XtDisplay(loadinfo), idlegc, 0, LineSolid,
		       CapNotLast, JoinMiter);


    /* create busy graphics context */
    if (!XParseColor(display,cmap,"green", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET BUSY COLOR\n");
    }
    else {
		busycolor = color.pixel;
    }
    
    busygc = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), busygc, 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), busygc,busycolor);
    XSetLineAttributes(XtDisplay(loadinfo), busygc, 0, LineSolid,
		       CapNotLast, JoinMiter);

  /* create send graphics context */

    if (!XParseColor(display,cmap,"yellow", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET SEND  COLOR\n");
    }
    else {
		sendcolor = color.pixel;
    }
    
    sendgc = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), sendgc, 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), sendgc,sendcolor);
    XSetLineAttributes(XtDisplay(loadinfo), sendgc, 0, LineSolid,
		       CapNotLast, JoinMiter);

    /* create grayscale graphics context */
    if (!XParseColor(display,cmap,"white", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET gray COLOR\n");
    }
    else {
		graycolor = color.pixel;
    }
    
    grayscalegc[0] = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), grayscalegc[0], 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), grayscalegc[0],graycolor);
    XSetLineAttributes(XtDisplay(loadinfo), grayscalegc[0], 0, LineSolid,
		       CapNotLast, JoinMiter);

    if (!XParseColor(display,cmap,"LightGray", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET gray COLOR\n");
    }
    else {
		graycolor = color.pixel;
    }
    
    grayscalegc[1] = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), grayscalegc[1], 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), grayscalegc[1],graycolor);
    XSetLineAttributes(XtDisplay(loadinfo), grayscalegc[1], 0, LineSolid,
		       CapNotLast, JoinMiter);
   if (!XParseColor(display,cmap,"gray", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET gray COLOR\n");
    }
    else {
		graycolor = color.pixel;
    }
    
    grayscalegc[2] = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), grayscalegc[2], 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), grayscalegc[2],graycolor);
    XSetLineAttributes(XtDisplay(loadinfo), grayscalegc[2], 0, LineSolid,
		       CapNotLast, JoinMiter);

    if (!XParseColor(display,cmap,"LightSlateGray", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET gray COLOR\n");
    }
    else {
		graycolor = color.pixel;
    }
    
    grayscalegc[3] = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), grayscalegc[3], 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), grayscalegc[3],graycolor);
    XSetLineAttributes(XtDisplay(loadinfo), grayscalegc[3], 0, LineSolid,
		       CapNotLast, JoinMiter);
 
    if (!XParseColor(display,cmap,"SlateGray", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET gray COLOR\n");
    }
    else {
		graycolor = color.pixel;
    }
    
    grayscalegc[4] = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), grayscalegc[4], 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), grayscalegc[4],graycolor);
    XSetLineAttributes(XtDisplay(loadinfo), grayscalegc[4], 0, LineSolid,
		       CapNotLast, JoinMiter);

    if (!XParseColor(display,cmap,"DimGray", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET gray COLOR\n");
    }
    else {
		graycolor = color.pixel;
    }
    
    grayscalegc[5] = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), grayscalegc[5], 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), grayscalegc[5],graycolor);
    XSetLineAttributes(XtDisplay(loadinfo), grayscalegc[5], 0, LineSolid,
		       CapNotLast, JoinMiter);
    
    if (!XParseColor(display,cmap,"DarkSlateGray", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET gray COLOR\n");
    }
    else {
		graycolor = color.pixel;
    }
    
    grayscalegc[6] = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), grayscalegc[6], 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), grayscalegc[6],graycolor);
    XSetLineAttributes(XtDisplay(loadinfo), grayscalegc[6], 0, LineSolid,
		       CapNotLast, JoinMiter);

    if (!XParseColor(display,cmap,"black", &color) || 
		!XAllocColor(display,cmap,&color)) {
		printf("COULD NOT GET gray COLOR\n");
    }
    else {
		graycolor = color.pixel;
    }
    
    grayscalegc[7] = XCreateGC (XtDisplay(loadinfo), 
		      RootWindowOfScreen(XtScreen(loadinfo)), 0, 0);
    XSetBackground (XtDisplay(loadinfo), grayscalegc[7], 
		    WhitePixelOfScreen(XtScreen(loadinfo)));
    XSetForeground (XtDisplay(loadinfo), grayscalegc[7], graycolor);
    XSetLineAttributes(XtDisplay(loadinfo), grayscalegc[7], 0, LineSolid,
		       CapNotLast, JoinMiter);
}
