/*****************************************************************************\
*                                                                             *
*  modInternet.c - Ping/Traceroute		                                      *
*                                                                             *
\*****************************************************************************/

/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */


#include "modInternet.h"

/*********************/
/* Strutture private */
/*********************/

struct Input {
	Widget Wshell;
	Widget Wtext;
	XtInputId id;
	int pid;
};

/*******************/
/* Globali private */
/*******************/

/********************/
/* Funzioni private */
/********************/

/*********************/
/* Callbacks private */
/*********************/

static void InputDestroyCB (Widget, struct Input *, int);
static void InputCB (struct Input *, int *, XtInputId *);

/******************************************/
/* InternetInit - inizializzazione modulo */
/******************************************/

void InternetInit (void)
{
	
	/* XXX per ora nulla */
}

/*********************************/
/* SpawnEnd - distruzione modulo */
/*********************************/

void InternetEnd (void)
{
	/* XXX per ora nulla */
}

/***********************/
/* InternetPing - Ping */
/***********************/

void InternetPing (struct NetworkObj * no, char * addr)
{
	int n;
	Arg args[20];
	char buffer [1000];
	Widget Wshell, Wform, Wtext, Wbutton;
	struct Input * ping;
	int pipefd[2], pid;
		
	/*********/
	/* Shell */
	/*********/

	sprintf (buffer, "Ping to host %s\n", addr);
	ping = calloc (1, sizeof (struct Input));

	n = 0;
	XtSetArg (args[n], XmNtitle, buffer); n++;
	XtSetArg (args[n], XmNdeleteResponse, XmDO_NOTHING); n++;
	XtSetArg (args[n], XmNwidth, 700); n++;
	XtSetArg (args[n], XmNheight, 350); n++;
	Wshell = XtAppCreateShell ("ping", "Wamm", applicationShellWidgetClass, XtDisplay (no->Wshell), args, n);
	ping -> Wshell = Wshell;
	MotifProtectShell (Wshell, (XtCallbackProc)InputDestroyCB, ping);
	XtRealizeWidget (Wshell);
	
	/***********/
	/* Editres */
	/***********/
    
    XtAddEventHandler (Wshell, (EventMask)0, True, _XEditResCheckMessages, NULL);

	/********/
	/* Form */
	/********/

	n = 0;
	Wform = XmCreateForm (Wshell, "pingform", args, n);
	XtManageChild (Wform);

	/*****************/
	/* Scrolled text */
	/*****************/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 45); n++;
	XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg (args[n], XmNeditable, False); n++;
	XtSetArg (args[n], XmNcursorPositionVisible, False); n++;
	Wtext = XmCreateScrolledText (Wform, "pingtext", args, n);
	XtManageChild (Wtext);
	ping -> Wtext = Wtext;
	
	/***********/
	/* Bottone */
	/***********/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("OK", DEFSET)); n++;
	XtSetArg (args[n], XmNwidth, 80); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 5); n++;
	Wbutton = XmCreatePushButton (Wform, "pingok", args, n);
	XtManageChild (Wbutton);
	XtAddCallback (Wbutton, XmNactivateCallback, (XtCallbackProc)InputDestroyCB, ping);
	
	/*****************/
	/* Avvia il ping */
	/*****************/	
	
#ifndef PINGPATH
	MotifStatusMsg (Wtext, "Ping command not enabled during compilation. Sorry!\n");
	return;
#else	
	
	pipe(pipefd);
	
	pid = fork ();
	if (!pid) {
	
		/**********/
		/* Figlio */
		/**********/
		
		pvmendtask();			/* esce da PVM */
		
		close (pipefd[0]);		/* non ha input */
		close (1);
		close (2);
		dup (pipefd[1]);		/* stdout verso il pipe */
		dup (pipefd[1]);		/* stderr verso il pipe */
				
		execl (PINGPATH, PINGPATH, addr, NULL);
	}
	
	else {
	
		/*********/
		/* Padre */
		/*********/
		
		close (pipefd[1]);		/* non ha output */
		
		ping->pid = pid;
		ping->id = XtAppAddInput (XtWidgetToApplicationContext (no->Wshell), pipefd[0], (XtPointer)XtInputReadMask, (XtInputCallbackProc)InputCB, (XtPointer)ping);
	}

#endif

}

/***********************************/
/* InternetTraceroute - Traceroute */
/***********************************/

/* XXX per ora e` del tutto analogo a Ping */

void InternetTraceroute (struct NetworkObj * no, char * addr)
{
	int n;
	Arg args[20];
	char buffer [1000];
	Widget Wshell, Wform, Wtext, Wbutton;
	struct Input * troute;
	int pipefd[2], pid;
		
	/*********/
	/* Shell */
	/*********/

	sprintf (buffer, "Traceroute to host %s\n", addr);
	troute = calloc (1, sizeof (struct Input));

	n = 0;
	XtSetArg (args[n], XmNtitle, buffer); n++;
	XtSetArg (args[n], XmNdeleteResponse, XmDO_NOTHING); n++;
	XtSetArg (args[n], XmNwidth, 700); n++;
	XtSetArg (args[n], XmNheight, 350); n++;
	Wshell = XtAppCreateShell ("traceroute", "Wamm", applicationShellWidgetClass, XtDisplay (no->Wshell), args, n);
	troute -> Wshell = Wshell;
	MotifProtectShell (Wshell, (XtCallbackProc)InputDestroyCB, troute);
	XtRealizeWidget (Wshell);

	/***********/
	/* Editres */
	/***********/
    
    XtAddEventHandler (Wshell, (EventMask)0, True, _XEditResCheckMessages, NULL);

	/********/
	/* Form */
	/********/

	n = 0;
	Wform = XmCreateForm (Wshell, "trouteform", args, n);
	XtManageChild (Wform);

	/*****************/
	/* Scrolled text */
	/*****************/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 45); n++;
	XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg (args[n], XmNeditable, False); n++;
	XtSetArg (args[n], XmNcursorPositionVisible, False); n++;
	Wtext = XmCreateScrolledText (Wform, "troutetext", args, n);
	XtManageChild (Wtext);
	troute -> Wtext = Wtext;
	
	/***********/
	/* Bottone */
	/***********/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("OK", DEFSET)); n++;
	XtSetArg (args[n], XmNwidth, 80); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 5); n++;
	Wbutton = XmCreatePushButton (Wform, "trouteok", args, n);
	XtManageChild (Wbutton);
	XtAddCallback (Wbutton, XmNactivateCallback, (XtCallbackProc)InputDestroyCB, troute);
	
	/***********************/
	/* Avvia il traceroute */
	/***********************/	

#ifndef TROUTEPATH
	MotifStatusMsg (Wtext, "Traceroute command not enabled during compilation. Sorry!\n");
	return;
#else	
	
	pipe(pipefd);
	
	pid = fork ();
	if (!pid) {
	
		/**********/
		/* Figlio */
		/**********/
		
		pvmendtask();			/* esce da PVM */
		
		close (pipefd[0]);		/* non ha input */
		close (1);
		close (2);
		dup (pipefd[1]);		/* stdout verso il pipe */
		dup (pipefd[1]);		/* stderr verso il pipe */

		execl (TROUTEPATH, TROUTEPATH, addr, NULL);
	}
	
	else {
	
		/*********/
		/* Padre */
		/*********/
		
		close (pipefd[1]);		/* non ha output */
		
		troute->pid = pid;
		troute->id = XtAppAddInput (XtWidgetToApplicationContext (no->Wshell), pipefd[0], (XtPointer)XtInputReadMask, (XtInputCallbackProc)InputCB, (XtPointer)troute);
	}

#endif	

}

/***********/
/* InputCB */
/***********/

void InputCB (struct Input * input, int * source, XtInputId * id)
{
	char buffer[10000];
	int len;
	
	len = read (*source, buffer, 9999);
	if (!len) {
	
		/**** processo terminato ****/
		
		input->pid = 0;
		XtRemoveInput (input->id);
		MotifStatusMsg (input->Wtext, "\n\nFinished.\n");
	}
	
	else {
	
		buffer[len] = '\0';
		MotifStatusMsg (input->Wtext, "%s", buffer);
	}
}

/******************/
/* InputDestroyCB */
/******************/

void InputDestroyCB (Widget w, struct Input * input, int dummy)
{
	if (input->pid) {
		kill (input->pid, SIGKILL);
		XtRemoveInput (input->id);
	}

	XtDestroyWidget (input->Wshell);
	free (input);
}
