/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 *
 *  makepg.c
 *  Brad Topol 8/16/95
 *  This provides conversion from pvanim trace formats to
 *  ParaGraph trace formats.  The output still needs to 
 *  be sorted correctly and converted.  
 *   
 **************************************************************/

#include <stdio.h>
#include "dualsync.h"
static TimeRec previous_time[NPROC];
static LineRec lineHead[NPROC];
static LineRec *sortptr[NPROC];
static FILE *ifd;
static FILE *ofd;
static int nproc=0;
/**/
/* Forward declarations */
/**/

#define MAXUSEREVENT 256
/*********************************************************/
main(argc, argv)
     int argc;
     char** argv;
{
    TimeRec delta_t, temp_t;
    static TimeRec tzero = {0,0};
    int i,j,k,src,recv_found;
    int *sortptr_flags;
    LineRec *lp;
    int total_done = 0; 
    int curr_line;
    int blank_count;
    char *tptr; 
    char temp_line[MAXLINE];
    char temp_user_line[MAXUSEREVENT+1];
    
    ifd = stdin;
    ofd = stdout;
    if(argc >= 2) {
	ifd = fopen (argv[1], "r");
	if (ifd==NULL)
	    exit(0);
    }
    if(argc >=3) {
	ofd = fopen (argv[2], "w");
	if (ofd==NULL)
	    exit(0);
    }
    


    lp = (LineRec*) malloc(sizeof(LineRec));
    lp->mark = 0;
    while (fgets(temp_line, MAXLINE, ifd)) {
	sscanf(temp_line, "%d", &lp->event_type);
	if(isdigit(temp_line[0])){
	    switch(lp->event_type) {
		
	    case SEND:
		
		sscanf(temp_line, "%*d %d %d %d %d %d %d %d",
		       &lp->lam_time, &lp->adjust_time.sec, 
		       &lp->adjust_time.usec, &lp->node, &lp->DEST, 
		       &lp->MSG_TAG, &lp->MSG_LEN);
		fprintf(ofd, "%d %d %d %d %d %d %d\n",
			lp->event_type, 
			lp->adjust_time.sec, 
			lp->adjust_time.usec, 
			lp->node, 
			lp->DEST,
			lp->MSG_TAG, 
			lp->MSG_LEN);
		fprintf(ofd, "%d %d %d %d %d %d\n",
			11,
			lp->adjust_time.sec, 
			lp->adjust_time.usec, 
			lp->node, 
			0,
			0);
		break;
	    case RECV_WAKING:
	    case RECV:
		sscanf(temp_line, "%*d %d %d %d %d %d %d %d",
		       &lp->lam_time,
		       &lp->adjust_time.sec, 
		       &lp->adjust_time.usec, &lp->node, &lp->SRC, 
		       &lp->MSG_TAG, &lp->MSG_LEN);
		fprintf(ofd, "%d %d %d %d %d %d %d\n",
			lp->event_type, 
			lp->adjust_time.sec, 
			lp->adjust_time.usec, 
			lp->node, 
			lp->SRC,
			lp->MSG_TAG, 
			lp->MSG_LEN);
		break;
		
	    case RECV_BLOCKING:
		sscanf(temp_line, "%*d %d %d %d %d %d ",
		       &lp->lam_time,&lp->adjust_time.sec, 
		       &lp->adjust_time.usec, &lp->node, &lp->MSG_TAG);
		fprintf(ofd, "%d %d %d %d %d %d\n",
			lp->event_type, 
			lp->adjust_time.sec, 
			lp->adjust_time.usec, 
			lp->node, 
			lp->SRC,
			lp->MSG_TAG);
		break;
		
	    case TRACE_START:
		sscanf(temp_line, "%*d %d %d %d %d %d %d %d",
		       &lp->lam_time,&lp->adjust_time.sec, 
		       &lp->adjust_time.usec, &lp->node, &lp->p1, 
		       &lp->p2, &lp->p3);
		fprintf(ofd, "%d %d %d %d %d %d %d\n",
			lp->event_type, 
			lp->adjust_time.sec, 
			lp->adjust_time.usec, 
			lp->node, 
			0,
			0,
			0);
		break;
	      
	    case TRACE_END:
		sscanf(temp_line, "%*d %d %d %d %d %d",&lp->lam_time,
		       &lp->adjust_time.sec, 
		       &lp->adjust_time.usec, &lp->node, &lp->p1);
		fprintf(ofd, "%d %d %d %d %d\n",
			lp->event_type, 
			lp->adjust_time.sec, 
			lp->adjust_time.usec, 
			lp->node, 
			0);
		break;
		
	    case COMPSTATS:
		sscanf(temp_line, "%*d %d %d %d %d %d %d",&lp->lam_time, 
		       &lp->adjust_time.sec, 
		       &lp->adjust_time.usec, &lp->node, &lp->p1, 
		       &lp->p2);
		
		fprintf(ofd, "%d %d %d %d %d %d\n",
			lp->event_type, 
			lp->adjust_time.sec, 
			lp->adjust_time.usec, 
			lp->node, 
			0,
			0);
		break;
	    case USER_EVENT:
		break;
	    default:
		printf("Warning: a default value was found\n");
		sscanf(temp_line, "%*d %d %d %d %d",&lp->lam_time, 
		       &lp->adjust_time.sec, 
		       &lp->adjust_time.usec, &lp->node);
		
		break;
	    }
	}
    }
}
