/*****************************************************************************\
*                                                                             *
*  main.c - main module for Wamm					                          *
*                                                                             *
\*****************************************************************************/

/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */


 
#include "motifutil.h"
#include <sys/signal.h>

/**********/
/* Moduli */
/**********/

#include "modWAN.h"
#include "modTasks.h"
#include "modSpawn.h"
#include "modMake.h"
#include "modInternet.h"
#include "modPVM.h"
#include "modParser.h"
#include "modNetworkObj.h"

/**********************/
/* Funzioni importate */
/**********************/

/*extern void	Timeout (void);*/

void main(int argc, char * argv[])
{
	Widget Wtoplevel;
	XtAppContext AC;
	char * errmsg;
	struct NetworkObj * no;
	char buffer[1000];
	char * ptr;

	/*********************/
	/* Finestra iniziale */
	/*********************/
			
	Wtoplevel = XtAppInitialize (&AC, "Wamm", NULL, 0, &argc, argv, NULL, NULL, 0);
	
	/***************************/
	/* Inizializzazione moduli */
	/***************************/
	
	/* Va seguito quest'ordine:
	 * 1. NetworkObj (prepara l'albero)
	 * 2. Parser (inserisce i valori nell'albero)
	 * 3. WAN/MAN/LAN/Tasks/Spawn/Make (prepara le strutture per le finestre)
	 * 4. Internet
	 * 5. PVM (varie operazioni PVM)
	*/
	
	NetworkObjInit();
	
	/**** Parser ****/
	
	/* Cerca di aprire, nell'ordine:
	 *
	 * il file specificato come parametro (se presente)
	 * 1. WAMMNET
	 * 2. ~/.wammnetfile
	 *
	*/
	
	if (argc == 2) {
		errmsg = ParserInit (argv[1]);
		if (errmsg) {
			MotifError (Wtoplevel, "Parser error", errmsg);
			free (errmsg);
			ParserEnd ();
			NetworkObjEnd ();
			exit (1);
		}
	}
	
	else {
		ptr = getenv("WAMMNET");
		if (ptr) {
			errmsg = ParserInit (ptr);
			if (errmsg) {
				MotifError (Wtoplevel, "Parser error", errmsg);
				free (errmsg);
				ParserEnd ();
				NetworkObjEnd ();
				exit (1);
			}
		}
		
		else {
			sprintf (buffer, "%s/.wammnet", getenv ("HOME"));
			errmsg = ParserInit (buffer);
			if (errmsg) {
				MotifError (Wtoplevel, "Parser error", errmsg);
				free (errmsg);
				ParserEnd ();
				NetworkObjEnd ();
				exit (1);
			}
		}
	}
	
	errmsg = Parser();
	
	if (errmsg) {
		MotifError (Wtoplevel, "Parser error", errmsg);
		free (errmsg);
		ParserEnd ();
		NetworkObjEnd ();
		exit (1);
	}
	
	ParserEnd ();
	
	/**** Finestre ****/
	
	WANInit (Wtoplevel);
	MANInit (Wtoplevel);
	LANInit (Wtoplevel);
	TasksInit (Wtoplevel);
	SpawnInit (Wtoplevel);
	MakeInit (Wtoplevel);
	
	/**** Pixmaps ****/
		
	no = NetworkObjFirst ();
	
	while (no) {
		if (no->pict) {
			no -> pma.valuemask = 0;
			no -> pmres = XpmReadFileToPixmap (XtDisplay(Wtoplevel), RootWindowOfScreen(XtScreen(Wtoplevel)), no->pict, &no->pm, &no->pmmask, &no->pma);
		}
		no = no->next;
	}
	
	/**** apre la prima finestra ****/
	
	no = NetworkObjFind (NULL, NET_WAN);
	WANWindow (no);
	
	/**** internet ****/
	
	InternetInit();
	
	/**** PVM ****/
	
	PVMInit (no, Wtoplevel);
		
	/*************/
	/* Main Loop */
	/*************/

	/**** segnali ****/
	
	signal (SIGINT, SIG_IGN);
	signal (SIGTERM, SIG_IGN);
	signal (SIGCHLD, SIG_IGN);

	MotifStatusMsg (no->Wstatus, "\nWelcome to your metacomputer.\n\n");
	XtAppMainLoop (AC);
	/*Timeout();*/
}
