/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */

#ifndef _DUALSYNC_H_
#define _DUALSYNC_H_

#define TRACE_START	 1
#define SEND     	 4
#define RECV		 6
#define RECV_BLOCKING	 7
#define RECV_WAKING	 8
#define COMPSTATS	11
#define TRACE_END	19
#define USER_EVENT	20
#define MAXLINE		330
#define NPROC		528

#define DONE 1
#define MATCHED 1
#define MU 1000
#ifndef	_MIN
#  define _MIN(a,b)	((a)<(b)?(a):(b))
#endif
#ifndef	_MAX
#  define _MAX(a,b)	((a)>(b)?(a):(b))
#endif

typedef struct {
  int sec;
  int usec;
} TimeRec;

#define DEST p1
#define SRC  p1
#define MSG_TAG p2
#define MSG_LEN p3

typedef struct _LineRec {
  struct _LineRec* prev;
  struct _LineRec* next;
  int event_type;
  int node;
  int p1;
  int p2;
  int p3;
  int mark;
  int lam_time;
  TimeRec orig_time;
  TimeRec adjust_time;
  char *user_event;
} LineRec;

#endif


