/*
 * 
 *
 *               WAMM: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, M. Cosso, G. Faieta, M. Formica, 
 *                      D. Laforenza, M. Nicosia 
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 * 
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *
 * We want thanks Brad Topol of the Georgia Institute of Technology, Atlanta.
 */ 
 
#include <stdio.h>
#include "defines.h"

main(argc, argv)
  int argc;
  char *argv[];
{
  FILE *fptr=NULL;

  int is_comp[MAXP], comp[MAXP], which_comp[MAXP], recv_type[MAXP], 
      recv_other[MAXP], recv_lth[MAXP], node, sec, msec, type, lth, 
      other, key, i, j, k;
  float ftime;
  char line[MAXLTH], buf[MAXLTH];

  if(argc!=2){
    printf("Usage: converter filename\n");
    exit(1);
  }

  if((fptr=fopen(argv[1], "r"))==NULL){
    printf("Can't open file %s for reading\n", argv[1]);
    exit(1);
  }

  while(fgets(line, MAXLTH, fptr)!=NULL){
    sscanf(line, "%d %d %d", &key, &sec, &msec);
    ftime=(float)sec+((float)msec)/1000000;

    switch(key){
      case TRACE_START:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTENTRY, NTRACE, ftime, node);
	is_comp[node]=0;
      break;

      case OPEN:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTENTRY, NOPEN, ftime, node);
	comp[node]=OPEN;
	is_comp[node]=1;
      break;

      case SEND:
	sscanf(line, "%*d %*d %*d %d %d %d %d", &node, &other, &type, &lth);
	printf("%d %d %f %d -1 3 %d %d %d %d\n", EVENTENTRY, NSEND, ftime,
	  node, INTTYPE, lth, type, other);
	comp[node]=SEND;
	is_comp[node]=1;
      break;

      case RECV:
	sscanf(line, "%*d %*d %*d %d %d %d %d", &node, &other, &type, &lth);
	printf("%d %d %f %d -1 1 %d %d\n", EVENTENTRY, NRECV, ftime, node, 
	  INTTYPE, type);
	recv_type[node]=type; recv_other[node]=other; recv_lth[node]=lth;
	comp[node]=RECV;
	is_comp[node]=1;
      break;

      case RECV_BLOCKING:
	sscanf(line, "%*d %*d %*d %d %d", &node, &type);
	printf("%d %d %f %d -1 1 %d %d\n", EVENTENTRY, NRECVBLOCK, ftime, node, 
	  INTTYPE, type);
	is_comp[node]=0;
      break;

      case RECV_WAKING:
	sscanf(line, "%*d %*d %*d %d %d %d %d", &node, &other, &type, &lth);
	printf("%d %d %f %d 0 3 %d %d %d %d\n", EVENTEXIT, NRECVBLOCK, 
	  ftime, node, INTTYPE, lth, type, other);
	is_comp[node]=0;
      break;

      case MESSAGE:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTENTRY, NWRITE, ftime, node);
	comp[node]=MESSAGE;
	is_comp[node]=1;
      break;

      case SYNC:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTENTRY, NBARRIER, ftime, node);
	comp[node]=SYNC;
	is_comp[node]=1;
      break;

      case COMPSTATS:
	sscanf(line, "%*d %*d %*d %d", &node);
	if(is_comp[node]){
	  if(which_comp[node]==2){
	    is_comp[node]=0;
	    switch(comp[node]){
	      case OPEN:
	        printf("%d %d %f %d -1 0\n", EVENTEXIT, NOPEN, ftime, node);
	      break;

	      case SEND:
	        printf("%d %d %f %d -1 0\n", EVENTEXIT, NSEND, ftime, node);
	      break;

	      case RECV:
	        printf("%d %d %f %d -1 3 %d %d %d %d\n", EVENTEXIT, NRECV, 
		  ftime, node, INTTYPE, recv_lth[node], recv_type[node], 
	  	  recv_other[node]);
	      break;

	      case MESSAGE:
	        printf("%d %d %f %d -1 0\n", EVENTEXIT, NWRITE, ftime, node);
	      break;

	      case SYNC:
	        printf("%d %d %f %d -1 0\n", EVENTEXIT, NBARRIER, ftime, node);
	      break;

	      case CLOCK_SYNC:
	        printf("%d %d %f %d -1 0\n", EVENTEXIT, NCLOCKSYNC, ftime, 
		  node);
	      break;

	    }
	    which_comp[node]=1;
	  }else{
	    which_comp[node]=2;
	  }
	}
      break;

      case CLOSE:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTMARK, NCLOSE, ftime, node);
	is_comp[node]=0;
      break;

      case TRACE_LEVEL:
	sscanf(line, "%*d %*d %*d %d %d %d %d", &node, &i, &j, &k);
	printf("%d %d %f %d -1 3 %d %d %d %d\n", EVENTMARK, NTLEVEL, ftime, 
	  node, INTTYPE, i, j, k);
	is_comp[node]=0;
      break;

      case TRACE_MARK:
	sscanf(line, "%*d %*d %*d %d %d", &node, &type);
	printf("%d %d %f %d -1 0\n", EVENTMARK, type, ftime, node);
	is_comp[node]=0;
      break;

      case TRACE_MESSAGE:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTMESSAGE, -1, ftime, node);
	is_comp[node]=0;
      break;

      case TRACE_FULL:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTMARK, NTFULL, ftime, node);
	is_comp[node]=0;
      break;

      case TRACE_FLUSH:
	sscanf(line, "%*d %*d %*d %d %d %d", &node, &i, &j);
	printf("%d %d %f %d -1 0", EVENTENTRY, NTFLUSH, ftime, node);
        ftime=(float)i+((float)j)/1000000;
	printf("%d %d %f %d -1 0\n", EVENTEXIT, NTFLUSH, ftime, node);
	is_comp[node]=0;
      break;

      case TRACE_EXIT:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTEXIT, NTRACE, ftime, node);
	is_comp[node]=0;
      break;

      case BLOCK_BEGIN:
	sscanf(line, "%*d %*d %*d %d %d", &node, &type);
	printf("%d %d %f %d -1 0\n", EVENTENTRY, type, ftime, node);
	is_comp[node]=0;
      break;

      case BLOCK_END:
	sscanf(line, "%*d %*d %*d %d %d", &node, &type);
	printf("%d %d %f %d -1 0\n", EVENTEXIT, type, ftime, node);
	is_comp[node]=0;
      break;

      case TRACE_MARKS:
	sscanf(line, "%*d %*d %*d %d %d %n", &node, &i, &j);
	for(k=j; k<strlen(line)-1; k++)
	buf[k-j]=line[k];
	buf[k-j]=NULL;
	printf("%d %d %f %d -1 %d %s\n", EVENTMARK, -1, ftime, node, i, buf);
	is_comp[node]=0;
      break;

      case CLOCK_SYNC:
	sscanf(line, "%*d %*d %*d %d", &node);
	printf("%d %d %f %d -1 0\n", EVENTENTRY, NCLOCKSYNC, ftime, node);
	comp[node]=CLOCK_SYNC;
	is_comp[node]=1;
      break;

      case TFILES:
	sscanf(line, "%*d %*d %*d %d %d %d", &node, &i, &j);
	printf("%d %d %f %d -1 0", EVENTENTRY, NTFILES, ftime, node);
        ftime=(float)i+((float)j)/1000000;
	printf("%d %d %f %d -1 0\n", EVENTEXIT, NTFILES, ftime, node);
	is_comp[node]=0;
      break;

      default:
      break;

    }
  }
}
