#include "pvm3.h"
#include "wammOL.h"
#include <stdio.h>
#include <math.h>
#define SLAVENAME "heatslvw"
#define NPROC 5
#define TIMESTEP 100
#define PLOTINC 10
#define SIZE  1000

int num_data = SIZE/NPROC ;
main()
{
int miotid,task_ids[NPROC],i,j;
int left,right,k,l;
int step=TIMESTEP;
int info,zz;
double init[SIZE], solution[TIMESTEP][SIZE];
double result[TIMESTEP*SIZE/NPROC],deltax2;
FILE *filenum;
char *filename[4][7];
double deltat[4];
time_t t0;
int etime[4];

filename[0][0]="graph1";
filename[1][0]="graph2";
filename[2][0]="graph3";
filename[3][0]="graph4";
deltat[0]=5.0e-1;
deltat[1]=5.0e-3;
deltat[2]=5.0e-6;
deltat[3]=5.0e-9;


/* enroll in pvm */
/*wamm_setsampling(1,1);*/
miotid= pvm_mytid ();

/* spawn the slave task */

/*info=pvm_spawn(SLAVENAME,(char **)0,PvmTaskHost,"evans.cnuce.cnr.it",1,task_ids);*/
/*info=pvm_spawn(SLAVENAME,(char **)0,PvmTaskHost,"miles.cnuce.cnr.it",1,&task_ids[1]);*/
info=pvm_spawn(SLAVENAME,(char **)0,PvmTaskDefault,"",NPROC,task_ids);
/* crea i dati iniziali */

for(i=0;i<SIZE;i++)
  init[i]=sin(M_PI*((double)i/(double)(SIZE-1)));
init[0]=0.0;
init[SIZE-1]=0.0;

/* eseguo il problema 4 volte con diversi valori di delta t */

for(l=0;l<4;l++)
  {
    deltax2=(deltat[l]/pow(1.0/(double)SIZE,2.0));
    
    /* faccio partire il tempo per questa esecuzione */

    time(&t0);
    etime[l]=t0;
    
    /* spedisco i dati iniziali agli slave incluso i limiti dei vicini */
	
    for(i=0;i<NPROC;i++)
		{
    	zz=pvm_initsend(PvmDataDefault);
		left=(i==0)? 0 : task_ids[i-1];
		pvm_pkint(&left,1,1);
		right=(i==(NPROC-1))? 0 : task_ids[i+1];
		pvm_pkint(&right,1,1);
		pvm_pkint(&step,1,1);                                 
		pvm_pkdouble(&deltax2,1,1);
		pvm_pkint(&num_data,1,1);
		pvm_pkdouble(&init[num_data*i],num_data,1);
		pvm_send(task_ids[i],4);
	}
   /* aspetto i risultati */
	
    for(i=0;i<NPROC;i++){
		pvm_recv(task_ids[i],7);
		pvm_upkdouble(&result[0],num_data*TIMESTEP,1);

	/* modifico la soluzione */

		for(j=0;j<TIMESTEP;j++)
	  		for(k=0;k<num_data;k++)
	    		solution[j][num_data*i+k]=result[wh(j,k)];
	    
	}

    /* fermo il tempo */

    time(&t0);
    etime[l]=t0-etime[l];

    /* produco l'output */

    filenum=fopen(filename[l][0],"w");
    fprintf(filenum,"TitleText: Wire Heat over Delta Time: %e\n",deltat[l]);
    fprintf(filenum,"XUnitText: Distance \nYUnitText: Heat \n");
    for(i=0;i<TIMESTEP;i=i+PLOTINC){
		fprintf(filenum,"\"Time index: %d\n",i);
		for(j=0;j<SIZE;j++)
	  		fprintf(filenum,"%d %e\n",j,solution[i][j]);
		fprintf(filenum,"\n");
    }
    fclose(filenum);
  }

/*stampa le informazioni sul tempo */

  printf("Problem size: %d\n",SIZE);
  for(i=0;i<4;i++)
    printf("tempo di esecuzione %d:%d sec \n",i,etime[i]);

/* spedisco in multicast agli slave */

	/*for(i=0; i< NPROC; i++) {
  		pvm_initsend(PvmDataDefault);
  		pvm_send(task_ids[i],2000);
  	}*/
  	pvm_initsend(PvmDataDefault);
  	pvm_mcast(task_ids, NPROC, 2000);
	pvm_exit();
}

int wh(x,y)
int x,y;
{
return (x*num_data+y);
}


