/* 

  heatslv.c

    The slaves receive the initial data from the host,
	exchange boundary information with neighbors,
	and calculate the heat change in the wire.
	This is done for a number of iterations, sent by the master.

*/




#include "pvm3.h"
#include "wammOL.h"
#include <stdio.h>


int num_dat;

main()
{
  int miotid, left, right, i, j, master;
  int timestep=0;
  int buf, bytes, tipo, source;
  double *init;
  double  *A;
  double leftdata, rightdata, delta, leftside, rightside;

  
/* enroll in pvm */
/*wamm_setsampling(1,1);*/
  miotid = pvm_mytid();
  init = NULL;
  master = pvm_parent();

/* ricevo i dati dal master */
  while(1)
    {
      buf = pvm_recv(master, -1);
      pvm_bufinfo(buf,&bytes, &tipo, &source);
      if (tipo == 2000) break;
      pvm_upkint(&left, 1, 1);
      pvm_upkint(&right, 1, 1);
      pvm_upkint(&timestep, 1, 1);
      pvm_upkdouble(&delta, 1, 1);
      pvm_upkint(&num_dat, 1, 1);
	  if (( init = (double *) malloc(num_dat*sizeof(double)))==NULL)
      	printf("MEMORIA NON ALLOCATA\n");
	  pvm_upkdouble(init, num_dat, 1);


/* copia i dati iniziali nell' array di lavoro */

      A = (double *) malloc(num_dat * timestep * sizeof(double));
      for (i = 0; i < num_dat; i++) 
		A[i] = init[i];

/* sviluppo i calcoli */

      for (i = 0; i < timestep-1; i++){
	  	/* scambio informazioni limite con i vicini */
	  	/* send left, receive right */
	  	if (left != 0){
	      pvm_initsend(PvmDataDefault);
	      pvm_pkdouble(&A[wh(i,0)],1,1);
	      pvm_send(left, 5);
	    }
		if (right != 0){
	      pvm_recv(right, 5);
	      pvm_upkdouble(&rightdata, 1, 1);
	  		/* send right, receive left */
	      pvm_initsend(PvmDataDefault);
	      pvm_pkdouble(&A[wh(i,num_dat-1)],1,1);
	      pvm_send(right, 6);
	    }
	  	if (left != 0){
	      pvm_recv(left, 6);
	      pvm_upkdouble(&leftdata,1,1);
	    }

/* faccio i calcoli per questa iterazione */

	  	for (j = 0; j < num_dat; j++){
	      leftside = (j == 0) ? leftdata : A[wh(i,j-1)];
	      rightside = (j == (num_dat-1)) ? rightdata : A[wh(i,j+1)];
	      if ((j==0)&&(left==0))
			A[wh(i+1,j)] = 0.0;
	      else if ((j==(num_dat-1))&&(right==0))
			A[wh(i+1,j)] = 0.0;
	      else
			A[wh(i+1,j)]=A[wh(i,j)]+delta*(rightside-2*A[wh(i,j)]+leftside);
	    }
   
	}
 
/* spedisco i risultati al master */

      pvm_initsend(PvmDataDefault);
      pvm_pkdouble(&A[0], num_dat*timestep, 1);
      pvm_send(master, 7);
    
    } /*while*/

/* just for good measure */

	pvm_exit();

}


int wh(x, y)
     int x, y;
{
  return(x*num_dat+y);
}
