/******************************************************************************\
*																			   *
*  motifutil.h - prototipi per motifutil.c			                           *
*  1.0 - 2/6/95	 	    													   *
*																			   *
\******************************************************************************/

/*
 *
 *          WAMM version 1.0: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, G. Faieta, M. Formica, D. Laforenza
 *                   (C) 1995 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

#ifndef MOTIFUTIL_H
#define MOTIFUTIL_H

#include <Xm/XmAll.h>
#include <stdio.h>
#include <varargs.h>
#include <stdlib.h>
#include <unistd.h>
#include <netdb.h>

#define DEFSET XmSTRING_DEFAULT_CHARSET

/**********************/
/* Funzioni pubbliche */
/**********************/

unsigned char * MotifGetDisplayAddr (Display *);
int MotifXHost (Display *, unsigned char *, int);
void MotifNoGrabWarnings(void);
void MotifAddAction (Widget, char *, XtActionProc, char *);
Widget MotifCreateMenu (Widget, unsigned char *, char, int, int);
Widget MotifCreatePushMenu (Widget, unsigned char *, int, int);
Widget MotifCreateOptionMenu (Widget, unsigned char *, char);
Widget MotifAddMenuItem (Widget, unsigned char *, char, XtCallbackProc, XtPointer);
Widget MotifAddMenuToggle (Widget, unsigned char *, char, XtCallbackProc, XtPointer, int);
Widget MotifAddMenuLabel (Widget, unsigned char *);
void MotifAddListItem (Widget, unsigned char *);
int MotifListGetSelected (Widget, unsigned char ***, Boolean **);
void MotifStatusMsg ();
void MotifProtectShell (Widget, XtCallbackProc, XtPointer);
void MotifDeleteResponse (Widget, Boolean);
void MotifListSelectAll (Widget);
void MotifClearText (Widget);
void MotifForceDialog (Widget);
unsigned char * MotifAskFile (Widget, unsigned char *, unsigned char *);
Boolean MotifQuestion (Widget, char *, char *);
Widget MotifWait (Widget, char *, char *);
void MotifWarning (Widget, char *, char *);
void MotifError (Widget, char *, char *);
unsigned char * MotifAskPsw (Widget, unsigned char *, unsigned char *);
Widget MotifText (Widget, unsigned char *, unsigned char *);
Widget MotifOutput (Widget, unsigned char *, unsigned char *);
Widget MotifHelp (Widget, unsigned char *, unsigned char *);

/***********************/
/* Callbacks pubbliche */
/***********************/

void OkCB (Widget, int *, int);
void CancelCB (Widget, int *, int);
void NopCB (Widget, int, int);
void DestroyCB (Widget, Widget, int);

/*******************/
/* Macro pubbliche */
/*******************/

#define MotifAddMenuSep(menu) (XtManageChild (XmCreateSeparator(menu,"menusep", NULL, 0)))

/*

****************************************
* addr = MotifGetDisplayAddr (display) *
****************************************

Restituisce l'indirizzo (simbolico, completo) del display in uso. La stringa
va liberata dopo l'uso.

***********************************
* MotifXHost (display, addr, add) *
***********************************

Aggiunge (add=1) o rimuove (add=0) l'host dalla lista degli host remoti
che possono stabilire connessioni su "display". Restituisce 0 se addr non e`
riconosciuto.

NOTA: se xhost non e` utilizzabile viene generato un messaggio di errore.
Occorre stabilire un XErrorHandler.

**************************************************
* MotifAddAction (widget, acname, acproc, trans) *
**************************************************

Registra un'azione di nome "acname", realizzata dalla funzione "acproc" e
richiamata in base alla translation "trans". Es:

MotifAddAction (Wtext, "clear", (XtActionProc)ClearAC, "<Btn3Down>: clear()");

Invoca la funzione "ClearAC" ogni volta che si preme il tasto destro del mouse
sul widget "Wtext".

Azioni eventualmente preesistenti sono rimpiazzate (Override).

*******************************************************************
* menupane = MotifCreateMenu (menubar, name, mnem, help, tearoff) *
*******************************************************************

Aggiunge un menu alla menubar, restituendo il menupane su cui si possono poi
attaccare le voci (con MotifAddMenuItem). Se help=1, inserisce il menu in fondo
alla menubar. Se tearoff=1, crea un menu TearOff. Mnem = lettera da sottolineare.

NOTA: tearoff genera il warning:

	Warning: XtRemoveGrab asked to remove a widget not on the list
	
Apparentemente rientra nella famiglia degli warning da ignorare (cfr. FAQ).
Usare MotifNoGrabWarnings().

NOTA (4/4/95): ci sono dei problemi con i tearoff: se si stacca un menu, poi lo
si stacca ancora quando e` gia` mostrato in una finestra separata, infine si
chiude la finestra principale, si rischia il crash. Occorre investigare; nel
frattempo e` bene non usare i tearoff...

*******************************************************
* menupane = MotifCreatePushMenu (parent, name, x, y) *
*******************************************************

Attacca al widget "parent" un bottone con associato un menu.
Usare MotifAddMenuItem per aggiungere una voce.

***************************************************************
* MotifAddMenuItem (menu, title, mnem, callback, client_data) *
***************************************************************

Aggiunge un item (attivo) al menu, registrando anche una callback.
Restituisce l'item

**********************************************************************
* MotifAddMenuToggle (menu, title, mnem, callback, client_data, set) *
**********************************************************************

Aggiunge un toggle (attivo) al menu, registrando anche una callback.
Il toggle e` settato se "set" = 1.
Restituisce l'item.

***********************************
* MotifAddMenuLabel (menu, title) *
***********************************

Aggiunge una label al menu. Restituisce la label.

**********************************
* MotifAddListItem (list, entry) *
**********************************

Aggiunge un elemento alla FINE della lista

*********************************************
* MotifListGetSelected (list, &items, &mem) *
*********************************************

Preleva gli elementi selezionati dalla lista, alloca items (array di ptr
a carattere) e mem (array di booleani) e inserisce i dati sugli item
selezionati (mem[i] = True se items[i] deve essere rilasciato). Restituisce
il numero di elementi selezionati (se 0 i due array non devono essere
rilasciati!).

***********************************
* MotifStatusMsg (list, fmt, ...) *
***********************************

Mostra una stringa (fmt = come printf) in fondo ad un XmText

****************************************************
* MotifProtectShell (shell, callback, client_data) *
****************************************************

Aggiunge alla shell una callback per la chiusura "pilotata" della finestra

***************************************
* MotifDeleteResponse (shell, status) *
***************************************

status=False: disattiva il bottone di chiusura della shell;
status=True: lo riabilita (esegue un UNMAP)

*****************************
* MotifListSelectAll (list) *
*****************************

Seleziona tutti gli elementi di una lista (funzione inspiegabilmente non
presente in Motif 1.2!!!)

*************************
* MotifClearText (text) *
*************************

Cancella il contenuto di un widget Text

**************************************************************
* MotifForceDialog (dialog) - forza l'apparizione del dialog *
**************************************************************

Forza l'apparizione del dialog - Codice di David Brooks (OSF),
preso da Motif-FAQ. "dialog" = un qualsiasi widget del dialog,
incluso la shell.

***********************************************************
* MotifAskFile (shell, title, pattern) - richiede un file *
***********************************************************

Apre un FileSelectionDialog sulla shell "shell", con titolo "title" e
pattern di selezione iniziale "pattern". Il dialog e` modale; la chiusura
della finestra equivale al Cancel.

Se e` stato selezionato un file restituisce il nome (rilasciare la stringa
con free quando non serve piu`), altrimenti NULL.

*****************************************************************
* MotifQuestion (shell, title, msg) - mostra un question dialog *
*****************************************************************

Mostra un question dialog modale con titolo "title" e messaggio "msg", sulla
shell "shell". Restituisce True (= "ok") o False (= "abort"); la chiusura
della finestra equivale ad abort.

********************************************************
* MotifWarning (shell, title, msg) - mostra un warning *
********************************************************

Mostra un warning dialog modale con titolo "title" e messaggio "msg", sulla
shell "shell".

*****************************************************
* MotifError (shell, title, msg) - mostra un errore *
*****************************************************

Mostra un error dialog modale con titolo "title" e messaggio "msg", sulla
shell "shell".

****************************************************************
* MotifWait (shell, title, msg) - working dialog senza bottoni *
****************************************************************

Restituisce un working dialog modale con titolo "title" e messaggio "msg",
sulla shell "shell". Il dialog non si puo` chiudere e non ha bottoni: l'utente
deve attendere. Rilasciare con XtUnmanageChild e XtDestroyWidget.

***********************************************************
* MotifAskPsw (shell, title, msg) - richiede una password *
***********************************************************

Chiede una password. Restitusce NULL se l'utente chiude il dialog o clicka
su "Cancel", altrimenti restituisce la password. La password NON va rilasciata
con free: viene mantenuta finche` non si esegue di nuovo MotifAskPsw!

*****************************************************************
* MotifOutput (shell, title, msg) - dialog con uno ScrolledText *
*****************************************************************

Mostra "msg" in uno scrolled text non modale. Restituisce il widget XmText.
Chiusura finestra o click su OK ==> distruzione dialog.

***************************************************************
* MotifHelp (shell, title, msg) - dialog con uno ScrolledText *
***************************************************************

Mostra "msg" in uno scrolled text non modale. Restituisce il widget XmText.
Per ora e` identico a MotifOutput (ma il widget si chiama "help" e non "text").
Chiusura finestra o click su OK ==> distruzione dialog.

***********************
* OkCB (w, &res, int) *
***********************

Mette "1" in res.

***************************
* CancelCB (w, &res, int) *
***************************

Mette "-1" in res.

***********************
* NopCB (w, int, int) *
***********************

Callback "neutra" che non fa nulla.

***************************
* DestroyCB (w, wid, int) *
***************************

Distrugge wid. Usare per i bottoni di chiusura delle finestre

*/

#endif
