/******************************************************************************\
*																			   *
*  motifutil.c - funzioni motif di utilita` generale                           *
*  1.0 - 2/6/95															   	   *
*																			   *
\******************************************************************************/

/*
 *
 *          WAMM version 1.0: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, G. Faieta, M. Formica, D. Laforenza
 *                   (C) 1995 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

#include "motifutil.h"

#define MAXPASSWD 20		/* caratteri password (max) */

/*********************/
/* Globali (private) */
/*********************/

static unsigned char password [MAXPASSWD+1];		/* password */

/*********************/
/* Callbacks private */
/*********************/

static void PswCB (Widget, int, XmTextVerifyCallbackStruct *);
static void NoGrabWarningsCB (String);

/************************************************************************/
/* MotifGetDisplayAddr (dis) - preleva l'indirizzo completo del display */
/************************************************************************/

unsigned char * MotifGetDisplayAddr (Display * dis)
{
	unsigned char displaystr[100];
	unsigned char numbers[100];
	unsigned char displayaddr[100];
	int i;
	
	sprintf(displaystr, "%s", DisplayString(dis));
	
	/**** sposta ":x.x" in numbers ****/ 
	
	i = 0;
	while (displaystr[i] != ':')i++;
	strcpy (numbers, displaystr+i);
	displaystr[i] = 0;
	
	/**** se la stringa rimanente e` vuota, usa gethostname ****/
	
	if (!displaystr[0]) gethostname (displaystr, 100);

	/**** determina l'indirizzo completo ****/
	
	sprintf (displayaddr, "%s%s", gethostbyname(displaystr)->h_name, numbers);
	return (strdup (displayaddr));
}

/***********************************/
/* MotifXHost (display, addr, add) */
/***********************************/

int MotifXHost (Display * dis, unsigned char * addr, Bool add)
{

	XHostAddress ha;
	struct hostent * hp;
	char ** list;
	
	hp = gethostbyname(addr);
	if (!hp) return 0;
	
	ha.family = FamilyInternet;
	ha.length = hp->h_length;

#ifdef h_addr
	
	for (list = hp->h_addr_list; *list; list++) {
	    ha.address = *list;
	    if (add) XAddHost (dis, &ha);
		else XRemoveHost (dis, &ha);
	}
	
#else

	ha.address = hp->h_addr;
	if (add) XAddHost (dis, &ha);
	else XRemoveHost (dis, &ha);
	
#endif

	XSync (dis, False);		/**** FONDAMENTALE!!! ****/
	
	return 1;
}

/*********************************************************************/
/* MotifNoGrabWarnings () - disabilita gli warnings relativi ai menu */
/*********************************************************************/

void MotifNoGrabWarnings (void)
{
	XtSetWarningHandler(NoGrabWarningsCB);
}

void NoGrabWarningsCB (String msg)
{
	if (strstr(msg, "XtRemoveGrab") || strstr(msg, "nonexistent passive grab")) return;
	fprintf(stderr, msg);
}

/***************************************************************/
/* MotifAddAction (w, astr, aproc, trans) - aggiunge un'azione */
/***************************************************************/

void MotifAddAction (Widget w, char * astr, XtActionProc aproc, char * trans)
{
	XtActionsRec ar[1];
	XtTranslations tr;
	
	/**** registra il nome della funzione ****/
	
	ar[0].string = astr;
	ar[0].proc = aproc;
	XtAppAddActions (XtWidgetToApplicationContext(w), ar, 1);

	/**** associazione ****/

	tr = XtParseTranslationTable (trans);
	XtOverrideTranslations (w, tr);
}

/***************************************************************************/
/* MotifCreateMenu (menubar, name, mnem, help, tearoff) - aggiunge un menu */
/***************************************************************************/

Widget MotifCreateMenu (Widget menubar, unsigned char * name, char mnem, int help, int tearoff)
{
	Widget menupane, cascade;
	int n;
	Arg args[5];
	
	n = 0;
	if (tearoff) {XtSetArg (args[n], XmNtearOffModel, XmTEAR_OFF_ENABLED); n++;}
	menupane = XmCreatePulldownMenu (menubar, "menupane", args, n);
	
	n = 0;
	XtSetArg (args[n], XmNmnemonic, mnem); n++;
	XtSetArg (args[n], XmNsubMenuId, menupane); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate (name, DEFSET)); n++;
	cascade = XmCreateCascadeButton (menubar, "menu", args, n);
	XtManageChild (cascade);
	
	if (help) {
		n = 0;
		XtSetArg (args[n], XmNmenuHelpWidget, cascade); n++;
		XtSetValues (menubar, args, n);
	}
	
	return (menupane);
}

/******************************************************************/
/* MotifCreatePushMenu (parent, name, x, y) - crea un "push menu" */
/******************************************************************/

Widget MotifCreatePushMenu (Widget parent, unsigned char * name, int x, int y)
{
	Widget menubar, menupane, cascade;
	int n;
	Arg args[5];
	
	n = 0;
	XtSetArg (args[n], XmNx, x); n++;
	XtSetArg (args[n], XmNy, y); n++;
	menubar = XmCreateMenuBar (parent, "menubar", args, n);
	XtManageChild (menubar);
	
	n = 0;
	menupane = XmCreatePulldownMenu (menubar, "menupane", args, n);
	
	n = 0;
	XtSetArg (args[n], XmNsubMenuId, menupane); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate (name, DEFSET)); n++;
	cascade = XmCreateCascadeButton (menubar, "menu", args, n);
	XtManageChild (cascade);
	
	return (menupane);
}

/****************************************************************************/
/* MotifAddMenuItem (menu, title, mnem, callback, client_data) - nuovo item */
/****************************************************************************/

Widget MotifAddMenuItem (Widget menu, unsigned char * title, char mnem, XtCallbackProc callback, XtPointer client_data)
{
	Widget button;
	int n;
	Arg args[5];
	
	n = 0;
	XtSetArg (args[n], XmNmnemonic, mnem); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreateLtoR (title, DEFSET)); n++;
	button = XmCreatePushButton (menu, "menuitem", args, n);
	XtManageChild (button);
	XtSetSensitive (button, True);
	XtAddCallback (button, XmNactivateCallback, callback, (XtPointer)client_data);

	return button;
}

/*************************************************************************************/
/* MotifAddMenuToggle (menu, title, mnem, callback, client_data, set) - nuovo toggle */
/*************************************************************************************/

Widget MotifAddMenuToggle (Widget menu, unsigned char * title, char mnem, XtCallbackProc callback, XtPointer client_data, int set)
{
	Widget button;
	int n;
	Arg args[5];
	
	n = 0;
	XtSetArg (args[n], XmNmnemonic, mnem); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreateLtoR (title, DEFSET)); n++;
	XtSetArg (args[n], XmNset, set); n++;
	button = XmCreateToggleButton (menu, "menuitem", args, n);
	XtManageChild (button);
	XtSetSensitive (button, True);
	XtAddCallback (button, XmNvalueChangedCallback, callback, (XtPointer)client_data);

	return button;
}

/****************************************************************/
/* MotifAddMenuLabel (menu, title) - aggiunge una label al menu */
/****************************************************************/

Widget MotifAddMenuLabel (Widget menu, unsigned char * title)
{
	Widget label;
	int n;
	Arg args[5];
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreateLtoR (title, DEFSET)); n++;
	label = XmCreateLabel (menu, "menuitem", args, n);
	XtManageChild (label);
	
	return label;
}

/**************************************************************************/
/* MotifAddListItem (list, item) - aggiunge un item alla FINE della lista */
/**************************************************************************/

void MotifAddListItem (Widget list, unsigned char * item)
{
	XmString str;
	
	str = XmStringCreate(item, DEFSET);
	XmListAddItem (list, str, 0);
	XmStringFree(str);
}

/*********************************************/
/* MotifListGetSelected (list, &items, &mem) */
/*********************************************/

int MotifListGetSelected (Widget Wlist, unsigned char *** items, Boolean ** mem)
{
	int n;
	Arg args[5];
	XmStringTable list;		/* elementi selezionati */
	int num;				/* numero di elementi selezionati */
	
	unsigned char ** itemlist;	/* elementi selezionati (formato leggibile) */
	Boolean * memlist;			/* True = rilasciare la memoria */
	
	/**** estrae gli elementi dalla lista ****/
	
	n = 0;
	XtSetArg (args[n], XmNselectedItems, &list); n++;
	XtSetArg (args[n], XmNselectedItemCount, &num); n++;
	XtGetValues (Wlist, args, n);
	if (!num) return (0);

	itemlist = calloc (num, sizeof (char *));
	memlist = calloc (num, sizeof (Boolean));
	for (n=0; n<num; n++) memlist[n] = XmStringGetLtoR (list[n], DEFSET, (char **)(&itemlist[n]));

	*items = itemlist;
	*mem = memlist;
	return num;
}

/*********************************************************************/
/* MotifStatusMsg (status, fmt, arg1, arg2...) - mostra un messaggio */
/*********************************************************************/

void MotifStatusMsg (status, fmt, va_alist)
Widget status;
unsigned char * fmt;
va_dcl
{
	va_list args;
	unsigned char * out;

	out = calloc (10000, 1);

	va_start(args);
	vsprintf (out, fmt, args);
	va_end (list);
		
	XmTextInsert (status, XmTextGetLastPosition(status), out);
	XmTextShowPosition (status, XmTextGetLastPosition(status));
	XmUpdateDisplay (status);
	
	free (out);
}

/**************************************************************************/
/* MotifProtectShell (shell, callback, client_data) - protezione chiusura */
/**************************************************************************/

void MotifProtectShell (Widget shell, XtCallbackProc callback, XtPointer client_data)
{
	Atom wm_delete_window;

	wm_delete_window = XmInternAtom(XtDisplay(shell), "WM_DELETE_WINDOW", False);
	XmAddWMProtocolCallback (shell, wm_delete_window, callback, client_data);
}

/******************************************************************************/
/* MotifDeleteResponse (shell, status) - (dis)abilita la chiusura della shell */
/******************************************************************************/

void MotifDeleteResponse (Widget shell, Boolean status)
{
	int n;
	Arg args[5];
	
	n = 0;
	if (status) {XtSetArg (args[n], XmNdeleteResponse, XmUNMAP); n++;}
	else {XtSetArg (args[n], XmNdeleteResponse, XmDO_NOTHING); n++;}
	XtSetValues (shell, args, n);
}

/*************************************************************************/
/* MotifListSelectAll (list) - seleziona tutti gli elementi di una lista */
/*************************************************************************/

void MotifListSelectAll (Widget list)
{
	int n;
	Arg args[5];
	XmStringTable strings;
	int numitems;

	/* Motif non ha una XmListSelectAllItems e XmListSelectPos
	   seleziona UN elemento, deselezionando tutti gli altri! Occorre
	   usare questo metodo sporchissimo... */
		
	n = 0;
	XtSetArg (args[n], XmNitemCount, &numitems); n++;
	XtSetArg (args[n], XmNitems, &strings); n++;
	XtGetValues (list, args, n);

	n = 0;
	XtSetArg (args[n], XmNselectedItemCount, numitems); n++;
	XtSetArg (args[n], XmNselectedItems, strings); n++;
	XtSetValues (list, args, n);
}

/****************************************************/
/* MotifClearText (text) - ripulisce un text widget */
/****************************************************/

void MotifClearText (Widget text)
{
	int n;
	Arg args[5];
	String value;
	
	n = 0;
	XtSetArg (args[n], XmNvalue, &value); n++;
	XtGetValues (text, args, n);
	XtFree (value);
	
	n = 0;
	XtSetArg (args[n], XmNvalue, ""); n++;
	XtSetValues (text, args, n);
}

/*********************************************************************/
/* MotifForceDialog (Widget dialog) - porta il dialog in primo piano */
/*********************************************************************/

/* Nota: codice (oscuro ma funzionante) di David Brooks (OSF). Cfr FAQ. */

void MotifForceDialog (Widget dialog)
{
	Widget diashell, topshell;
	Window diawindow, topwindow;
	Display * dis;
	XWindowAttributes xwa;
  	XEvent xe;
 	XtAppContext xac;

	diashell = dialog;
	while (!XtIsShell(diashell)) diashell = XtParent(diashell);
	topshell = diashell;
	while (!XtIsTopLevelShell(topshell)) topshell = XtParent(topshell);
 
	if (XtIsRealized(diashell) && XtIsRealized(topshell)) {
		dis = XtDisplay(topshell);
		diawindow = XtWindow(diashell);
		topwindow = XtWindow(topshell);
		xac = XtWidgetToApplicationContext (diashell);
		
		while (XGetWindowAttributes (dis, diawindow, &xwa), xwa.map_state != IsViewable) {
		
			if (XGetWindowAttributes (dis, topwindow, &xwa), xwa.map_state != IsViewable) break;
			XtAppNextEvent (xac, &xe);
			XtDispatchEvent (&xe);
		}
	}
	
	XmUpdateDisplay (topshell);
}

/***********************************************************/
/* MotifAskFile (shell, title, pattern) - richiede un file */
/***********************************************************/

unsigned char * MotifAskFile (Widget shell, unsigned char * title, unsigned char * pattern)
{
	int n, res;
	Arg args[20];
	Widget filesel;
	
	char * file;
	char * xmfile;
	
	n = 0;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate (title, DEFSET)); n++;
	XtSetArg (args[n], XmNwidth, 400); n++;
	XtSetArg (args[n], XmNpattern, XmStringCreate(pattern, DEFSET)); n++;
	filesel = XmCreateFileSelectionDialog (shell, "filesel", args, n);
	XtUnmanageChild (XmFileSelectionBoxGetChild (filesel, XmDIALOG_HELP_BUTTON));
	XtAddCallback (filesel, XmNokCallback, (XtCallbackProc)OkCB, &res);
	XtAddCallback (filesel, XmNcancelCallback, (XtCallbackProc)CancelCB, &res);
	XtManageChild (filesel);
	MotifProtectShell (XtParent(filesel), (XtCallbackProc)CancelCB, &res);
	
	/**** attende gli eventi ****/
	
	res = 0;
	while (!res) XtAppProcessEvent (XtWidgetToApplicationContext(filesel), XtIMAll);
	if (res == -1) {
		XtUnmanageChild (filesel);
		XtDestroyWidget (filesel);
		return NULL;
	}
	
	/**** preleva il file ****/
	
	n = 0;
	XtSetArg (args[n], XmNdirSpec, &xmfile); n++;
	XtGetValues (filesel, args, n);
	XmStringGetLtoR (xmfile, DEFSET, &file);
	free (xmfile);
	XtUnmanageChild (filesel);
	XtDestroyWidget (filesel);
	
	return (unsigned char *)file;
}

/*********************************************************************/
/* MotifQuestion (shell, title, msg) - mostra un messaggio (domanda) */
/*********************************************************************/

Boolean MotifQuestion (Widget shell, char * title, char * msg)
{
	int n;
	Arg args[10];
	Widget dialog;
	int res;
	
	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate (title, DEFSET)); n++;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
	XtSetArg (args[n], XmNmessageString, XmStringCreateLtoR (msg, DEFSET)); n++;
	dialog = XmCreateQuestionDialog (shell, "question", args, n);
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
	XtAddCallback (dialog, XmNokCallback, (XtCallbackProc)OkCB, &res);
	XtAddCallback (dialog, XmNcancelCallback, (XtCallbackProc)CancelCB, &res);
	XtManageChild (dialog);
	MotifProtectShell (XtParent(dialog), (XtCallbackProc)CancelCB, &res);
	
	res = 0;
	while (!res) XtAppProcessEvent (XtWidgetToApplicationContext(dialog), XtIMAll);
	XtUnmanageChild (dialog);
	XtDestroyWidget (dialog);
	
	if (res == -1) return False;
	else return True;
}

/********************************************************/
/* MotifWarning (shell, title, msg) - mostra un warning */
/********************************************************/

void MotifWarning (Widget shell, char * title, char * msg)
{
	int n;
	Arg args[10];
	Widget dialog;
	int res;
	
	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate (title, DEFSET)); n++;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
	XtSetArg (args[n], XmNmessageString, XmStringCreateLtoR (msg, DEFSET)); n++;
	dialog = XmCreateWarningDialog (shell, "warning", args, n);
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_CANCEL_BUTTON));
	XtAddCallback (dialog, XmNokCallback, (XtCallbackProc)OkCB, &res);
	XtManageChild (dialog);
	MotifProtectShell (XtParent(dialog), (XtCallbackProc)OkCB, &res);
	
	res = 0;
	while (!res) XtAppProcessEvent (XtWidgetToApplicationContext(dialog), XtIMAll);
	XtUnmanageChild (dialog);
	XtDestroyWidget (dialog);
}

/*****************************************************/
/* MotifError (shell, title, msg) - mostra un errore */
/*****************************************************/

void MotifError (Widget shell, char * title, char * msg)
{
	int n;
	Arg args[10];
	Widget dialog;
	int res;
	
	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate (title, DEFSET)); n++;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
	XtSetArg (args[n], XmNmessageString, XmStringCreateLtoR (msg, DEFSET)); n++;
	dialog = XmCreateErrorDialog (shell, "error", args, n);
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_CANCEL_BUTTON));
	XtAddCallback (dialog, XmNokCallback, (XtCallbackProc)OkCB, &res);
	XtManageChild (dialog);
	MotifProtectShell (XtParent(dialog), (XtCallbackProc)OkCB, &res);
	
	res = 0;
	while (!res) XtAppProcessEvent (XtWidgetToApplicationContext(dialog), XtIMAll);
	XtUnmanageChild (dialog);
	XtDestroyWidget (dialog);
}

/***********************************************************/
/* MotifAskPsw (shell, title, msg) - Richiede una password */
/***********************************************************/

unsigned char * MotifAskPsw (Widget shell, unsigned char * title, unsigned char * msg)
{
	int n;
	Arg args[10];
	Widget dialog;
	int res;
	
	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate (title, DEFSET)); n++;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
	XtSetArg (args[n], XmNselectionLabelString, XmStringCreateLtoR (msg, DEFSET)); n++;
	dialog = XmCreatePromptDialog (shell, "pswdialog", args, n);
	XtUnmanageChild (XmSelectionBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
	XtManageChild (dialog);
	XtAddCallback (dialog, XmNokCallback, (XtCallbackProc)OkCB, &res);
	XtAddCallback (dialog, XmNcancelCallback, (XtCallbackProc)CancelCB, &res);
	XtAddCallback (XmSelectionBoxGetChild (dialog, XmDIALOG_TEXT), XmNmodifyVerifyCallback, (XtCallbackProc)PswCB, NULL);
	MotifProtectShell (XtParent(dialog), (XtCallbackProc)CancelCB, &res);
	
	res = 0;
	password[0] = 0;
	
	while (!res) XtAppProcessEvent (XtWidgetToApplicationContext(dialog), XtIMAll);
	
	XtDestroyWidget (dialog);
	if (res == -1) return NULL;
	
	return password;
}

/**** Callback per sostiture le lettere con "*" ****/

void PswCB (Widget w, int dummy, XmTextVerifyCallbackStruct * tv)
{

	/*    | P | A | S | S | W | O | R | D | ....
	 *
	 *        ^startpos       ^endpos
	 *
	 *
	 *	tv->startPos e tv->endPos non sono indici di caratteri ma posizioni
	 *  del cursore "|" (0..). startPos indica il punto di inserimento (il
	 *	nuovo carattere viene inserito a destra del |); se endPos > startPos
	 *	tutti i caratteri compresi verranno sostituiti da quello nuovo.
	*/

	int i, len, pos;
	
	/**** impedisce le modifiche non alla fine ****/
	
	len = strlen (password);
	if (tv->endPos < len) tv->endPos = len;
	
	/**** inserisce i nuovi caratteri (in genere uno solo alla volta!) ****/
	
	pos = tv->startPos;
	
	if (tv->text->ptr) for (i=0; i<tv->text->length; i++)
		if (pos < MAXPASSWD) {
			password[pos++] = tv->text->ptr[i];
			password[pos] = 0;
			tv->text->ptr[i] = '*';
		} else tv->doit = False;
}

/********************************************************************/
/* MotifWait (shell, title, msg) - messaggio senza bottoni (attesa) */
/********************************************************************/

Widget MotifWait (Widget shell, char * title, char * msg)
{
	int n;
	Arg args[10];
	Widget dialog;
	
	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate (title, DEFSET)); n++;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
	XtSetArg (args[n], XmNmessageString, XmStringCreateLtoR (msg, DEFSET)); n++;
	dialog = XmCreateWorkingDialog (shell, "working", args, n);
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_SEPARATOR));
	XtManageChild (dialog);
	MotifDeleteResponse (XtParent (dialog), False);
	MotifForceDialog (dialog);
	return dialog;
}

/*************************************************************************/
/* MotifOutput (shell, title, msg) - msg in uno scrolled text non modale */
/*************************************************************************/

Widget MotifOutput (Widget shell, unsigned char * title, unsigned char * msg)
{
	int n;
	Arg args[20];
	Widget Wdialog, Wtext, Wbutton;
	
	/**** dialog ****/

	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate(title, DEFSET)); n++;
	XtSetArg (args[n], XmNwidth, 700); n++;
	XtSetArg (args[n], XmNheight, 350); n++;
	XtSetArg (args[n], XmNresizePolicy, XmRESIZE_GROW); n++;
	Wdialog = XmCreateFormDialog (shell, "outputdialog", args, n);
	XtManageChild (Wdialog);
	MotifProtectShell (XtParent(Wdialog), (XtCallbackProc)DestroyCB, XtParent(Wdialog));
	
	/**** scrolled text ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 45); n++;
	XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg (args[n], XmNeditable, False); n++;
	XtSetArg (args[n], XmNcursorPositionVisible, False); n++;
	XtSetArg (args[n], XmNvalue, msg); n++;
	Wtext = XmCreateScrolledText (Wdialog, "outputtext", args, n);
	XtManageChild (Wtext);
	
	/**** bottone ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("OK", DEFSET)); n++;
	XtSetArg (args[n], XmNwidth, 80); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 5); n++;
	Wbutton = XmCreatePushButton (Wdialog, "outputok", args, n);
	XtManageChild (Wbutton);
	XtAddCallback (Wbutton, XmNactivateCallback, (XtCallbackProc)DestroyCB, XtParent (Wdialog));
	
	return Wtext;
}

/***********************************************************************/
/* MotifHelp (shell, title, msg) - msg in uno scrolled text non modale */
/***********************************************************************/

Widget MotifHelp (Widget shell, unsigned char * title, unsigned char * msg)
{
	int n;
	Arg args[20];
	Widget formdialog, text, button;
	
	/**** form dialog ****/

	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate(title, DEFSET)); n++;
	XtSetArg (args[n], XmNwidth, 700); n++;
	XtSetArg (args[n], XmNheight, 350); n++;
	XtSetArg (args[n], XmNresizePolicy, XmRESIZE_GROW); n++;
	formdialog = XmCreateFormDialog (shell, "formdialog", args, n);
	XtManageChild (formdialog);
	MotifProtectShell (XtParent(formdialog), (XtCallbackProc)DestroyCB, XtParent(formdialog));
	
	/**** scrolled text ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 45); n++;
	XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg (args[n], XmNeditable, False); n++;
	XtSetArg (args[n], XmNcursorPositionVisible, False); n++;
	XtSetArg (args[n], XmNvalue, msg); n++;
	text = XmCreateScrolledText (formdialog, "help", args, n);
	XtManageChild (text);
	
	/**** bottone ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("OK", DEFSET)); n++;
	XtSetArg (args[n], XmNwidth, 80); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 5); n++;
	button = XmCreatePushButton (formdialog, "ok", args, n);
	XtManageChild (button);
	XtAddCallback (button, XmNactivateCallback, (XtCallbackProc)DestroyCB, XtParent (formdialog));
	
	return text;
}
	
/********/
/* OkCB */
/********/

void OkCB (Widget w, int * res, int dummy)
{
	*res = 1;
}

/************/
/* CancelCB */
/************/

void CancelCB (Widget w, int * res, int dummy)
{
	*res = -1;
}

/*********/
/* NopCB */
/*********/

void NopCB (Widget w, int dummy1, int dummy2)
{
	return;
}

/*************/
/* DestroyCB */
/*************/

void DestroyCB (Widget w, Widget wid, int dummy2)
{
	XtDestroyWidget (wid);
}

