/*****************************************************************************\
*                                                                             *
*  modWAN.c - Gestione WAN				                                      *
*  1.0 - 16/6/95                                                              *
*                                                                             *
\*****************************************************************************/

/*
 *
 *          WAMM version 1.0: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, G. Faieta, M. Formica, D. Laforenza
 *                   (C) 1995 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

#include "modWAN.h"
#include "wamm.xpm"
#include "cnuce.xpm"

/***************/
/* definizioni */
/***************/

#define LOGOHEIGHT	40				/* spazio per il logo */

/*******************************/
/* variabili globali (private) */
/*******************************/

static Widget Wtoplevel;

/********************/
/* funzioni private */
/********************/

/*********************/
/* callbacks private */
/*********************/

static void SelectAllCB (Widget, struct NetworkObj *, int);		/* select all lista */
static void DeselectAllCB (Widget, struct NetworkObj *, int);	/* deselect all lista */
static void ClearStatusCB (Widget, struct NetworkObj *, int);	/* reset text status */
static void ListCB (Widget, int, XmListCallbackStruct *);		/* doppio click lista */
static void ButtonCB (Widget, struct NetworkObj *, int);		/* bottone su MAN */

static void QuitCB (Widget, struct NetworkObj *, int);			/* quit */
static void HaltCB (Widget, struct NetworkObj *, int);			/* halt */
static void AddCB (Widget, struct NetworkObj *, int);			/* add pvm */
static void DelCB (Widget, struct NetworkObj *, int);			/* del pvm */
static void CheckCB (Widget, struct NetworkObj *, int);			/* check pvm */
static void MakeCB (Widget, struct NetworkObj *, int);			/* make */
static void SpawnCB (Widget, struct NetworkObj *, int);			/* spawn */
static void TasksWinCB (Widget, struct NetworkObj *, int);		/* finestra tasks */
static void MakeWinCB (Widget, struct NetworkObj *, int);		/* finestra make */
static void RepairCB (Widget, struct NetworkObj *, int);		/* clear /tmp/pvmd */
static void PingCB (Widget, struct NetworkObj *, int);			/* ping */
static void TracerouteCB (Widget, struct NetworkObj *, int);	/* traceroute */
static void HelpVersionCB (Widget, struct NetworkObj *, int);	/* help versione */
static void HelpCopyrightCB (Widget, struct NetworkObj *, int);	/* help copyright */

/***********/
/* WANInit */
/***********/

void WANInit (Widget toplevel)
{
	Wtoplevel = toplevel;
}

/*******************************/
/* WANEnd - distruzione modulo */
/*******************************/

void WANEnd (void)
{
	/* XXX per ora nulla */
}

/*********************************************/
/* WANWindow (no) - disegna una finestra WAN */
/*********************************************/

void WANWindow (struct NetworkObj * no)
{
	Arg args[20];
	int n, i;
	int res;
	int dummy1, dummy2;
	Bool hasshape;
	Pixmap pm, mask;
	XpmAttributes pma;
	
	Widget Wmainform, Wmenubar, Wmenupane, Wpanedwin, Wtopform;
	Widget Wlist, Wscrollwin, Wdrawingarea, Wstatus, Wbutton;
	Widget Wlogo1, Wlogo2;
	
	struct NetworkObj * no2;
	
	/*********/
	/* Shell */
	/*********/
	
	n = 0;
	
	if (no->pict && (no->pmres == XpmSuccess)) {
		XtSetArg (args[n], XmNwidth, no->pma.width + 150); n++;
		XtSetArg (args[n], XmNheight, no->pma.height + 250); n++;
	}
	
	else {
		XtSetArg (args[n], XmNwidth, 600); n++;
		XtSetArg (args[n], XmNheight, 800); n++;
	}
	
    XtSetArg (args[n], XmNtitle, no->title); n++;
    XtSetArg (args[n], XmNdeleteResponse, XmDO_NOTHING); n++;
    XtSetValues (Wtoplevel, args, n);
    no->Wshell = Wtoplevel;
    MotifProtectShell (Wtoplevel, (XtCallbackProc)QuitCB, NULL);
    
    /**** Editres ****/
    
    XtAddEventHandler (Wtoplevel, (EventMask)0, True, _XEditResCheckMessages, NULL);

	/******************/
	/* Form "globale" */
	/******************/
	
	n = 0;
	Wmainform = XmCreateForm (Wtoplevel, "mainform", args, n);
	XtManageChild (Wmainform);
	
	/********/	
	/* Menu */
	/********/

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	Wmenubar = XmCreateMenuBar (Wmainform, "menubar", args, n);
	XtManageChild (Wmenubar);

	Wmenupane = MotifCreateMenu (Wmenubar, "File", 'F', 0, 0);
	MotifAddMenuItem (Wmenupane, "Halt...", 'H', (XtCallbackProc)HaltCB, no);
	MotifAddMenuItem (Wmenupane, "Quit...", 'Q', (XtCallbackProc)QuitCB, no);
	
	Wmenupane = MotifCreateMenu (Wmenubar, "Host", 'H', 0, 0);
	MotifAddMenuItem (Wmenupane, "Select all", 'S', (XtCallbackProc)SelectAllCB, no);
	MotifAddMenuItem (Wmenupane, "Deselect all", 'D', (XtCallbackProc)DeselectAllCB, no);
	MotifAddMenuSep (Wmenupane);
	MotifAddMenuItem (Wmenupane, "PVM Add", 'A', (XtCallbackProc)AddCB, no);
	MotifAddMenuItem (Wmenupane, "PVM Remove", 'R', (XtCallbackProc)DelCB, no);
	MotifAddMenuItem (Wmenupane, "PVM Check", 'C', (XtCallbackProc)CheckCB, no);
	MotifAddMenuItem (Wmenupane, "PVM Repair...", 'e', (XtCallbackProc)RepairCB, no);
	MotifAddMenuSep (Wmenupane);
	
	/**** Ping e traceroute sono opzionali... ****/

#ifdef PINGPATH
	MotifAddMenuItem (Wmenupane, "Ping...", 'P', (XtCallbackProc)PingCB, no);
#endif
#ifdef TROUTEPATH
	MotifAddMenuItem (Wmenupane, "Traceroute...", 'T',(XtCallbackProc)TracerouteCB, no);
#endif

	Wmenupane = MotifCreateMenu (Wmenubar, "Apps", 'A', 0, 0);
	MotifAddMenuItem (Wmenupane, "Make...", 'M', (XtCallbackProc)MakeCB, no);
	MotifAddMenuItem (Wmenupane, "Spawn...", 'S', (XtCallbackProc)SpawnCB, no);
	
	Wmenupane = MotifCreateMenu (Wmenubar, "Windows", 'W', 0, 0);
	MotifAddMenuItem (Wmenupane, "Make", 'M', (XtCallbackProc)MakeWinCB, no);
	MotifAddMenuItem (Wmenupane, "Tasks", 'T', (XtCallbackProc)TasksWinCB, no);
	
	Wmenupane = MotifCreateMenu (Wmenubar, "Misc", 'M', 0, 0);
	MotifAddMenuItem (Wmenupane, "Clear messages", 'C', (XtCallbackProc)ClearStatusCB, no);

	Wmenupane = MotifCreateMenu (Wmenubar, "Help", 'H', 1, 0);
	MotifAddMenuItem (Wmenupane, "On Version...", 'V', (XtCallbackProc)HelpVersionCB, no);
	MotifAddMenuItem (Wmenupane, "On Distribution...", 'D', (XtCallbackProc)HelpCopyrightCB, no);

	/****************/
	/* Paned Window */
	/****************/
	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wmenubar); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, LOGOHEIGHT); n++;
	Wpanedwin = XmCreatePanedWindow (Wmainform, "panedwin", args, n);
	XtManageChild (Wpanedwin);
	
	/*******************************/
	/* TopForm (drawingarea+lista) */
	/*******************************/
	
	n = 0;
	
	if (no->pict && (no->pmres == XpmSuccess)) {
		XtSetArg (args[n], XmNheight, no->pma.height); n++;
	}
	else {
		XtSetArg (args[n], XmNheight, 600); n++;
	}
	
	Wtopform = XmCreateForm (Wpanedwin, "topform", args, n);
	XtManageChild (Wtopform);
	
	/*********/
	/* Lista */
	/*********/

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
	XtSetArg (args[n], XmNselectionPolicy, XmEXTENDED_SELECT); n++;
	XtSetArg (args[n], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); n++;
	Wlist = XmCreateScrolledList (Wtopform, "list", args, n);
	XtManageChild (Wlist);
	XtAddCallback (Wlist, XmNdefaultActionCallback, (XtCallbackProc)ListCB, NULL);
	no->Wlist = Wlist;
	
	/**** Riempie la lista ****/
	
	no2 = NetworkObjFirst();
	while (no2) {
		if (no2->type == NET_HOST) MotifAddListItem (Wlist, no2->addr);
		no2 = no2->next;
	}
	
	/****************/
	/* Drawing Area */
	/****************/
	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, Wlist); n++;
	XtSetArg (args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
	XtSetArg (args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
	Wscrollwin = XmCreateScrolledWindow (Wtopform, "mapSW", args, n);
	XtManageChild (Wscrollwin);

	n = 0;
	XtSetArg (args[n], XmNresizePolicy, XmRESIZE_GROW); n++;
	Wdrawingarea = XmCreateDrawingArea (Wscrollwin, "map", args, n);
	XtManageChild (Wdrawingarea);
	
	/**********/
	/* Status */
	/**********/

	n = 0;
	XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg (args[n], XmNeditable, False); n++;
	XtSetArg (args[n], XmNcursorPositionVisible, False); n++;
	Wstatus = XmCreateScrolledText (Wpanedwin, "status", args, n);
	XtManageChild (Wstatus);
	no->Wstatus = Wstatus;
	
	/************************/
	/* Logo1 - Drawing Area */
	/************************/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNresizePolicy, XmRESIZE_GROW); n++;
	Wlogo1 = XmCreateDrawingArea (Wmainform, "logo1", args, n);
	XtManageChild (Wlogo1);

	/************************/
	/* Logo2 - Drawing Area */
	/************************/
	
	n = 0;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNresizePolicy, XmRESIZE_GROW); n++;
	Wlogo2 = XmCreateDrawingArea (Wmainform, "logo2", args, n);
	XtManageChild (Wlogo2);
	
	XtRealizeWidget (Wtoplevel);
	XmUpdateDisplay (Wtoplevel);
	
	/*********/
	/* Mappa */
	/*********/
		
	if (no->pict) {
	
		if (no->pmres == XpmSuccess) {
			n = 0;
			XtSetArg (args[n], XmNwidth, no->pma.width); n++;
			XtSetArg (args[n], XmNheight, no->pma.height); n++;
			XtSetArg (args[n], XmNbackgroundPixmap, no->pm); n++;
			XtSetValues (Wdrawingarea, args, n);
		}

		else switch (no->pmres) {
			
			case XpmColorFailed:
			case XpmColorError:		MotifStatusMsg (Wstatus, "colors not available for %s\n", no->pict);
									break;
			case XpmOpenFailed:		MotifStatusMsg (Wstatus, "file %s doesn't exist or is not readable\n", no->pict);
									break;
			case XpmFileInvalid:	MotifStatusMsg (Wstatus, "%s is not a valid pixmap\n", no->pict);
									break;
			case XpmNoMemory:		MotifStatusMsg (Wstatus, "not enough memory to load %s\n", no->pict);
									break;
			default:				MotifStatusMsg (Wstatus, "can't use pixmap %s (error %d)", no->pict, no->pmres);
		}
	}
	
	/***********/
	/* Bottoni */
	/***********/
	
	for (i=0; i < no->nchildren; i++) {
		
		no2 = no->children[i];
		
		n = 0;
		XtSetArg (args[n], XmNlabelString, XmStringCreate (no2->title, DEFSET)); n++;
		XtSetArg (args[n], XmNx, no2->x); n++;
		XtSetArg (args[n], XmNy, no2->y); n++;
		Wbutton = XmCreatePushButton (Wdrawingarea, "button", args, n);
		XtManageChild (Wbutton);
		no2->Wbutton = Wbutton;
		XtAddCallback (Wbutton, XmNactivateCallback, (XtCallbackProc)ButtonCB, no2);
	}
		
	/*********/
	/* Shape */
	/*********/
	
	hasshape = XShapeQueryExtension (XtDisplay(Wtoplevel), &dummy1, &dummy2);
	
	/*********/
	/* Logo1 */
	/*********/
	
	pma.valuemask = 0;
	res = XpmCreatePixmapFromData (XtDisplay(Wtoplevel), XtWindow(Wlogo1), wamm_xpm, &pm, &mask, &pma);
	if (res == XpmSuccess) {		

		if (hasshape && mask) XShapeCombineMask(XtDisplay(Wtoplevel), XtWindow(Wlogo1), ShapeBounding, 0, 0, mask, ShapeSet);

		n = 0;
		XtSetArg (args[n], XmNwidth, pma.width); n++;
		XtSetArg (args[n], XmNheight, pma.height); n++;
		XtSetArg (args[n], XmNbackgroundPixmap, pm); n++;
		XtSetValues (Wlogo1, args, n);
		XpmFreeAttributes (&pma);
	}
	
	/*********/
	/* Logo2 */
	/*********/
	
	pma.valuemask = 0;
	res = XpmCreatePixmapFromData (XtDisplay(Wtoplevel), XtWindow(Wlogo2), cnuce_xpm, &pm, &mask, &pma);
	if (res == XpmSuccess) {		

		if (hasshape && mask) XShapeCombineMask(XtDisplay(Wtoplevel), XtWindow(Wlogo2), ShapeBounding, 0, 0, mask, ShapeSet);

		n = 0;
		XtSetArg (args[n], XmNwidth, pma.width); n++;
		XtSetArg (args[n], XmNheight, pma.height); n++;
		XtSetArg (args[n], XmNbackgroundPixmap, pm); n++;
		XtSetValues (Wlogo2, args, n);
		XpmFreeAttributes (&pma);
	}
}

/******************************************************************************/
/******************************************************************************/

/***************/
/* SelectAllCB */
/***************/

void SelectAllCB (Widget w, struct NetworkObj * no, int dummy)
{	
	MotifListSelectAll (no->Wlist);	
}

/*****************/
/* DeselectAllCB */
/*****************/

void DeselectAllCB (Widget w, struct NetworkObj * no, int dummy)
{
	XmListDeselectAllItems (no->Wlist);
}

/*****************/
/* ClearStatusCB */
/*****************/

void ClearStatusCB (Widget w, struct NetworkObj * no, int dummy)
{	
	MotifClearText (no->Wstatus);
}

/**********/
/* ListCB */
/**********/

void ListCB (Widget w, int dummy, XmListCallbackStruct * lcs)
{	
	int mem;
	char * addr;
	struct NetworkObj * no;
	
	mem = XmStringGetLtoR (lcs->item, DEFSET, &addr);
	no = NetworkObjFindByAddr (addr);
	if (mem) free (addr);
	
	LANWindow (no->parent);
}

/************/
/* ButtonCB */
/************/

void ButtonCB (Widget w, struct NetworkObj * no, int dummy)
{	
	if (no -> type == NET_MAN) MANWindow (no);
	else LANWindow (no);
}

/*****************************************************************************/
/*****************************************************************************/

/***********/
/* QuitCB */
/***********/

void QuitCB (Widget w, struct NetworkObj * no, int dummy)
{
		
	if (!MotifQuestion (Wtoplevel, "Quitting...", "Are you sure you want to close Wamm ?")) return;
	
	/*************************/
	/* Chiude tutti i moduli */
	/*************************/
	
	PVMEnd (PVM_ENDSOFT);
	InternetEnd ();
	WANEnd ();
	MANEnd ();
	LANEnd ();
	TasksEnd ();
	SpawnEnd ();
	MakeEnd ();
	NetworkObjEnd ();

	exit (0);
}

/***********/
/* HaltCB */
/***********/

void HaltCB (Widget w, struct NetworkObj * no, int dummy)
{		
	if (!MotifQuestion (Wtoplevel, "Halt", "Are you sure you want to halt PVM ?\n"
	                    "This will DESTROY your metacomputer, including WAMM!")) return;
	
	/*************************/
	/* Chiude tutti i moduli */
	/*************************/
	
	PVMEnd (PVM_ENDHARD);
	InternetEnd ();
	WANEnd ();
	MANEnd ();
	LANEnd ();
	TasksEnd ();
	SpawnEnd ();
	MakeEnd ();
	NetworkObjEnd ();

	exit (0);
}


/***********/
/* CheckCB */
/***********/

void CheckCB (Widget w, struct NetworkObj * no, int dummy)
{	
	int num, n;
	unsigned char ** hosts;
	Boolean * mem;
	
	/********************************/
	/* Preleva gli host dalla lista */
	/********************************/
	
	num = MotifListGetSelected (no->Wlist, &hosts, &mem);
	if (!num) {
		MotifStatusMsg (no->Wstatus, "No host selected!\n");
		return;
	}
	
	/*********/
	/* Check */
	/*********/
		
	PVMCheck (no, num, hosts, mem);
		
	/**********************************************/
	/* deseleziona gli host e rilascia la memoria */
	/**********************************************/
	
	XmListDeselectAllItems (no->Wlist);
	
	for (n=0; n<num; n++) if (mem[n]) free (hosts[n]);
	free (mem);
	free (hosts);						
}

/*********/
/* AddCB */
/*********/

void AddCB (Widget w, struct NetworkObj * no, int dummy)
{	
	int num, n;
	unsigned char ** hosts;
	Boolean * mem;
	
	/********************************/
	/* Preleva gli host dalla lista */
	/********************************/
	
	num = MotifListGetSelected (no->Wlist, &hosts, &mem);
	if (!num) {
		MotifStatusMsg (no->Wstatus, "No host selected!\n");
		return;
	}
	
	/*******/
	/* Add */
	/*******/
	
	MotifStatusMsg (no->Wstatus, "Running AddHosts. Hosts will be added in a few seconds.\n");
	PVMAdd (no, num, hosts, mem);
	
	/**********************************************/
	/* deseleziona gli host e rilascia la memoria */
	/**********************************************/
	
	XmListDeselectAllItems (no->Wlist);
	
	for (n=0; n<num; n++) if (mem[n]) free (hosts[n]);
	free (mem);
	free (hosts);					
}

/*********/
/* DelCB */
/*********/

void DelCB (Widget w, struct NetworkObj * no, int dummy)
{	
	int num, n;
	unsigned char ** hosts;
	Boolean * mem;
		
	/********************************/
	/* Preleva gli host dalla lista */
	/********************************/
	
	num = MotifListGetSelected (no->Wlist, &hosts, &mem);
	if (!num) {
		MotifStatusMsg (no->Wstatus, "No host selected!\n");
		return;
	}
	
	/*******/
	/* Del */
	/*******/
		
	MotifStatusMsg (no->Wstatus, "Running DelHosts. Hosts will be deleted in a few seconds.\n");
	PVMDel (no, num, hosts, mem);
		
	/**********************************************/
	/* deseleziona gli host e rilascia la memoria */
	/**********************************************/
	
	XmListDeselectAllItems (no->Wlist);
	
	for (n=0; n<num; n++) if (mem[n]) free (hosts[n]);
	free (mem);
	free (hosts);					
}

/**********/
/* MakeCB */
/**********/

void MakeCB (Widget w, struct NetworkObj * no, int dummy1)
{
	int num, n;
	unsigned char ** hosts;
	Boolean * mem;
		
	/********************************/
	/* Preleva gli host dalla lista */
	/********************************/
	
	num = MotifListGetSelected (no->Wlist, &hosts, &mem);
	if (!num) {
		MotifStatusMsg (no->Wstatus, "No host selected!\n");
		return;
	}

	/********/
	/* Make */
	/********/

	MakeAdd (no->Wshell, num, hosts);
	
	/**********************************************/
	/* deseleziona gli host e rilascia la memoria */
	/**********************************************/
	
	XmListDeselectAllItems (no->Wlist);
	
	for (n=0; n<num; n++) if (mem[n]) free (hosts[n]);
	free (mem);
	free (hosts);					
}

/************/
/* RepairCB */
/************/

void RepairCB (Widget w, struct NetworkObj * no, int dummy1)
{
	int num, n;
	unsigned char ** hosts;
	Boolean * mem;
		
	/********************************/
	/* Preleva gli host dalla lista */
	/********************************/
	
	num = MotifListGetSelected (no->Wlist, &hosts, &mem);
	if (!num) {
		MotifStatusMsg (no->Wstatus, "No host selected!\n");
		return;
	}

	/**********/
	/* Repair */
	/**********/
	
	if (MotifQuestion(no->Wshell, "Repair", "Are you sure you want to repair selected hosts?\n" "If PVM daemons are still working on those hosts,\n" "this operation will destroy them."))
		PVMRepair (no, num, hosts, mem);
	
	/**********************************************/
	/* deseleziona gli host e rilascia la memoria */
	/**********************************************/
	
	XmListDeselectAllItems (no->Wlist);
	
	for (n=0; n<num; n++) if (mem[n]) free (hosts[n]);
	free (mem);
	free (hosts);					
}

/**********/
/* PingCB */
/**********/

void PingCB (Widget w, struct NetworkObj * no, int dummy1)
{
	int num, n;
	unsigned char ** hosts;
	Boolean * mem;
		
	/********************************/
	/* Preleva gli host dalla lista */
	/********************************/
	
	num = MotifListGetSelected (no->Wlist, &hosts, &mem);
	if (!num) {
		MotifStatusMsg (no->Wstatus, "No host selected!\n");
		return;
	}

	/********/
	/* Ping */
	/********/
	
	for (n=0; n<num; n++) InternetPing (no, hosts[n]);
	
	/**********************************************/
	/* deseleziona gli host e rilascia la memoria */
	/**********************************************/
	
	XmListDeselectAllItems (no->Wlist);
	
	for (n=0; n<num; n++) if (mem[n]) free (hosts[n]);
	free (mem);
	free (hosts);					
}

/****************/
/* TracerouteCB */
/****************/

void TracerouteCB (Widget w, struct NetworkObj * no, int dummy1)
{
	int num, n;
	unsigned char ** hosts;
	Boolean * mem;
		
	/********************************/
	/* Preleva gli host dalla lista */
	/********************************/
	
	num = MotifListGetSelected (no->Wlist, &hosts, &mem);
	if (!num) {
		MotifStatusMsg (no->Wstatus, "No host selected!\n");
		return;
	}

	/**************/
	/* Traceroute */
	/**************/
	
	for (n=0; n<num; n++) InternetTraceroute (no, hosts[n]);
	
	/**********************************************/
	/* deseleziona gli host e rilascia la memoria */
	/**********************************************/
	
	XmListDeselectAllItems (no->Wlist);
	
	for (n=0; n<num; n++) if (mem[n]) free (hosts[n]);
	free (mem);
	free (hosts);					
}

/***********/
/* SpawnCB */
/***********/

void SpawnCB (Widget w, struct NetworkObj * no, int dummy)
{
	SpawnWindow (no);
}

/**************/
/* TasksWinCB */
/**************/

void TasksWinCB (Widget w, struct NetworkObj * no, int dummy)
{
	TasksWindow();
}

/*************/
/* MakeWinCB */
/*************/

void MakeWinCB (Widget w, struct NetworkObj * no, int dummy)
{
	MakeWindow();
}

/*****************/
/* HelpVersionCB */
/*****************/

void HelpVersionCB (Widget w, struct NetworkObj * no, int dummy)
{
	Widget W;

	W = MotifHelp (no->Wshell, "HELP - Version",
	
	"WAMM - Wide Area Metacomputer Manager\n"
	"Version 1.0 - 17-Jun-1995\n\n"
	
	"WAMM was written by R. Baraglia, G. Faieta, M. Formica and D. Laforenza\n"
	"at CNUCE, an Institute of the Italian National Research Council (CNR).\n\n"
	
	"Send bugs and suggestions to: meta@calpar.cnuce.cnr.it\n\n"

	"or:\n\n"

	"Gianluca Faieta & Marcello Formica\n"
	"c/o CNUCE-CNR, dott. D. Laforenza\n"
	"Via S. Maria, 36\n"
	"I-56100 Pisa, Italy\n"
	
	);
}

/*******************/
/* HelpCopyrightCB */
/*******************/

void HelpCopyrightCB (Widget w, struct NetworkObj * no, int dummy)
{
	Widget W;

	W = MotifHelp (no->Wshell, "HELP - Copyright",

	"WAMM - Wide Area Metacomputer Manager\n"
	"Version 1.0 - 17-Jun-1995\n\n"

	"CNUCE - Institute of the Italian National Research Council\n"
	"Authors:  R. Baraglia, G. Faieta, M. Formica, D. Laforenza\n"
	"(C) 1995 All Rights Reserved\n\n"

	"NOTICE\n\n"


	"Permission is hereby granted, without written agreement and without license\n"
	"or royalty fees, to use, copy, modify, and distribute this software and\n"
	"its documentation for educational and research purpose only, provided that\n"
	"the above copyright notice and the following two paragraphs appear in all\n"
	"copies of this software and in the supporting documentation. No charge,\n"
	"other than an ""at-cost"" distribution fee, may be charged for copies,\n"
	"derivations, or distributions of this material without the express written\n"
	"consent of the copyright holder.\n\n"

	"IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO\n"
	"ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL\n"
	"DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN\n"
	"IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF \n"
	"SUCH DAMAGE.\n\n"

	"THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY \n"
	"WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
	"FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS\n"
	"ON AN ""AS IS"" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO\n"
	"PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.\n"
	);
}
