/*****************************************************************************\
*                                                                             *
*  modSpawn.c - Gestione tasks			                                      *
*  1.0 - 13/3/95                                                              *
*                                                                             *
\*****************************************************************************/

/*
 *
 *          WAMM version 1.0: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, G. Faieta, M. Formica, D. Laforenza
 *                   (C) 1995 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

#include "modSpawn.h"

/*********************/
/* Strutture private */
/*********************/

struct TraceName {
	unsigned char * name;
	int mask;
};

#define NEW_GROUP	-1		/* marker nuovo gruppo (name = il nome) */
#define END_GROUP	-2		/* marker fine gruppo (name = NULL) */
#define END_ALL		-3		/* marker fine elenco (name = NULL) */

/*******************/
/* Globali private */
/*******************/

static int btn;
Pvmtmask mask;

static struct TraceName events[] = {

	"Virtual Machine", NEW_GROUP,
	
	"ADDHOST", TEV_ADDHOSTS0,
	"DELHOST", TEV_DELHOSTS1,
	"CONFIG", TEV_CONFIG1,
	"MSTAT", TEV_MSTAT1,
	"ARCCODE", TEV_ARCHCODE1,
	"HOSTSYNC", TEV_HOSTSYNC1,
	"START PVMD", TEV_START_PVMD1,
	"HALT", TEV_HALT1,
	NULL, END_GROUP,

	"Tasks", NEW_GROUP,

	"MYTID", TEV_MYTID1,
	"PARENT", TEV_PARENT1,
	"SPAWN", TEV_SPAWN1,
	"SENDSIG", TEV_SENDSIG1,
	"KILL", TEV_KILL1,
	"EXIT", TEV_EXIT1,
	"PSTAT", TEV_PSTAT1,
	"TASKS", TEV_TASKS1,
	"TIDTOHOST", TEV_TIDTOHOST1,
	NULL, END_GROUP,

	"Send/Receive", NEW_GROUP,

	"MCAST", TEV_MCAST1,
	"SEND", TEV_SEND1,
	"RECV", TEV_RECV1,
	"NRECV", TEV_NRECV1,
	"RECVF", TEV_RECVF1,
	"PSEND", TEV_PSEND1,
	"PRECV", TEV_PRECV1,
	"TRECV", TEV_TRECV1,
	"PROBE", TEV_PROBE1,
	NULL, END_GROUP,

	"Buffers", NEW_GROUP,

	"INITSEND", TEV_INITSEND1,
	"MKBUF", TEV_MKBUF1,
	"BUFINFO", TEV_BUFINFO1,
	"FREEBUF", TEV_FREEBUF1,
	"GETRBUF", TEV_GETRBUF1,
	"SETRBUF", TEV_SETRBUF1,
	"GETSBUF", TEV_GETSBUF1,
	"SETSBUF", TEV_SETSBUF1,
	"GETMWID", TEV_GETMWID1,
	"SETMWID", TEV_SETMWID1,
	NULL, END_GROUP,
	
	"Pack", NEW_GROUP,
	
	"PKBYTE", TEV_PKBYTE1,
	"PKCPLX", TEV_PKCPLX1,
	"PKDCPLX", TEV_PKDCPLX1,
	"PKDOUBLE", TEV_PKDOUBLE1,
	"PKFLOAT", TEV_PKFLOAT1,
	"PKINT", TEV_PKINT1,
	"PKUINT", TEV_PKUINT1,
	"PKLONG", TEV_PKLONG1,
	"PKULONG", TEV_PKULONG1,
	"PKSHORT", TEV_PKSHORT1,
	"PKUSHORT", TEV_PKUSHORT1,
	"PKSTR", TEV_PKSTR1,
	"PACKF", TEV_PACKF1,
	NULL, END_GROUP,

	"Unpack", NEW_GROUP,

	"UPKBYTE", TEV_UPKBYTE1,
	"UPKCPLX", TEV_UPKCPLX1,
	"UPKDCPLX", TEV_UPKDCPLX1,
	"UPKDOUBLE", TEV_UPKDOUBLE1,
	"UPKFLOAT", TEV_UPKFLOAT1,
	"UPKINT", TEV_UPKINT1,
	"UPKUINT", TEV_UPKUINT1,
	"UPKLONG", TEV_UPKLONG1,
	"UPKULONG", TEV_UPKULONG1,
	"UPKSHORT", TEV_UPKSHORT1,
	"UPKUSHORT", TEV_UPKUSHORT1,
	"UPKSTR", TEV_UPKSTR1,
	"UNPACKF", TEV_UNPACKF1,
	NULL, END_GROUP,

	"Groups", NEW_GROUP,

	"BARRIER", TEV_BARRIER1,
	"BCAST", TEV_BCAST1,
	"DELETE", TEV_DELETE1,
	"GETINST", TEV_GETINST1,
	"GETTID", TEV_GETTID1,
	"GSIZE", TEV_GSIZE1,
	"INSERT", TEV_INSERT1,
	"JOINGROUP", TEV_JOINGROUP1,
	"LOOKUP", TEV_LOOKUP1,
	"LVGROUP", TEV_LVGROUP1,
	NULL, END_GROUP,
	
	"Collect", NEW_GROUP,

	"GATHER", TEV_GATHER1,
	"SCATTER", TEV_SCATTER1,
	"REDUCE", TEV_REDUCE1,
	NULL, END_GROUP,

	"Misc", NEW_GROUP,
	
	"GETOPT", TEV_GETOPT1,
	"SETOPT", TEV_SETOPT1,
	"GETFDS", TEV_GETFDS1,
	"REG HOSTER", TEV_REG_HOSTER1,
	"REGRM", TEV_REG_RM1,
	"REGTASKER", TEV_REG_TASKER1,
	"CATCHOUT", TEV_CATCHOUT1,
	"NOTIFY", TEV_NOTIFY1,
	"GETTMASK", TEV_GETTMASK1,
	"SETTMASK", TEV_SETTMASK1,
	"PERROR", TEV_PERROR1,
	"TICKLE", TEV_TICKLE1,
	"VERSION", TEV_VERSION1,
	NULL, END_GROUP,
	
	NULL, END_ALL
};	

/********************/
/* Funzioni private */
/********************/

static Boolean	SpawnDialog (Widget, unsigned char **, unsigned char ***, int *, unsigned char **, int *, int *);

/*********************/
/* Callbacks private */
/*********************/

static void ButtonsCB (Widget W, int, int);
static void GroupCB (Widget W, int, int);

/***************************************/
/* SpawnInit - inizializzazione modulo */
/***************************************/

void SpawnInit (void)
{
	
	/* XXX per ora nulla */
}

/*********************************/
/* SpawnEnd - distruzione modulo */
/*********************************/

void SpawnEnd (void)
{
	/* XXX per ora nulla */
}

/*******************************/
/* SpawnWindow - finestra task */
/*******************************/

void SpawnWindow (struct NetworkObj * no)
{
	Widget Wwait;

	int res, n;
	unsigned char * tmp;

	unsigned char * task;		/* nome task */
	unsigned char ** argv;		/* argomenti */
	int flag;					/* flag PVM */
	unsigned char * where;		/* host o architettura */
	int ntask;					/* numero copie */
	int output;					/* 1 = cattura l'output */

	int * tids;					/* tid tasks */
	int dtid;					/* dtid host su cui si trova un task */
	struct NetworkObj * taskno;	/* nodo su cui si trova un task */
	
	/*************/
	/* Parametri */
	/*************/
	
	/**** defaults ****/
	
	output = 1;
	pvm_gettmask (PvmTaskChild, mask);
	
	if (no -> type == NET_HOST) {
		where = no->addr;
		flag = PvmTaskHost;
	}
	
	else {
		flag = PvmTaskDefault;
		where = NULL;
	}
	
	res = SpawnDialog (no->Wshell, &task, &argv, &flag, &where, &ntask, &output);	
	if (!res) return;
	
	/*********/
	/* spawn */
	/*********/
	
	Wwait = MotifWait (no->Wshell, "Spawn", "Spawning tasks, please wait...");
		
	/**** spawn ****/
		
	tids = calloc (ntask, sizeof(int));
	
	if (output) {
		pvm_setopt (PvmOutputTid, PVMTid());
		pvm_setopt (PvmOutputCode, T_TASK_OUT);
	}
	
	if (flag & PvmTaskTrace) {
		pvm_setopt (PvmTraceTid, PVMTid());
		pvm_setopt (PvmTraceCode, T_TASK_TRACE);
		pvm_settmask( PvmTaskChild, mask );
	}
		
	pvm_spawn (task, (char **)argv, flag, where, ntask, tids);
	pvm_setopt (PvmOutputTid, 0);
	pvm_setopt (PvmTraceTid, 0);

	XtUnmanageChild (Wwait);
	XtDestroyWidget (Wwait);
	
	/**********************/
	/* mostra i risultati */
	/**********************/
	
	for (n = 0; n<ntask; n++) {
	
		if (tids[n]>0) {
		
			dtid = pvm_tidtohost (tids[n]);
			taskno = NetworkObjFindByDtid (dtid);
			MotifStatusMsg (no->Wstatus, "%s: Tid %x on %s\n", task, tids[n], (taskno ? taskno->addr : (unsigned char *)"--------"));
		}
		
		else {	
			tmp = PVMError (tids[n]);
			MotifStatusMsg (no->Wstatus, "%s: FAILED! (%s)\n", task, tmp);
			free (tmp);
		}
	}
	
	/**** rilascia le stringhe ****/
		
	if (argv) while (*argv) {
		free (*argv);
		argv++;
	}
	free (task);
	free (where);	
}

/****************************************/
/* SpawnDialog - dialog argomenti spawn */
/****************************************/

Boolean SpawnDialog (Widget Wshell, unsigned char ** task, unsigned char ** argv[], int * flag, unsigned char ** where, int * ntask, int * output)
{
	Arg args[20];
	int n, i, j;
	
	Widget Wdialog;
	Widget Wtasklabel, Wtasktext;
	Widget Warglabel, Wargtext;
	Widget Wntasklabel, Wntasktext;
	Widget Wsep;
	Widget Wwhere, Wmenupane, Wnoteq, Whosttext;
	Widget Woutput, Wdebug, WMPP, Wtrace, Wevents;
	Widget Wrcflags, Wrcgroups1, Wrcgroups2, Wall, Wnone;
	Widget * Wgroups;
	Widget Wok, Wcancel;
	
	int numgroups;
	unsigned char * copies;
	unsigned char * arg;
	unsigned char * ptr;
	int argc;
	
	/***********************/
	/* Widget per i gruppi */
	/***********************/
	
	i = 0;
	numgroups = 0;
	while (events[i].mask != END_ALL) {
		if (events[i].mask == NEW_GROUP) numgroups++;
		i++;
	}
	Wgroups = calloc (numgroups, sizeof(Widget));
	
	/**********/
	/* Dialog */
	/**********/
	
	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate("Spawn", DEFSET)); n++;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
	XtSetArg (args[n], XmNwidth, 570); n++;
	XtSetArg (args[n], XmNheight, 480); n++;
	XtSetArg (args[n], XmNresizePolicy, XmRESIZE_GROW); n++;
	XtSetArg (args[n], XmNautoUnmanage, False); n++;
	Wdialog = XmCreateFormDialog (Wshell, "spawndialog", args, n);
	XtManageChild (Wdialog);

	/********/
	/* Task */
	/********/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("Name:", DEFSET)); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	Wtasklabel = XmCreateLabel (Wdialog, "tasklabel", args, n);
	XtManageChild (Wtasklabel);
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	Wtasktext = XmCreateText (Wdialog, "tasktext", args, n);
	XtManageChild (Wtasktext);

	/***********************/
	/* Argomenti programma */
	/***********************/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("Arguments:", DEFSET)); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	Warglabel = XmCreateLabel (Wdialog, "arglabel", args, n);
	XtManageChild (Warglabel);
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	Wargtext = XmCreateText (Wdialog, "argtext", args, n);
	XtManageChild (Wargtext);

	/*********/
	/* Copie */
	/*********/

	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("Copies:", DEFSET)); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Warglabel); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	Wntasklabel = XmCreateLabel (Wdialog, "ntasklabel", args, n);
	XtManageChild (Wntasklabel);
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wtasklabel); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Warglabel); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNcolumns, 3); n++;
	Wntasktext = XmCreateText (Wdialog, "ntasktext", args, n);
	XtManageChild (Wntasktext);

	/**** separatore ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wntasklabel); n++;
	XtSetArg (args[n], XmNtopOffset, 30); n++;
	Wsep = XmCreateSeparator (Wdialog, "sep", args, n);
	XtManageChild (Wsep);

	/********/
	/* Dove */
	/********/
	
	n = 0;
	Wmenupane = XmCreatePulldownMenu (Wdialog, "menu", args, n);
	
	if ((*flag & 3) == PvmTaskDefault) {
		MotifAddMenuItem (Wmenupane, "Auto", 0, (XtCallbackProc)ButtonsCB, (void *)1);
		MotifAddMenuItem (Wmenupane, "Arch", 0, (XtCallbackProc)ButtonsCB, (void *)2);
		MotifAddMenuItem (Wmenupane, "Host", 0, (XtCallbackProc)ButtonsCB, (void *)3);
	}
	
	else if ((*flag & 3) == PvmTaskArch) {
		MotifAddMenuItem (Wmenupane, "Arch", 0, (XtCallbackProc)ButtonsCB, (void *)2);
		MotifAddMenuItem (Wmenupane, "Host", 0, (XtCallbackProc)ButtonsCB, (void *)3);
		MotifAddMenuItem (Wmenupane, "Auto", 0, (XtCallbackProc)ButtonsCB, (void *)1);
	}
	
	else {
		MotifAddMenuItem (Wmenupane, "Host", 0, (XtCallbackProc)ButtonsCB, (void *)3);
		MotifAddMenuItem (Wmenupane, "Arch", 0, (XtCallbackProc)ButtonsCB, (void *)2);
		MotifAddMenuItem (Wmenupane, "Auto", 0, (XtCallbackProc)ButtonsCB, (void *)1);
	}
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Where:", DEFSET)); n++;
	XtSetArg (args[n], XmNsubMenuId, Wmenupane); n++;
	Wwhere = XmCreateOptionMenu (Wdialog, "where", args, n);
	XtManageChild (Wwhere);

	/**** != ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wwhere); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNset, *flag & PvmHostCompl); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("!=", DEFSET)); n++;
	Wnoteq = XmCreateToggleButton (Wdialog, "noteq", args, n);
	XtManageChild (Wnoteq);
	XtAddCallback (Wnoteq, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)4);
	
	/**** host/architettura ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftWidget, Wnoteq); n++;
	XtSetArg (args[n], XmNleftOffset, 20); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	if (*where) { XtSetArg (args[n], XmNvalue, *where); n++; }
	Whosttext = XmCreateText (Wdialog, "hosttext", args, n);
	XtManageChild (Whosttext);
	
	if ((*flag & 3) == PvmTaskDefault) XtSetSensitive (Whosttext, False);

	/**** separatore ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Whosttext); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	Wsep = XmCreateSeparator (Wdialog, "sep", args, n);
	XtManageChild (Wsep);

	/*********/
	/* Flags */
	/*********/

	/**** RowColumn ****/
	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++;
	XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg (args[n], XmNnumColumns, 1); n++;
	XtSetArg (args[n], XmNspacing, 5); n++;
	XtSetArg (args[n], XmNadjustLast, False); n++;
	Wrcflags = XmCreateRowColumn (Wdialog, "rowcol", args, n); n++;
	XtManageChild (Wrcflags);

	/**** output ****/
	
	n = 0;
	XtSetArg (args[n], XmNset, *output); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Output", DEFSET)); n++;
	Woutput = XmCreateToggleButton (Wrcflags, "output", args, n);
	XtManageChild (Woutput);
	XtAddCallback (Woutput, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)5);

	/**** debug ****/
	
	n = 0;
	XtSetArg (args[n], XmNset, *flag & PvmTaskDebug); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Debug", DEFSET)); n++;
	Wdebug = XmCreateToggleButton (Wrcflags, "debug", args, n);
	XtManageChild (Wdebug);
	XtAddCallback (Wdebug, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)6);

	/**** MPP ****/
	
	n = 0;
	XtSetArg (args[n], XmNset, *flag & PvmMppFront); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("MPP", DEFSET)); n++;
	WMPP = XmCreateToggleButton (Wrcflags, "MPP", args, n);
	XtManageChild (WMPP);
	XtAddCallback (WMPP, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)7);

	/**** Trace ****/
	
	n = 0;
	XtSetArg (args[n], XmNset, *flag & PvmTaskTrace); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Trace", DEFSET)); n++;
	Wtrace = XmCreateToggleButton (Wrcflags, "trace", args, n);
	XtManageChild (Wtrace);
	XtAddCallback (Wtrace, XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)8);
	
	/**********/
	/* Eventi */
	/**********/
	
	/* RowColumn per label e bottoni "Tutti" / "Nessuno" */
	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wsep); n++;
	XtSetArg (args[n], XmNtopOffset, 20); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftOffset, 50); n++;
	XtSetArg (args[n], XmNleftWidget, Wrcflags); n++;
	XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++;
	XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg (args[n], XmNnumColumns, 1); n++;
	XtSetArg (args[n], XmNspacing, 15); n++;
	XtSetArg (args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
	Wrcgroups1 = XmCreateRowColumn (Wdialog, "rowcol", args, n); n++;
	XtManageChild (Wrcgroups1);

	/**** "Eventi" (label) ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate ("Trace events", DEFSET)); n++;
	Wevents = XmCreateLabel (Wrcgroups1, "events", args, n); n++;
	XtManageChild (Wevents);
	
	/**** "Tutti" (bottone) ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("All", DEFSET)); n++;
	Wall = XmCreatePushButton (Wrcgroups1, "all", args, n);
	XtManageChild (Wall);
	XtAddCallback (Wall, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)9);
	if (! (*flag & PvmTaskTrace)) XtSetSensitive (Wall, False);

	/**** "Nessuno" (bottone) *****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("None", DEFSET)); n++;
	Wnone = XmCreatePushButton (Wrcgroups1, "none", args, n);
	XtManageChild (Wnone);
	XtAddCallback (Wnone, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)10);
	if (! (*flag & PvmTaskTrace)) XtSetSensitive (Wnone, False);

	/**** RowColumn per gli eventi ****/
	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, Wrcgroups1); n++;
	XtSetArg (args[n], XmNtopOffset, 10); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNleftOffset, 30); n++;
	XtSetArg (args[n], XmNleftWidget, Wrcflags); n++;
	XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++;
	XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg (args[n], XmNnumColumns, 3); n++;
	XtSetArg (args[n], XmNspacing, 5); n++;
	XtSetArg (args[n], XmNadjustLast, False); n++;
	Wrcgroups2 = XmCreateRowColumn (Wdialog, "rowcol", args, n); n++;
	XtManageChild (Wrcgroups2);

	/**** bottoni eventi ****/
	
	i = 0;	/* indice evento */
	j = 0;	/* indice widget */
	
	while (events[i].mask != END_ALL) {
		if (events[i].mask == NEW_GROUP) {
			n = 0;
			XtSetArg (args[n], XmNlabelString, XmStringCreate(events[i].name, DEFSET)); n++;
			Wgroups[j] = XmCreatePushButton (Wrcgroups2, "button", args, n);
			XtManageChild (Wgroups[j]);
			XtAddCallback (Wgroups[j], XmNactivateCallback, (XtCallbackProc)GroupCB, (void *)i);
			if (! (*flag & PvmTaskTrace)) XtSetSensitive (Wgroups[j], False);
			j++;
		}
		i++;
	}

	/**** separatore ****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftOffset, 10); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightOffset, 10); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 70); n++;
	Wsep = XmCreateSeparator (Wdialog, "sep", args, n);
	XtManageChild (Wsep);

	/**** OK *****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 25); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Spawn!", DEFSET)); n++;
	Wok = XmCreatePushButton (Wdialog, "ok", args, n);
	XtManageChild (Wok);
	XtAddCallback (Wok, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)1000);

	/**** Cancel *****/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 55); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomOffset, 20); n++;
	XtSetArg (args[n], XmNwidth, 100); n++;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("Cancel", DEFSET)); n++;
	Wcancel = XmCreatePushButton (Wdialog, "cancel", args, n);
	XtManageChild (Wcancel);
	XtAddCallback (Wcancel, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)999);

	/**** Situazione iniziale ****/

	btn = -1;
	
	/**** Chiusura = Cancel ****/
	
	MotifProtectShell (XtParent(Wdialog), (XtCallbackProc)ButtonsCB, (void *)999);

	/**** Main Loop ****/
	
	for (;;) {
		XtAppProcessEvent (XtWidgetToApplicationContext(Wdialog), XtIMAll);
		switch (btn) {
		
			case -1:	/* nessun bottone */
						break;
			
			case 1:		/* automatico */
						*flag &= ~3;
						*flag |= PvmTaskDefault;
						XtSetSensitive (Whosttext, False);
						break;
						
			case 2:		/* architettura */
						*flag &= ~3;
						*flag |= PvmTaskArch;
						XtSetSensitive (Whosttext, True);
						break;
						
			case 3:		/* host */
						*flag &= ~3;
						*flag |= PvmTaskHost;						
						XtSetSensitive (Whosttext, True);
						break;
						
			case 4:		/* != */
						*flag ^= PvmHostCompl;
						break;
			
			case 5:		/* output */
						*output ^= 1;
						break;
			
			case 6:		/* debug */
						*flag ^= PvmTaskDebug;
						break;
						
			case 7:		/* MPP */
						*flag ^= PvmMppFront;
						break;
						
			case 8:		/* trace */
						*flag ^= PvmTaskTrace;
						for (n=0; n<numgroups; n++)
							XtSetSensitive (Wgroups[n], *flag & PvmTaskTrace);
						XtSetSensitive (Wall, *flag & PvmTaskTrace);
						XtSetSensitive (Wnone, *flag & PvmTaskTrace);
						break;
			
			case 9:		/* tutti */
						n = 0;
						while (events[n].mask != END_ALL) {
							if (events[n].mask >=0) TEV_SET_MASK (mask, events[n].mask);
							n++;
						}
						break;
						
			case 10:	/* nessuno */
						n = 0;
						while (events[n].mask != END_ALL) {
							if (events[n].mask >=0) TEV_UNSET_MASK (mask, events[n].mask);
							n++;
						}
						
						/* disattiva il trace */
						
						*flag &= ~PvmTaskTrace;
						for (n=0; n<numgroups; n++)
							XtSetSensitive (Wgroups[n], False);
						XtSetSensitive (Wall, False);
						XtSetSensitive (Wnone, False);
						
						n = 0;
						XtSetArg (args[n], XmNset, 0); n++;
						XtSetValues (Wtrace, args, n);

						break;
			
			case 1000:	/* lancia! */
						
						/**** nome del task ****/
						
						*task = XmTextGetString (Wtasktext);
						if (!*task[0]) {
							XBell (XtDisplay(Wdialog), 0);
							XmTextSetString (Wtasktext, "??? Missing name!");
							free (*task);
							break;
						}
						
						/**** numero di copie ****/
						
						copies = XmTextGetString (Wntasktext);
						if (!*copies) {
							XBell (XtDisplay(Wdialog), 0);
							XmTextSetString (Wntasktext, "???");
							free (copies);
							free (*task);
							break;
						}

						n = 0;
						while (n<strlen(copies) && isdigit(copies[n])) n++;
						if (n<strlen(copies)) {
							XBell (XtDisplay(Wdialog), 0);
							XmTextSetString (Wntasktext, "???");
							free (copies);
							free (*task);
							break;
						}
						*ntask = atoi (copies);
						if (!*ntask) {
							XBell (XtDisplay(Wdialog), 0);
							XmTextSetString (Wntasktext, "???");
							free (copies);
							free (*task);
							break;
						}
						free (copies);
						
						/**** host/architettura ****/
						
						*where = XmTextGetString (Whosttext);
						if (!*where[0] && ((*flag) & 3)) {
							XBell (XtDisplay(Wdialog), 0);
							if (*flag & PvmTaskHost) XmTextSetString (Whosttext, "??? Missing host!");
							else XmTextSetString (Whosttext, "??? Missing architecture!");
							free (*task);
							free (*where);
							break;
						}
						
						/**** argomenti ****/
						
						arg = XmTextGetString (Wargtext);
						
						argc = 0;
						*argv = NULL;
						ptr = strtok(arg, " \t");
						
						while (ptr) {
							argc++;
							*argv = realloc (*argv, argc * sizeof (unsigned char *));
							(*argv)[argc-1] = strdup (ptr); 
							ptr = strtok (NULL, " \t");
						}
						
						/**** l'ultimo e` un NULL ****/
						
						if (argc) {
							*argv = realloc (*argv, (argc + 1) * sizeof (unsigned char *));
							(*argv)[argc] = NULL;
						}
						
						free (arg);
						
						/**** chiude tutto ****/
						
						XtUnmapWidget (XtParent(Wdialog));
						XtDestroyWidget (XtParent(Wdialog));
						free (Wgroups);
						return True;
						break;
						
			case 999:	/* cancella */
						XtUnmapWidget (XtParent(Wdialog));
						XtDestroyWidget (XtParent(Wdialog));
						free (Wgroups);
						return False;
		}
		btn = -1;
	}						
}

/*************************************************/
/* ButtonsCB - callback per il "feel" dei dialog */
/*************************************************/

void ButtonsCB (Widget W, int val, int dummy)
{
	btn = val;
}

/***************************/
/* GroupCB - gruppo eventi */
/***************************/

void GroupCB (Widget W, int first, int dummy)
{
	Arg args[20];
	int n, i;
	int numevents;
	
	Widget Wshell, Wdialog, Wrc, Wrcbottom, Wok, Wall, Wnone;
	Widget * Wevents;

	/******************/
	/* Cerca la shell */
	/******************/
	
	Wshell = W;
	while (!XtIsShell(Wshell)) Wshell = XtParent(Wshell);

	/**********/
	/* Dialog */
	/**********/
	
	n = 0;
	XtSetArg (args[n], XmNdialogTitle, XmStringCreate(events[first].name, DEFSET)); n++;
	XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
	XtSetArg (args[n], XmNwidth, 300); n++;
	XtSetArg (args[n], XmNheight, 280); n++;
	XtSetArg (args[n], XmNresizePolicy, XmRESIZE_GROW); n++;
	XtSetArg (args[n], XmNautoUnmanage, False); n++;
	Wdialog = XmCreateFormDialog (Wshell, "eventdialog", args, n);
	XtManageChild (Wdialog);

	/********************/
	/* Conta gli eventi */
	/********************/
	
	numevents = 0;
	first++;			/* salta NET_GROUP */
	
	n = first;
	while (events[n].mask != END_GROUP) {
		numevents++;
		n++;
	}

	Wevents = calloc (numevents, sizeof (Widget));
	
	/********************/
	/* Tutti/Nessuno/Ok */
	/********************/
	
	n = 0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++;
	XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg (args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
	Wrcbottom = XmCreateRowColumn (Wdialog, "rowcol", args, n);
	XtManageChild (Wrcbottom);

	/**** Tutti ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("All", DEFSET)); n++;
	Wall = XmCreatePushButton (Wrcbottom, "all", args, n);
	XtManageChild (Wall);
	XtAddCallback (Wall, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)1001);

	/**** Nessuno ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("None", DEFSET)); n++;
	Wnone = XmCreatePushButton (Wrcbottom, "none", args, n);
	XtManageChild (Wnone);
	XtAddCallback (Wnone, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)1002);

	/**** Ok ****/
	
	n = 0;
	XtSetArg (args[n], XmNlabelString, XmStringCreate("OK", DEFSET)); n++;
	Wok = XmCreatePushButton (Wrcbottom, "none", args, n);
	XtManageChild (Wok);
	XtAddCallback (Wok, XmNactivateCallback, (XtCallbackProc)ButtonsCB, (void *)1000);
		
	/****************************/
	/* RowColumn per gli eventi */
	/****************************/
	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNbottomWidget, Wrcbottom); n++;
	XtSetArg (args[n], XmNpacking, XmPACK_COLUMN); n++;
	XtSetArg (args[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg (args[n], XmNnumColumns, 2); n++;
	XtSetArg (args[n], XmNspacing, 5); n++;
	Wrc = XmCreateRowColumn (Wdialog, "rowcol", args, n); n++;
	XtManageChild (Wrc);
	
	/**********/
	/* Eventi */
	/**********/
	
	for (i=0; i<numevents; i++) {
		n = 0;
		XtSetArg (args[n], XmNset, TEV_CHECK_MASK(mask, events[i+first].mask)); n++;
		XtSetArg (args[n], XmNlabelString, XmStringCreate(events[i+first].name, DEFSET)); n++;
		Wevents[i] = XmCreateToggleButton (Wrc, "eventtoggle", args, n);
		XtManageChild (Wevents[i]);
		XtAddCallback (Wevents[i], XmNvalueChangedCallback, (XtCallbackProc)ButtonsCB, (void *)i);
	}
	
	
	/**** Situazione iniziale ****/

	btn = -1;
	
	/**** Chiusura = Ok ****/
	
	MotifProtectShell (XtParent(Wdialog), (XtCallbackProc)ButtonsCB, (void *)1000);

	/**** Main Loop ****/
	
	for (;;) {
		XtAppProcessEvent (XtWidgetToApplicationContext(Wdialog), XtIMAll);
		switch (btn) {
		
			case -1:	/* Nop */
						break;
			
			case 1000:	/* chiusura */
						XtUnmapWidget (XtParent(Wdialog));
						XtDestroyWidget (XtParent(Wdialog));
						free (Wevents);
						btn = -1;	/* non deve "disturbare" il dialog precedente! */
						return;
						break;
						
			case 1001:	/* tutti */
						for (i=0; i<numevents; i++) {
							n = 0;
							XtSetArg (args[n], XmNset, True); n++;
							XtSetValues (Wevents[i], args, n);
							TEV_SET_MASK (mask, events[i+first].mask); n++;
						}
						break;
						
			case 1002:	/* nessuno */
						for (i=0; i<numevents; i++) {
							n = 0;
							XtSetArg (args[n], XmNset, False); n++;
							XtSetValues (Wevents[i], args, n);
							TEV_UNSET_MASK (mask, events[i+first].mask); n++;
						}
						break;
						
			default:	/* un evento e` cambiato */
						n = 0;
						if (TEV_CHECK_MASK(mask, events[btn+first].mask)) {
							TEV_UNSET_MASK(mask, events[btn+first].mask);
							XtSetArg (args[n], XmNset, False); n++;
						}
						else {
							TEV_SET_MASK(mask, events[btn+first].mask);
							XtSetArg (args[n], XmNset, True); n++;
						}
						XtSetValues (Wevents[btn], args, n);	
						break;
		}
		
		btn = -1;
	}
}

