/*****************************************************************************\
*                                                                             *
*  modNetworkObj.h - Lista generale rete			                          *
*  1.0 - 20/5/95                                                              *
*                                                                             *
\*****************************************************************************/

/*
 *
 *          WAMM version 1.0: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, G. Faieta, M. Formica, D. Laforenza
 *                   (C) 1995 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

#ifndef MODNETWORKOBJ_H
#define MODNETWORKOBJ_H

#include <stdlib.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <xpm.h>

/********************/
/* moduli richiesti */
/********************/

/***************/
/* definizioni */
/***************/

#define NET_WAN		0
#define NET_MAN		1
#define NET_LAN		2
#define NET_HOST	3

/***********************/
/* strutture pubbliche */
/***********************/

struct NetworkObj {
	struct NetworkObj * next;		/* successivo */
	struct NetworkObj * parent;		/* padre */
	int nchildren;					/* numero figli */
	struct NetworkObj ** children;	/* vettore figli */
	unsigned char * name;			/* nome oggetto */
	int type;						/* tipo oggetto */
	unsigned char * title;			/* titolo */
	unsigned char * pict;			/* mappa o icona */
	unsigned char * addr;			/* indirizzo */
	unsigned char * arch;			/* architettura */
	unsigned char * info;			/* informazioni */
	unsigned char * options;		/* opzioni PVM */
	int numcmd;						/* numero comandi utente */
	struct HostCmd * firstcmd;		/* primo comando utente */
	struct HostCmd * lastcmd;		/* ultimo comando utente */
	int xhost;						/* 1 = xhost eseguito */
	int dtid;						/* tid demone (0 = non in PVM) */
	int taskertid;					/* tid tasker (0 = non e` partito) */
	unsigned char * password;		/* password host */
	int selection;					/* 1 se selezionato */
	int x,y;						/* posizione del bottone di apertura */
	Pixmap pm;						/* piantina o icona */
	Pixmap pmmask;					/* maschera per pm */
	XpmAttributes pma;				/* attributi di pm */
	int pmres;						/* risultato caricamento pixmap */
	Widget Wbutton;					/* bottone di apertura */
	Widget Wshell;					/* shell (0 = finestra non aperta) */
	Widget Wlist;					/* lista host */
	Widget Wstatus;					/* widget messaggi di stato */
	Widget Wselection;				/* widget selezione */
	Widget Wpvm;					/* widget PVM */
	Widget Wpopup;					/* menu popup */
	GC gc;							/* graphic context */
};

struct HostCmd {
	struct HostCmd * next;		/* comando successivo */
	struct NetworkObj * no;		/* nodo */
	unsigned char * name;		/* nome comando */
	unsigned char * cmd;		/* comando */
	int x;						/* 1 = comando X11 */
};

/**********************/
/* funzioni pubbliche */
/**********************/

void	NetworkObjInit (void);
void	NetworkObjEnd (void);

struct NetworkObj * 	NetworkObjAdd (unsigned char *, int);
struct NetworkObj *		NetworkObjFirst (void);
struct NetworkObj *		NetworkObjFind (unsigned char *, int);
struct NetworkObj *		NetworkObjFindByAddr (unsigned char *);
struct NetworkObj *		NetworkObjFindByDtid (int);

#endif
