/*****************************************************************************\
*                                                                             *
*  PVMMaker.c - "Maker" remoto per WAMM								          *
*  1.0 - 29/3/95                                                              *
*                                                                             *
\*****************************************************************************/

/*
 *
 *          WAMM version 1.0: Wide Area Metacomputer Manager
 *     CNUCE - Institute of the Italian National Research Council
 *      Authors:  R. Baraglia, G. Faieta, M. Formica, D. Laforenza
 *                   (C) 1995 All Rights Reserved
 *
 *                              NOTICE
 *
 *
 * Permission is hereby granted, without written agreement and without license
 * or royalty fees, to use, copy, modify, and distribute this software and
 * its documentation for educational and research purpose only, provided that
 * the above copyright notice and the following two paragraphs appear in all
 * copies of this software and in the supporting documentation. No charge,
 * other than an "at-cost" distribution fee, may be charged for copies,
 * derivations, or distributions of this material without the express written
 * consent of the copyright holder.
 * 
 * IN NO EVENT SHALL THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS BE LIABLE TO
 * ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THEINSTITUTION OR THE AUTHORS HAS BEEN ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * THE INSTITUTION (CNUCE-CNR) AND THE AUTHORS SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHORS HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <pvm3.h>
#include <sys/stat.h>
#include "tags.h"

/***********/
/* esterne */
/***********/

extern char * sys_errlist[];	/* messaggi di errore */

/*********************/
/* variabili globali */
/*********************/

int MyTid;					/* tid maker */
int ParentTid;				/* tid interfaccia */
struct stat * Stat;			/* stat $PVM_ROOT/tmp */
unsigned char * MakeBuf;	/* directory da compilare */

/***************/
/* definizioni */
/***************/

#define VERSION		"1.0"		/* versione tasker */

/************/
/* funzioni */
/************/

void SendMsg (unsigned char *);
void SendMsgEnd (unsigned char *, int);
void Exit (int);

/********/
/* main */
/********/

void main (int argc, char ** argv)
{	

	unsigned char buffer[1000];
	int res, len;
	
	int ver;						/* 1=versione ok */
	unsigned char * pvmroot;		/* PVM_ROOT */
	
	FILE * fh;						/* file compresso */
	
	/*************************/
	/* Registra il programma */
	/*************************/
	
	MyTid = pvm_mytid();
	ParentTid = pvm_parent();
	
	setbuf (stdout, NULL);
	
	/****************************/
	/* Controllo versione e ack */
	/****************************/
		
	ver = (!strcmp(VERSION,argv[1]));
	
	pvm_packf ("%+ %d", PvmDataDefault, ver);
	pvm_send (ParentTid, T_MKR_ACK);
	
	if (!ver) Exit(1);
	
	/**********************************/
	/* Preleva la directory compressa */
	/**********************************/
	
	pvm_recv (ParentTid, T_MKR_DIR);
	pvm_unpackf ("%d", &len);
	MakeBuf = calloc (len, 1);
	pvm_upkbyte (MakeBuf, len, 1);
		
	/**********************/
	/* Controllo PVM_ROOT */
	/**********************/
	
	SendMsg ("checking PVM_ROOT...");
	
	pvmroot = getenv ("PVM_ROOT");
	if (!pvmroot) {
		SendMsgEnd ("PVM_ROOT not defined!", 1);
		Exit (1);
	}
	
	if (pvmroot[0] != '/') {
		SendMsgEnd ("PVM_ROOT is a relative path; must be absolute!", 1);
		Exit (1);
	}
	
	/****************/
	/* PVM_ROOT/tmp */
	/****************/
	
	SendMsg ("checking PVM_ROOT/tmp...");
	
	sprintf (buffer, "%s/tmp", pvmroot);
	Stat = calloc (1, sizeof (struct stat));
	if (!stat(buffer, Stat)) {
		
		/**** directory presente: la cancella ****/
		
		sprintf (buffer, "rm -Rf %s/tmp", pvmroot);
		res = system (buffer);
		if (res) {
			SendMsgEnd ("can't remove $PVM_ROOT/tmp!", res);
			Exit (1);
		}
	}
	
	/**** crea la directory ****/
	
	SendMsg ("making PVM_ROOT/tmp...");

	sprintf (buffer, "mkdir %s/tmp", pvmroot);
	res = system (buffer);
	if (res) {
		SendMsgEnd ("can't make $PVM_ROOT/tmp!", res);
		Exit (1);
	}

	/**** cambia directory ****/
	
	sprintf (buffer, "%s/tmp", pvmroot);
	chdir (buffer);
	
	/********/
	/* File */
	/********/
	
	SendMsg ("making PVM_ROOT/tmp/make.tar.Z...");
	
	/**** crea il file ****/
	
	fh = fopen ("make.tar.Z", "w");
	if (!fh) {
		sprintf ("can't make PVM_ROOT/tmp/make.tar.Z: %s.", sys_errlist[errno]);
		SendMsgEnd (buffer, 1);
		Exit (1);
	}
	fwrite (MakeBuf, 1, len, fh);
	fclose (fh);
	
	/**** uncompress ****/
	
	SendMsg ("uncompress make.tar.Z...");
	res = system ("uncompress make.tar.Z");
	if (res) {
		SendMsgEnd ("uncompress make.tar.Z failed!", res);
		Exit (1);
	}
	
	/**** untar ****/
					  
	SendMsg ("untar make.tar...");
	res = system ("tar xf make.tar");
	if (res) {
  		SendMsgEnd ("untar make.tar failed!", res);
  		Exit (1);
  	}

	unlink ("make.tar");

	/********/
	/* Make */
	/********/
	
	SendMsg ("make...");
	if (argc > 1) sprintf (buffer, "make %s", argv[2]);
	else sprintf (buffer, "make");
	res = system (buffer);
	if (res) {
		SendMsgEnd ("make failed!", res);
		Exit (1);
	}
	else SendMsgEnd ("OK!", 0);
	
	Exit (0);
}

/***********/
/* SendMsg */
/***********/

void SendMsg (unsigned char * msg)
{
	pvm_packf ("%+ %s", PvmDataDefault, msg);
	pvm_send (ParentTid, T_MKR_MSG);
}

/**************/
/* SendMsgEnd */
/**************/

void SendMsgEnd (unsigned char * msg, int code)
{
	pvm_packf ("%+ %s %d", PvmDataDefault, msg, code);
	pvm_send (ParentTid, T_MKR_MSGEND);
}

/********/
/* Exit */
/********/

void Exit (int code)
{
	if (MakeBuf) free (MakeBuf);	
	if (Stat) free (Stat);
	
	pvm_exit ();
	exit (code);
}
