/* 
 * tkAppInit.c --
 *
 *	Provides a default version of the Tcl_AppInit procedure for
 *	use in wish and similar Tk-based applications.
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef lint
static char sccsid[] = "@(#) tkAppInit.c 1.12 94/12/17 16:30:56";
#endif /* not lint */

#include "tcl.h"

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

#ifdef	__cplusplus
extern "C" {
#endif

extern int matherr _ANSI_ARGS_((int exception));
int (*tclDummyMathPtr) _ANSI_ARGS_((int exception)) = matherr;

/*
 * Define some functions for Pvm and Tk. In this way the include files
 * "tkpvm.h" and "tk.h" don't need to be present.
 */

extern int	Pvm_Init _ANSI_ARGS_((Tcl_Interp *interp));
extern int	Pvm_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
extern void	Tk_Main _ANSI_ARGS_((int argc, char **argv,
		    Tcl_AppInitProc *appInitProc));
extern int	Tk_Init _ANSI_ARGS_((Tcl_Interp *interp));
#if (TCL_MAJOR_VERSION > 7)
extern int	Tk_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
#else
#define		Tk_SafeInit (Tcl_PackageInitProc *) NULL
#endif

#ifdef	__cplusplus
}
#endif

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tk_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */
int
#ifdef __cplusplus
main (int    argc,		/* Number of command-line arguments. */
      char **argv)		/* Values of command-line arguments. */
#else
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
#endif
{
    Tk_Main(argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}


/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
#ifdef __cplusplus
Tcl_AppInit (Tcl_Interp *interp)/* Interpreter for application. */
#else
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
#endif
{
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    if (Pvm_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#if (TCL_MAJOR_VERSION > 7) || (TCL_MINOR_VERSION > 4)
    Tcl_StaticPackage(interp, "Tk",Tk_Init, Tk_SafeInit);
    Tcl_StaticPackage(interp, "Pvm", Pvm_Init, Pvm_SafeInit);
#endif

    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

#if (TCL_MAJOR_VERSION > 7) || (TCL_MINOR_VERSION > 4)
    Tcl_SetVar(interp, "tcl_rcFileName", "~/.pvmwishrc", TCL_GLOBAL_ONLY);
#else
    tcl_RcFileName = "~/.pvmwishrc";
#endif
    return TCL_OK;
}
