#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef NO_STRING_H
#   include <string.h>
#else
#   include <strings.h>
#   define strchr index
#endif

#include "tkpvmInt.h"

/*
 * Not all systems declare the errno variable in errno.h. so this
 * file does it explicitly.  The list of system error messages also
 * isn't generally declared in a header file anywhere.
 */

extern int errno;


/*
 *----------------------------------------------------------------------
 *
 * Pvm_SendCmd --
 *
 *	This procedure is invoked to process the "send" Tkpvm command.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *----------------------------------------------------------------------
 */

	/* ARGSUSED */
int
Pvm_SendCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    int tid, pvmerror, msgtag;
    union value {	char c;
			short s;
			int i;
			long l;
			float f;
			double d;
    } v;
#define STATIC_SIZE 32
    char static_array[STATIC_SIZE];
    char *groupname = NULL;
    pvmerror = 0;

    if (argc<4) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			    " tid msgtag ....\"",(char *) NULL);
	return TCL_ERROR;
    }
	    
    if (*argv[1]==0) {
	Tcl_AppendResult(interp, "expected tid or groupname but got \"\"",
		    (char *) NULL);
	return TCL_ERROR;
    } else if (!strcmp(argv[1],"parent")) {
	    tid = pvm_parent();
	    if (tid==PvmSysErr||tid==PvmNoParent) {
		pvmerror = tid;
		return Pvm_ReturnError(interp,pvmerror);
	    }
    } else if (!strcmp(argv[1],"id")) {
	    tid = pvm_mytid();
	    if (tid==PvmSysErr) {
		pvmerror = tid;
		return Pvm_ReturnError(interp,pvmerror);
	    }
    } else {
	    char *p;
	    errno = 0;
	    tid = strtol(argv[1],&p,0);
	    if (p[0] || errno) {
		groupname = argv[1];
	    } else if (Tcl_IsSafe(interp) && ((tid & 0x3ffff) == 0)) {
		Tcl_AppendResult(interp, "not allowed to send anything to a",
			" pvm daemon in a safe interpreter", (char *) NULL);
		return TCL_ERROR;
	    }
    }
    if (Tcl_GetInt(interp, argv[2], &msgtag) != TCL_OK) {
	    return TCL_ERROR;
    }
    argc-=3; argv+=3;
    pvm_initsend(PvmDataDefault);
    while(argc) {
	    char *p = NULL,*q = NULL,*r = NULL;
	    int n,i,j; char **largv = NULL;
	    errno = 0; n=1;
	    if ((argv[0][0]=='-')&&(argv[0][1]>='a')&&(argv[0][1]<='z')) {
		if (argc<2) {
		    Tcl_AppendResult(interp, "value missing for option \"",
				argv[0], "\"",(char *) NULL);
		    return TCL_ERROR;
		}
		r=strchr(argv[0],'(');
		if (r) {
		    if (r[1]==')') n = -1;
		    else {
			n = strtol(r+1,&q,0);
			if(n<0||!q || q[0]!=')'||q[1]) {
			    Tcl_AppendResult(interp, "invalid option \"",
				    argv[0], "\": invalid size of array",
				    (char *) NULL);
			    return TCL_ERROR;
			}
		    }
		    *r=0;
		} else {
		    n=1;
		}
		if(n!=1) {
		    if(!strcmp(argv[0],"-char")) {
			i=strlen(argv[1]);
		    } else if (Tcl_SplitList(interp, argv[1], &i, &largv)
			    != TCL_OK) {
			if (largv != NULL) {
			    ckfree((char *) largv);
			}
			return TCL_ERROR;
		    }
		    
		} else {
		    largv = argv+1; i=1;
		}
		if (n<0) {
		    pvmerror = pvm_pkint(&i,1,1); n=i;
		    if (pvmerror<0) {
			if (largv != NULL) {
			    ckfree((char *) largv);
			}
			return Pvm_ReturnError(interp,pvmerror);
		    }
		}
		if (!strcmp(argv[0],"-char")) {
		    if (n<=i) {
			pvmerror = pvm_pkbyte(argv[1],n,1);
		    } else {
			pvmerror = pvm_pkbyte(argv[1],i,1);
			if((n-=i)<STATIC_SIZE) {
			    p = static_array;
			} else {
			    p = (char *) ckalloc(n);
			}
			for(i=0;i<n; i++) p[i]=0;
			pvmerror = pvm_pkbyte(p,n,1);
		    }
		} else if (!strcmp(argv[0],"-byte")) {
		    if(n<=STATIC_SIZE) {
			p = static_array;
		    } else {
			p = (char *) ckalloc(n);
		    }
		    pvmerror = 0;
		    for(j=0;j<n;j++) {
			if(j>=i) {
			    p[j] = 0;
			} else if(Tcl_GetInt(interp,largv[j],&v.i) != TCL_OK) {
			    pvmerror = -1; break;
			} else {
			    p[j] = v.i;
			}
		    }
		    pvmerror = pvm_pkbyte(p,n,1);
		} else if (!strcmp(argv[0],"-short")) {
		    if(sizeof(short)*n<=STATIC_SIZE)  {
			p = static_array;
		    } else {
			p = (char *) ckalloc(sizeof(short)*n);
		    }
		    pvmerror = 0;
		    for(j=0;j<n;j++) {
			if(j>=i) {
			    ((short *)p)[j] = 0;
			} else if(Tcl_GetInt(interp,largv[j],&v.i) != TCL_OK) {
			    pvmerror = -1; break;
			} else {
			    ((short *)p)[j] = v.i;
			}
		    }
		    pvmerror = pvm_pkshort((short *)p,n,1);
		} else if ((!strcmp(argv[0],"-int"))||(!strcmp(argv[0],"-tid"))) {
		    if(sizeof(int)*n<=STATIC_SIZE)  {
			p = static_array;
		    } else {
			p = (char *) ckalloc(sizeof(int)*n);
		    }
		    pvmerror = 0;
		    for(j=0;j<n;j++) {
			if(j>=i) {
			    ((int *)p)[j] = 0;
			} else if (Tcl_GetInt(interp,largv[j],&v.i) != TCL_OK) {
			    pvmerror = -1; break;
			} else {
			    ((int *)p)[j] = v.i;
			}
		    }
		    pvmerror = pvm_pkint((int *)p,n,1);
		} else if (!strcmp(argv[0],"-long")) {
		    if(sizeof(long)*n<=STATIC_SIZE)  {
			p = static_array;
		    } else {
			p = (char *) ckalloc(sizeof(long)*n);
		    }
		    pvmerror = 0;
		    for(j=0;j<n;j++) {
			if(j>=i) {
			    ((long *)p)[j] = 0;
			} else if(Tcl_GetInt(interp,largv[j],&v.i) != TCL_OK) {
			    pvmerror = -1; break;
			} else {
			    ((long *)p)[j] = (long) v.i;
			}
		    }
		    pvmerror = pvm_pklong((long *)p,n,1);
		} else if (!strcmp(argv[0],"-float")) {
		    if(sizeof(float)*n<=STATIC_SIZE)  {
			p = static_array;
		    } else {
			p = (char *) ckalloc(sizeof(float)*n);
		    }
		    pvmerror = 0;
		    for(j=0;j<n;j++) {
			if(j>=i) {
			    ((float *)p)[j] = 0;
			} else if(Tcl_GetDouble(interp,largv[j],&v.d) != TCL_OK) {
			    pvmerror = -1; break;
			} else {
			    ((float *)p)[j] = (float) v.d;
			}
		    }
		    pvmerror = pvm_pkfloat((float *)p,n,1);
		} else if (!strcmp(argv[0],"-double")) {
		    if(sizeof(double)*n<=STATIC_SIZE)  {
			p = static_array;
		    } else {
			p = (char *) ckalloc(sizeof(double)*n);
		    }
		    pvmerror = 0;
		    for(j=0;j<n;j++) {
			if(j>=i) {
			    ((double *)p)[j] = 0;
			} else if(Tcl_GetDouble(interp,largv[j],&v.d) != TCL_OK) {
			    pvmerror = -1; break;
			} else {
			    ((double *)p)[j] = v.d;
			}
		    }
		    pvmerror = pvm_pkdouble((double *)p,n,1);
		} else if (!strcmp(argv[0],"-string")) {
		    pvmerror = 0;
		    for(j=0;(j<n) && (pvmerror>=0);j++) {
			if(j<i) {
			    pvmerror = pvm_pkstr(largv[j]);
			} else {
			    pvmerror = pvm_pkstr("");
			}
		    }
		} else {
		    Tcl_AppendResult(interp, "invalid option \"", argv[0],
					"\"",(char *) NULL);
		    pvmerror = -1;

		}
		if(r) *r = '(';
		if((p!=static_array) && (p!=NULL)) ckfree(p);
		if ((largv != NULL) && (largv != argv+1)) {
		    ckfree((char *) largv);
		}
		argc--; argv++;
	    } else {
		v.i = strtol(argv[0], &p, 0); /* try integer */
		if (!p[0] && !errno) {
		    pvmerror = pvm_pkint(&v.i,1,1);
		} else {
		    v.d = strtod(argv[0], &p); /* try double */
		    if (!p[0] && !errno) {
			pvmerror = pvm_pkdouble(&v.d,1,1);
		    } else {
			pvmerror = pvm_pkstr(argv[0]);
		    }
		}
	    }
	    argc--; argv++;
	    if (pvmerror<0) return Pvm_ReturnError(interp,pvmerror);
    }
    if (groupname) {
	pvmerror = pvm_bcast(groupname,msgtag);
    } else {
	pvmerror = pvm_send(tid, msgtag);
    }
    return Pvm_ReturnError(interp,pvmerror);
}
