
/* This file is created by the "tcl2c" utility, which is included in
 * most "plus"-patches (e.g. for Tcl7.6 and Tcl8.0). Standalone
 * executables can be made by providing alternative initialization
 * functions which don't read files any more. Sometimes, small
 * adaptations to the original libraries are needed to get the
 * application truly standalone. The "plus"-patches contain these
 * adaptations for Tcl and Tk. If you just create your own
 * Xxx_InitStandAlone() function for your package, you can
 * easyly extend the "tcl2c" utility to your own requirements.
 *
 *	Jan Nijtmans
 *	NICI (Nijmegen Institute of Cognition and Information)
 *	email: nijtmans@nici.kun.nl
 *	url:   http://www.cogsci.kun.nl/~nijtmans/
 */
#include "tcl.h"

/*
 * Defines to replace the standard Xxx_Init calls to Xxx_InitStandAlone.
 * If you don't have this function, just delete the corresponding
 * define such that the normal initialization function is used.
 * Similar: If SafeInit functions exists, you can use these
 * by commenting out the corresponding lines below.
 */

#ifdef TCL_ACTIVE
#define Tcl_Init Tcl_InitStandAlone
#define Tk_Init Tk_InitStandAlone
#define Img_Init Img_InitStandAlone
#endif

#define Tcl_SafeInit (Tcl_PackageInitProc *) NULL
#define Tk_SafeInit (Tcl_PackageInitProc *) NULL
#define Img_SafeInit (Tcl_PackageInitProc *) NULL

/*
 * Prototypes of all initialization functions and the free() function.
 * So, only "tcl.h" needs to be included now.
 */

#ifdef __cplusplus
extern "C" {
#endif

extern void free _ANSI_ARGS_((void *));
extern int  Tcl_Init _ANSI_ARGS_((Tcl_Interp *interp));
#ifndef Tcl_SafeInit
extern int  Tcl_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
extern int  Tk_Init _ANSI_ARGS_((Tcl_Interp *interp));
#ifndef Tk_SafeInit
extern int  Tk_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
extern int  Img_Init _ANSI_ARGS_((Tcl_Interp *interp));
#ifndef Img_SafeInit
extern int  Img_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

extern int matherr _ANSI_ARGS_((void));
int (*tclDummyMathPtr) _ANSI_ARGS_((void)) = matherr;

#ifdef __cplusplus
}
#endif

/*
 * The array "script" contains the script that is compiled in.
 * It will be executed in tclAppInit() after the other initializations.
 */

static int line = (__LINE__ + 1);

static char script_line1[] = {
   'p','a','c','k','a','g','e',' ','r','e','q','u','i','r',
   'e',' ','P','v','m',' ','1','.','2',
   '\0' };

static char script_line2[] = {
   'p','u','t','s',' ','s','t','d','o','u','t',' ','"','H',
   'e','l','l','o',',',' ','W','o','r','l','d','"',
   '\0' };
static char *script[] = {
script_line1,
script_line2,
(char *) NULL
};

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

void
#ifdef _USING_PROTOTYPES_
main (int    argc,		/* Number of command-line arguments. */
      char **argv)		/* Values of command-line arguments. */
#else
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
#endif
{
    Tcl_Interp *interp;
    char **p = script;
    char *q, buffer[10];
    Tcl_DString data;
    Tcl_Channel inChannel, outChannel, errChannel;

    Tcl_FindExecutable(argv[0]);
    interp = Tcl_CreateInterp();

    q = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", q, TCL_GLOBAL_ONLY);
    ckfree(q);
    sprintf(buffer, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buffer, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", argv[0],TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tcl_interactive","0", TCL_GLOBAL_ONLY);

    if (Tcl_Init(interp) != TCL_OK) {
        goto error;
    }
    if (Tk_Init(interp) != TCL_OK) {
        goto error;
    }
    Tcl_StaticPackage(interp, "Tk", Tk_Init, Tk_SafeInit);
    Tcl_StaticPackage(interp, "Img", Img_Init, Img_SafeInit);
    if (Img_Init(interp) != TCL_OK) {
        goto error;
    }

    /*
     * Execute the script that is compiled in.
     */

    inChannel = Tcl_GetStdChannel(TCL_STDIN);
    outChannel = Tcl_GetStdChannel(TCL_STDOUT);
    Tcl_DStringInit(&data);
    while(*p) {
	Tcl_DStringSetLength(&data,0);
	Tcl_DStringAppend(&data,*p++,-1);
	if (Tcl_Eval(interp,Tcl_DStringValue(&data)) != TCL_OK) {
	    Tcl_DStringFree(&data);
	    while (p-- != script) {
		for (q = *p;*q; q++) {
		    if (*q=='\n') line++;
		}
		line++;
	    }
	    sprintf(buffer,"%d",line);
	    Tcl_AddErrorInfo(interp,"\n	( Error in file: \"");
	    Tcl_AddErrorInfo(interp,__FILE__);
	    Tcl_AddErrorInfo(interp,"\", line: ");
	    Tcl_AddErrorInfo(interp,buffer);
	    Tcl_AddErrorInfo(interp,")");
	    errChannel = Tcl_GetStdChannel(TCL_STDERR);
	    if (errChannel) {
		Tcl_Write(errChannel,
			Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY), -1);
		Tcl_Write(errChannel, "\n", 1);
	    }
	    sprintf(buffer, "exit %d", 1);
	    Tcl_Eval(interp, buffer);
	}
    }
    Tcl_DStringFree(&data);

    while (Tcl_DoOneEvent(0)) {
	/* empty loop body */ ;
    }
    sprintf(buffer, "exit %d", 0);
    Tcl_Eval(interp, buffer);

error:
    errChannel = Tcl_GetStdChannel(TCL_STDERR);
    if (errChannel) {
	Tcl_Write(errChannel,
		"application-specific initialization failed: ", -1);
	Tcl_Write(errChannel, interp->result, -1);
	Tcl_Write(errChannel, "\n", 1);
    }
    sprintf(buffer, "exit %d", 1);
    Tcl_Eval(interp, buffer);
}
