#include <stdio.h>
#include <stdlib.h>

#ifndef NO_STRING_H
#   include <string.h>
#else
#   include <strings.h>
#endif

#include <pwd.h>
#include "tkpvmInt.h"


/*
 *----------------------------------------------------------------------
 *
 * Pvm_RecvCmd --
 *
 *	This procedure is invoked to process the "recv" Tkpvm command.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *----------------------------------------------------------------------
 */

int
Pvm_RecvCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    int tid, pvmerror = 0;
    char *stor, storage[100];
    char *parstor, parstorage[100];
    char *p = NULL,*q = NULL,*r = NULL;
    int n = 1, totalargc;
    union value {	char c;
			short s;
			int i;
			long l;
			float f;
			double d;
    } v;

    if (!PvmMytid) {
	if (!Pvm_StartDaemon(interp))
	    return TCL_ERROR;
    }
    if (argc<2) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			    " ....\"",(char *) NULL);
	return TCL_ERROR;
    }
    argc-=1; argv+=1; totalargc = argc;
    while(argc) {
	int size;
	stor = storage; storage[0] = 0;
	r=strchr(*argv,'(');
	if (r) {
	    if (r[1]==')') {
		pvmerror = pvm_upkint(&n,1,1);
		if (pvmerror<0) Pvm_ReturnError(interp,pvmerror);
		if(n<0) {
		    Tcl_AppendResult(interp, "cannot receive \"",
			    argv[0], "\": array has negative number",
			    " of elements",(char *) NULL);
		    return TCL_ERROR;
		}
	    } else {
		n = strtol(r+1,&q,0);
		if(n<0||!q || q[0]!=')'||q[1]) {
		    Tcl_AppendResult(interp, "invalid option \"", argv[0],
			    "\": invalid size of array",(char *) NULL);
		    return TCL_ERROR;
		}
	    }
	    *r=0;
	} else {
	    n=1;
	}
	if (*(interp->result)!='\0')
	    Tcl_AppendResult(interp," ",(char *)NULL);
	if ((size>1) && (totalargc>1)) {
	    Tcl_AppendResult(interp,"{",(char *)NULL);
	}
	size = n;
	while (n-- >0) {
	    if (*(interp->result)!='\0' &&
		    (interp->result[strlen(interp->result)-1]) != '{')
		Tcl_AppendResult(interp," ",(char *)NULL);
	    if (!strcmp(*argv,"byte")) {
		char num[5];
		num[0] = ' ';
		if (size>=24) {
		    stor = (char *) ckalloc(4*size+1);
		}
		pvmerror = pvm_upkbyte(stor,size,1);
		n = size;
		while (n--) {
		    stor[4*n] = stor[n];
		}
		sprintf(stor,"%d",stor[0]);
		for (n=1; n<size; n++) {
		    sprintf(num+1,"%d", stor[4*n]);
		    strcat(stor,num);
		}
		n = 0;
	    } else if (!strcmp(*argv,"char")) {
		if (size>=99) {
		    stor = (char *) ckalloc(size+1);
		}
		pvmerror = pvm_upkbyte(stor,size,1);
		stor[size] = 0;
		n = 0;
	    } else if (!strcmp(*argv,"short")) {
		pvmerror = pvm_upkshort(&v.s,1,1);
		sprintf(storage,"%d",v.s);
	    } else if (!strcmp(*argv,"int")) {
		pvmerror = pvm_upkint(&v.i,1,1);
		sprintf(storage,"%d",v.i);
	    } else if (!strcmp(*argv,"long")) {
		pvmerror = pvm_upklong(&v.l,1,1);
		sprintf(storage,"%d",v.l);
	    } else if (!strcmp(*argv,"tid")) {
		pvmerror = pvm_upkint(&v.i,1,1);
		sprintf(storage,"0x%x",v.i);
	    } else if (!strcmp(*argv,"float")) {
		pvmerror = pvm_upkfloat(&v.f,1,1);
		Tcl_PrintDouble(interp,v.f,storage);
	    } else if (!strcmp(*argv,"double")) {
		pvmerror = pvm_upkdouble(&v.d,1,1);
		Tcl_PrintDouble(interp,v.d,storage);
	    } else if (!strcmp(*argv,"string")) {
		pvmerror = pvm_upkint(&v.i,1,1);
		if (pvmerror>=0) {
		    if (v.i>=99) {
			stor = (char *) ckalloc(v.i+1);
		    }
		    if (v.i>0) {
			pvmerror=pvm_upkbyte(stor,v.i,1);
			if (stor[v.i-1] != 0) {
			    stor[v.i] = 0;
			}
		    } else {
			stor[0]=0;
		    }
		}
		if (size>1) {
		    Tcl_AppendElement(interp,stor);
		    if (stor!=storage) ckfree(stor);
		    stor = storage; storage[0] = 0;
		}
	    } else {
		Tcl_AppendResult(interp,"wrong format \"",*argv,
			"\", should be byte, char, short, ",
			"int, long, tid, float, double or string",
			(char *)NULL);
		pvmerror = -1;
	    }
	    Tcl_AppendResult(interp,stor,(char *) NULL);
	    if (stor!=storage) ckfree(stor);
	    stor = storage; storage[0] = 0;
	    if (pvmerror<0) {
		break;
	    }
	    if ((size>1) && (totalargc>1)) {
		Tcl_AppendResult(interp,"}",(char *)NULL);
	    }
	}
	argc--; argv++;
    }
    return Pvm_ReturnError(interp,pvmerror);
}
