"package require Tcl 7.6",
"package require Pvm 1.1",
"catch {import add ::pvm}",
"if {[info exists auto_path] && [info exists pvm_library] && $pvm_library != \"\"} {\n\
    if {[lsearch -exact $auto_path $pvm_library] < 0} {\n\
	lappend auto_path $pvm_library\n\
    }\n\
}",
"if [string match {} [info command bind]] {\n\
    proc bind {args} {\n\
	return [eval pvm bind $args]\n\
    }\n\
}",
"if [string match {} [info command kill]] {\n\
    proc kill {args} {\n\
	return [eval pvm kill $args]\n\
    }\n\
}",
"if [string match {} [info command send]] {\n\
    proc send {args} {\n\
	return [eval pvm send $args]\n\
    }\n\
}",
"proc pvm_replace_commands {} {\n\
    if [string match {} [info proc kill]] {\n\
	rename kill tclx_kill\n\
	proc kill {args} {\n\
	    catch {[eval tclx_kill $args]}\n\
	    return [eval pvm kill $args]\n\
	}\n\
    }\n\
    if [string match {} [info proc bind]] {\n\
	rename bind tk_bind\n\
	proc bind {args} {\n\
	    set msgtag [lindex $args 0]\n\
	    if {$msgtag==\"any\" || $msgtag==\"kill\" || [regexp {^[0-9]+$} $msgtag]} {\n\
		return [eval pvm bind $args]\n\
	    } else {\n\
		return [eval tk_bind $args]\n\
	    }\n\
	}\n\
    }\n\
    if [string match {} [info proc send]] {\n\
	rename send tk_send\n\
	proc send {args} {\n\
	    set msgtag [lindex $args 1]\n\
	    if [regexp {^[0-9]+$} $msgtag] {\n\
		return [eval pvm send $args]\n\
	    } else {\n\
		return [eval tk_send $args]\n\
	    }\n\
	}\n\
    }\n\
}",
"if [string match {} [info command tcl_load]] {\n\
    rename load tcl_load\n\
}",
"proc load args {\n\
    set result [eval tcl_load $args]\n\
    pvm_replace_commands\n\
    return result\n\
}",
"pvm_replace_commands",
"if [string compare [uplevel #0 info commands @scope] {}] {\n\
\n\
namespace itcl {\n\
    public variable purist 0\n\
\n\
    public proc pvm_unknown {cmd args} {\n\
        global purist\n\
\n\
        if [catch [uplevel pvm::$cmd $args]] {\n\
	    return -code continue\n\
	}\n\
    }\n\
    unknown_handler \"pvm\" itcl::pvm_unknown\n\
}\n\
\n\
}",
