/* 
 * tclAppInit.c --
 *
 *	Provides a default version of the Tcl_AppInit procedure.
 *
 */

#include "tcl.h"

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */
#ifdef	__cplusplus
extern "C" {
#endif

extern int matherr _ANSI_ARGS_((int exception));
int (*tclDummyMathPtr) _ANSI_ARGS_((int exception)) = matherr;


extern int	Pvm_Init _ANSI_ARGS_((Tcl_Interp *interp));
extern void	Pvm_Main _ANSI_ARGS_((int argc, char **argv,
			    Tcl_AppInitProc *appInitProc));

#ifdef	__cplusplus
}
#endif

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tcl_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
#ifdef __cplusplus
main (int    argc,		/* Number of command-line arguments. */
      char **argv)		/* Values of command-line arguments. */
#else
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
#endif
{
    Pvm_Main(argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */
int
#ifdef __cplusplus
Tcl_AppInit (Tcl_Interp *interp)
#else
Tcl_AppInit(interp)
    Tcl_Interp *interp;
#endif
{
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    if (Pvm_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#if (TCL_MAJOR_VERSION > 7) || (TCL_MINOR_VERSION > 4)
    Tcl_StaticPackage(interp, "Pvm", Pvm_Init, (Tcl_PackageInitProc *) NULL);
#endif

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

#if (TCL_MAJOR_VERSION == 7) && (TCL_MINOR_VERSION < 5)
    tcl_RcFileName = "~/.pvmshrc";
#else
    Tcl_SetVar(interp, "tcl_rcFileName", "~/.pvmshrc", TCL_GLOBAL_ONLY);
#endif
    return TCL_OK;
}
