# console.tcl --
#
# Simple commands to replace the internal "pvm" commands
#

package provide Pvm 1.0

proc help {args} {
    error "sorry, not yet implemented"
}

proc ps {args} {
    error "sorry, not yet implemented"
}

proc setenv {varname args} {
    global env
    return [eval set env($varname) $args]
}

proc echo {args} {
    return [eval exec echo $args]
}

proc term {name {host {}} args} {
    global pvm_library

    if {![string compare $host {}] || ![string compare $host .]} {
	set host .
    }
    if {[catch {set tid [eval spawn -host $host [file join $pvm_library term.pvm] $args]}]} {
	set tid [eval spawn -host $host term.pvm $args]
    }
    if {$args!=""} {
	bind $tid 0 {eval [recv string]}
    }
    proc $name {string} "send $tid 0 \".t insert end \\\"\$string\\n\\\"\""
    return $name
}

proc dialog {{host {}} args} {
    global pvm_priv pvm_library

    if {![string compare $host {}] || ![string compare $host .]} {
	set host .
    }
    set pvm_priv(button) -1
    if {[catch {set tid [eval spawn -host $host $pvm_library/dialog.pvm $args]}]} {
	set tid [eval spawn -host $host dialog.pvm $args]
    }
    bind $tid 0 {
	set pvm_priv(button) [recv int]
    }
    while {$pvm_priv(button)==-1} {
	after 100
	update
    }
    set button $pvm_priv(button)
    unset pvm_priv(button)
    return $button
}

proc version {{package all}} {
    catch {set version "tcl\t[info tclversion]"}
#
# check the variables that might contain information about
# versions of included packages. These variables are expected
# to look like xxx_version, where "xxx" is the package name.
#
    foreach varname [uplevel #0 info vars *_version] {
	set pack [string range $varname 0 [expr [string first _ $varname]-1]]
	if {[lsearch $version $pack]<0} {
	    append version "\n$pack\t[uplevel #0 set $varname]"
	}
    }
    if {[set index [lsearch $version $package]]>=0} {
	return [lindex $version [expr $index^1]]
    } elseif {$package=="all"||$package==""} {
	return $version
    } else {
	error "unknown package name: \"$package\"
    }
}

proc patchlevel {{package all}} {
    catch {set patchlevel "tcl\t[info patchlevel]"}
#
# check the variables that might contain information about
# patchlevels of included packages. These variables are expected
# to look like xxx_patchLevel, where "xxx" is the package name.
#
    foreach varname [uplevel #0 info vars *_patchLevel] {
	set pack [string range $varname 0 [expr [string first _ $varname]-1]]
	if {[lsearch $patchlevel $pack]<0} {
	    append patchlevel "\n$pack\t[uplevel #0 set $varname]"
	}
    }
    if {[set index [lsearch $patchlevel $package]]>=0} {
	return [lindex $patchlevel [expr $index^1]]
    } elseif {$package=="all"||$package==""} {
	return $patchlevel
    } else {
	error "unknown package name: \"$package\"
    }
}

proc sig {num tid} {
    error "sorry, not yet implemented"
}

proc reset {} {
    foreach tid [tasks] {
	if {$tid!=[id]} {
	    kill $tid
	}
    }
}

proc quit {} {
    exit
}
