#include <stdio.h>
#include <stdlib.h>

#ifndef NO_STRING_H
#   include <string.h>
#else
#   include <strings.h>
#endif

#include <pwd.h>
#include "tkpvmInt.h"


/*
 *----------------------------------------------------------------------
 *
 * Pvm_RecvCmd --
 *
 *	This procedure is invoked to process the "recv" Tkpvm command.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *----------------------------------------------------------------------
 */

int
Pvm_RecvCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    int tid, pvmerror;
    char *stor, storage[100];
    union value {	char c;
			short s;
			int i;
			long l;
			float f;
			double d;
    } v;

    if (!PvmMytid) {
	if (!Pvm_StartDaemon(interp))
	    return TCL_ERROR;
    }
    if (argc<2) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			    " ....\"",(char *) NULL);
	return Pvm_ReturnError(interp,pvmerror);
    }
    argc-=1; argv+=1;
    while(argc) {
	stor = storage;
	if (*(interp->result)!='\0')
	    Tcl_AppendResult(interp," ",(char *)NULL);
	if (!strcmp(*argv,"byte")) {
	    pvmerror = pvm_upkbyte(&v.c,1,1);
	    sprintf(storage,"%d",v.c);
	} else if (!strcmp(*argv,"char")) {
	    pvmerror = pvm_upkbyte(&v.c,1,1);
	    sprintf(storage,"%c",v.c);
	} else if (!strcmp(*argv,"short")) {
	    pvmerror = pvm_upkshort(&v.s,1,1);
	    sprintf(storage,"%d",v.s);
	} else if (!strcmp(*argv,"int")) {
	    pvmerror = pvm_upkint(&v.i,1,1);
	    sprintf(storage,"%d",v.i);
	} else if (!strcmp(*argv,"long")) {
	    pvmerror = pvm_upklong(&v.l,1,1);
	    sprintf(storage,"%d",v.l);
	} else if (!strcmp(*argv,"tid")) {
	    pvmerror = pvm_upkint(&v.i,1,1);
	    sprintf(storage,"0x%x",v.i);
	} else if (!strcmp(*argv,"float")) {
	    pvmerror = pvm_upkfloat(&v.f,1,1);
	    Tcl_PrintDouble(interp,v.f,storage);
	} else if (!strcmp(*argv,"double")) {
	    pvmerror = pvm_upkdouble(&v.d,1,1);
	    Tcl_PrintDouble(interp,v.d,storage);
	} else if (!strcmp(*argv,"string")) {
	    pvmerror = pvm_upkint(&v.i,1,1);
	    if (pvmerror>=0) {
		if (v.i>=99) {
		    stor = (char *) ckalloc(v.i+1);
		}
		if (v.i>0) {
		    pvmerror=pvm_upkbyte(stor,v.i,1);
		    if (stor[v.i-1] != 0) {
			stor[v.i] = 0;
		    }
		} else {
		    stor[0]=0;
		}
	    }
	} else {
	    Tcl_AppendResult(interp,"wrong format \"",*argv,
		    "\", should be byte, char, short, ",
		    "int, long, tid, float, double or string",
			    (char *)NULL);
	    pvmerror = -1;
	}
	if (pvmerror>=0) {
	    Tcl_AppendResult(interp,stor,(char *) NULL);
	} else {
	    break;
	}
        if (stor!=storage) ckfree(stor);
	argc--; argv++;
    }
    return Pvm_ReturnError(interp,pvmerror);
}
