#!/bin/sh
# the next line restarts using pvmwish1.0 (could also be wish4.1) \
exec pvmwish1.0 $0 ${1+"$@"}

# List here all packages used in this file
package require Tcl 7.5
package require Tk 4.1
package require Pvm 1.0

# Here the script starts:
set command ""

scrollbar .s -command ".t yview"
text .t -yscroll ".s set"
pack .s -fill y -side left
pack .t -fill both -expand y -side right
focus .t
proc bgerror {msg} {
    global errorInfo command
    .t insert insert "\n$msg\n"
    .t see insert
    set command ""
}
bind .t <Return> {
    .t mark set insert "insert lineend"
    append command "\n[.t get "insert linestart" "insert lineend"]"
    if {[info complete "$command\n"]} {
	set result [eval $command]
	set command ""
	if {$result!= ""} {
	    .t insert insert "\n$result"
	}
    }
}
