#!/bin/sh
# The next line restarts using pvmwish1.0 (could also be wish4.1)\
exec pvmwish1.0 $0 ${1+"$@"}

# List here all packages used in this file
package require Tcl 7.5
package require Tk 4.1
package require Pvm 1.0

# Here the script starts
frame .button -relief raised -bd 1
button .button.start -text "start" -command start_slaves -padx 2m -pady 2m
button .button.exit -text exit -command exit
label .label1 -text "number of processes"
entry .entry1
label .label2 -text "array size"
entry .entry2
frame .frame
listbox .frame.list -yscroll ".frame.scroll set"
scrollbar .frame.scroll -command ".frame.list yview"

pack .button .label1 .entry1 .label2 .entry2 -fill x
pack .frame -expand y -fill both
pack .button.start -side left -fill x -expand y
pack .button.exit -side left -fill x -expand y
pack .frame.list -expand y -fill both -side left
pack .frame.scroll -fill y -side left

.entry1 insert end 5
.entry2 insert end 100

bind . <Return> ".button.start flash ;start_slaves"

proc start_slaves {} {
    set nproc [.entry1 get]
    set n     [.entry2 get]
    set data ""
    for {set i 0} {$i<$n} {incr i} {
	lappend data 1.0
    }
    set tids [spawn -ntask $nproc -host . [pwd]/slave1]
    .frame.list delete 0 end
    foreach tid $tids {
# sorry, multicast not yet implemented
	send $tid 0 -tid() $tids -float() $data
	bind $tid 5 {
	    set who [recv int]
	    set result [recv float]
	    .frame.list insert end "I got $result from $who"
	}
    }
}
