/*
 * tkWinInt.h --
 *
 *	This file contains declarations that are shared among the
 *	Windows-specific parts of Tk, but aren't used by the rest of
 *	Tk.
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) tkWinInt.h 1.30 97/01/09 15:30:43
 */

#ifndef _TKWININT
#define _TKWININT

#ifndef _TK
#include <tk.h>
#endif

/*
 * Include platform specific public interfaces.
 */

#ifndef _TKWIN
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN

/*
 * The following messages are use to communicate between a Tk toplevel
 * and its container window.
 */

#define TK_CLAIMFOCUS	(WM_USER)
#define TK_GEOMETRYREQ	(WM_USER+1)
#define TK_ATTACHWINDOW	(WM_USER+2)
#define TK_DETACHWINDOW	(WM_USER+3)


/*
 *--------------------------------------------------------------
 *
 * Exported procedures defined for the Windows platform only.
 *
 *--------------------------------------------------------------
 */

EXTERN Window		Tk_AttachHWND _ANSI_ARGS_((Tk_Window tkwin,
			    HWND hwnd));
EXTERN HINSTANCE 	Tk_GetHINSTANCE _ANSI_ARGS_((void));
EXTERN HWND		Tk_GetHWND _ANSI_ARGS_((Window window));
EXTERN Tk_Window	Tk_HWNDToWindow _ANSI_ARGS_((HWND hwnd));
EXTERN void		Tk_PointerEvent _ANSI_ARGS_((HWND hwnd,
			    int x, int y));
EXTERN int		Tk_TranslateWinEvent _ANSI_ARGS_((HWND hwnd,
			    UINT message, WPARAM wParam, LPARAM lParam,
			    LRESULT *result));

#endif /* _TKWIN */

/*
 * Define constants missing from older Win32 SDK header files.
 */

#ifndef WS_EX_TOOLWINDOW
#define WS_EX_TOOLWINDOW	0x00000080L 
#endif

typedef struct TkFontAttributes TkFontAttributes;

/*
 * The TkWinDCState is used to save the state of a device context
 * so that it can be restored later.
 */

typedef struct TkWinDCState {
    HPALETTE palette;
} TkWinDCState;

/*
 * The TkWinDrawable is the internal implementation of an X Drawable (either
 * a Window or a Pixmap).  The following constants define the valid Drawable
 * types.
 */

#define TWD_BITMAP	1
#define TWD_WINDOW	2
#define TWD_WINDC	3

typedef struct {
    int type;
    HBITMAP handle;
    Colormap colormap;
    int depth;
} TkWinBitmap;

typedef struct {
    int type;
    HDC hdc;
}TkWinDC;

typedef union {
    int type;
    TkWinBitmap bitmap;
    TkWinDC winDC;
} TkWinDrawable;

/*
 * The following macros are used to retrieve internal values from a Drawable.
 */

#define TkWinGetHWND(w) (((TkWinDrawable *) w)->window.handle)
#define TkWinGetWinPtr(w) (((TkWinDrawable*)w)->window.winPtr)
#define TkWinGetHBITMAP(w) (((TkWinDrawable*)w)->bitmap.handle)
#define TkWinGetColormap(w) (((TkWinDrawable*)w)->bitmap.colormap)
#define TkWinGetHDC(w) (((TkWinDrawable *) w)->winDC.hdc)

/*
 * The following structure is used to encapsulate palette information.
 */

typedef struct {
    HPALETTE palette;		/* Palette handle used when drawing. */
    UINT size;			/* Number of entries in the palette. */
    int stale;			/* 1 if palette needs to be realized,
				 * otherwise 0.  If the palette is stale,
				 * then an idle handler is scheduled to
				 * realize the palette. */
    Tcl_HashTable refCounts;	/* Hash table of palette entry reference counts
				 * indexed by pixel value. */
} TkWinColormap;

/*
 * The following macro retrieves the Win32 palette from a colormap.
 */

#define TkWinGetPalette(colormap) (((TkWinColormap *) colormap)->palette)

/*
 * The following macros define the class names for Tk Window types.
 */

#define TK_WIN_TOPLEVEL_CLASS_NAME "TkTopLevel"
#define TK_WIN_CHILD_CLASS_NAME "TkChild"

/*
 * The following defines are used with TkWinGetBorderPixels to get the
 * extra 2 border colors from a Tk_3DBorder.
 */

#define TK_3D_LIGHT2 TK_3D_DARK_GC+1
#define TK_3D_DARK2 TK_3D_DARK_GC+2

/*
 * The following declaration is a special purpose backdoor into the
 * Tcl notifier.  It is used to process events on the Tcl event queue,
 * without reentering the system event queue.
 */

extern void		TclWinFlushEvents _ANSI_ARGS_((void));

/*
 * Internal procedures used by more than one source file.
 */

extern LRESULT CALLBACK	TkWinChildProc _ANSI_ARGS_((HWND hwnd, UINT message,
			    WPARAM wParam, LPARAM lParam));
extern void		TkWinClipboardRender _ANSI_ARGS_((HWND hwnd,
			    UINT format));
extern void		TkWinEnterModalLoop _ANSI_ARGS_((
			    Tcl_Interp * interp));
extern LRESULT		TkWinEmbeddedEventProc _ANSI_ARGS_((HWND hwnd,
			    UINT message, WPARAM wParam, LPARAM lParam));
extern void		TkWinFillRect _ANSI_ARGS_((HDC dc, int x, int y,
			    int width, int height, int pixel));
extern COLORREF		TkWinGetBorderPixels _ANSI_ARGS_((Tk_Window tkwin,
			    Tk_3DBorder border, int which));
extern HDC		TkWinGetDrawableDC _ANSI_ARGS_((Display *display,
			    Drawable d, TkWinDCState* state));
extern int		TkWinGetModifierState _ANSI_ARGS_((void));
extern HPALETTE		TkWinGetSystemPalette _ANSI_ARGS_((void));
extern HMODULE		TkWinGetTkModule _ANSI_ARGS_((void));
extern void		TkWinLeaveModalLoop _ANSI_ARGS_((
			    Tcl_Interp * interp));
extern int		TkWinHandleMenuEvent _ANSI_ARGS_((HWND *phwnd,
			    UINT *pMessage, WPARAM *pwParam, LPARAM *plParam,
			    LRESULT *plResult));
extern int		TkWinIndexOfColor _ANSI_ARGS_((XColor *colorPtr));
extern void		TkWinPointerEvent _ANSI_ARGS_((HWND hwnd, int x,
			    int y));
extern void		TkWinPointerInit _ANSI_ARGS_((void));
extern LRESULT 		TkWinReflectMessage _ANSI_ARGS_((HWND hwnd,
			    UINT message, WPARAM wParam, LPARAM lParam));
extern void		TkWinReleaseDrawableDC _ANSI_ARGS_((Drawable d,
			    HDC hdc, TkWinDCState* state));
extern LRESULT		TkWinResendEvent _ANSI_ARGS_((WNDPROC wndproc,
			    HWND hwnd, XEvent *eventPtr));
extern HPALETTE		TkWinSelectPalette _ANSI_ARGS_((HDC dc,
			    Colormap colormap));
extern void		TkWinSetMenu _ANSI_ARGS_((Tk_Window tkwin,
			    HMENU hMenu));
extern void		TkWinSetWindowPos _ANSI_ARGS_((HWND hwnd,
			    HWND siblingHwnd, int pos));
extern void		TkWinXCleanup _ANSI_ARGS_((HINSTANCE hInstance));
extern void 		TkWinXInit _ANSI_ARGS_((HINSTANCE hInstance));

#endif /* _TKWININT */

