/*
 * imgWin.c --
 *
 * A photo image file handler to put the content of a window in a photo.
 *
 */

/* Author : Jan Nijtmans */
/* Date   : 8/24/97        */

#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "imgInt.h"

/*
 * The format record for the Win data format:
 */

static int ChanMatchWin _ANSI_ARGS_((Tcl_Channel chan, char *filename,
	struct Tcl_Obj *format, int *widthPtr, int *heightPtr));
static int ObjMatchWin _ANSI_ARGS_((struct Tcl_Obj *dataObj,
	struct Tcl_Obj *format, int *widthPtr, int *heightPtr));
static int ObjReadWin _ANSI_ARGS_((Tcl_Interp *interp, struct Tcl_Obj *dataObj,
	struct Tcl_Obj *format, Tk_PhotoHandle imageHandle,
	int destX, int destY, int width, int height, int srcX, int srcY));

Tk_PhotoImageFormat imgFmtWin = {
    "WINDOW",					/* name */
    /*(Tk_ImageFileMatchProc *)*/ ChanMatchWin,	/* fileMatchProc */
    (Tk_ImageStringMatchProc *) ObjMatchWin,	/* stringMatchProc */
    (Tk_ImageFileReadProc *) NULL,		/* fileReadProc */
    (Tk_ImageStringReadProc *) ObjReadWin,	/* stringReadProc */
    (Tk_ImageFileWriteProc *) NULL,		/* fileWriteProc */
    (Tk_ImageStringWriteProc *) NULL,		/* stringWriteProc */
};

/*
 * Prototypes for local procedures defined in this file:
 */

#define UCHAR(c) ((unsigned char) (c))

static int ChanMatchWin(chan, filename, format, widthPtr, heightPtr)
    Tcl_Channel chan;
    char *filename;
    struct Tcl_Obj *format;
    int *widthPtr, *heightPtr;
{
    return 0;
}

static int ObjMatchWin(data, format, widthPtr, heightPtr)
    struct Tcl_Obj *data;
    struct Tcl_Obj *format;
    int *widthPtr, *heightPtr;
{
    char *name = ImgGetStringFromObj(data, NULL);

    printf("matching %s\n", name);

    if ((name[0] == '.') && ((name[1] == 0) || islower(UCHAR(name[1])))) {
	printf("OK\n");
	return 1;
    }
    printf("NOK\n");
    return 0;
}

typedef struct myblock {
    Tk_PhotoImageBlock ck;
    int dummy; /* extra space for offset[3], in case it is not
		  included already in Tk_PhotoImageBlock */
} myblock;

#define block bl.ck

static int ObjReadWin(interp, data, format, imageHandle,
	destX, destY, width, height, srcX, srcY)
    Tcl_Interp *interp;
    struct Tcl_Obj *data;
    struct Tcl_Obj *format;
    Tk_PhotoHandle imageHandle;
    int destX, destY;
    int width, height;
    int srcX, srcY;
{
    Tk_Window tkwin;
    int fileWidth, fileHeight;
    char *name;

    printf("start read\n");
    name = ImgGetStringFromObj(data, NULL);

    printf("main window: %d\n", (int) 15 /*Tk_MainWindow(interp)*/);

    tkwin = Tk_NameToWindow(interp, name, Tk_MainWindow(interp));
    printf("window: %d\n", (int) tkwin);

    if (!tkwin) {
	return TCL_ERROR;
    }

    fileWidth = Tk_Width(tkwin);
    fileHeight = Tk_Height(tkwin);

    printf("height, width = %d %d\n", fileWidth, fileHeight);

    if ((srcX + width) > fileWidth) {
	width = fileWidth - srcX;
    }
    if ((srcY + height) > fileHeight) {
	height = fileHeight - srcY;
    }
    if ((width <= 0) || (height <= 0)) {
	return TCL_OK;
    }
    Tk_PhotoExpand(imageHandle, destX + width, destY + height);

    /*
    Tk_PhotoPutBlock(imageHandle, &block, destX, destY++, width, 1);
    */

    return TCL_OK;
}