/* 
 * tclWin32Lib.c --
 *
 *    This procedure provides the TclSynchSpawn function for
 *    standalone executables.
 *
 */

#include <windows.h>
#include "tcl.h"
#include "tclPort.h"

static HINSTANCE      tclInstance = NULL;
static int tclPlatformId;	/* Running under NT, 95, or Win32s? */

/*
 *----------------------------------------------------------------------
 *
 * TclSynchSpawn --
 *
 *    32-bit entry point to the 16-bit SynchSpawn code.
 *
 * Results:
 *    1 on success, 0 on failure.
 *
 * Side effects:
 *    Spawns a command and waits for it to complete.
 *
 *----------------------------------------------------------------------
 */
int 
TclWinSynchSpawn(void *args, int type, void **trans, int *pidPtr)
{

    /*
     * Currently unsupported by the standalone library.
     */

    return 0;
}
/*
 *----------------------------------------------------------------------
 *
 * TclWinGetPlatformId --
 *
 *	Determines whether running under NT, 95, or Win32s, to allow 
 *	runtime conditional code.
 *
 * Results:
 *	The return value is one of:
 *	    VER_PLATFORM_WIN32s		Win32s on Windows 3.1. 
 *	    VER_PLATFORM_WIN32_WINDOWS	Win32 on Windows 95.
 *	    VER_PLATFORM_WIN32_NT	Win32 on Windows NT
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

int		
TclWinGetPlatformId()
{
    return tclPlatformId;
}

/*
 *----------------------------------------------------------------------
 *
 * TclWinSetTclInstance --
 *
 *	Sets the global library instance handle.
 *
 * Results:
 *	Sets the global library instance handle.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

void
TclWinSetTclInstance(instance)
    HINSTANCE instance;
{
    OSVERSIONINFO os;

    tclInstance = instance;
    os.dwOSVersionInfoSize = sizeof(os);
    GetVersionEx(&os);
    tclPlatformId = os.dwPlatformId;
}
/*
 *----------------------------------------------------------------------
 *
 * TclWinGetTclInstance --
 *
 *	Retrieves the global library instance handle.
 *
 * Results:
 *	Returns the global library instance handle.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

HINSTANCE
TclWinGetTclInstance()
{
    return tclInstance;
}
