/* 
 * ath_tape_reader.h: 
 *     Format definition of Athapascan0 events
 *
 */
   
#ifndef _ATH_TAPE_READER_H_
#define _ATH_TAPE_READER_H_

#include "tape_reader.h"

/**********************************
 * Athapascan communication events
 **********************************/

typedef struct {

  TapeEventHeader header;

  int other_task;
  int other_thread;
  int bytes;

} TapeAth0ServiceStartEvent,  /* service start */
  TapeAth0ServiceEndEvent;    /* service end */

typedef struct {

  TapeEventHeader header;

  int ret;
  int other_task;
  int other_thread;
  int other_nickname;
  int delta_s;
  int delta_us;
  int bytes;

} TapeAth0CallEvent,
  TapeAth0DoCallEvent,
  TapeAth0SpawnEvent,
  TapeAth0DoSpawnEvent,
  TapeAth0WaitSpawnEvent,
  TapeAth0WaitSpawnResEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int delta_s;
  int delta_us;
  
} TapeAth0TestSpawnEvent;

/****************************
 * Athapascan packing events
 ****************************/

typedef TapeAth0TestSpawnEvent

  TapeAth0PackEvent,
  TapeAth0UnPackEvent;

/************************
 * Athapascan IPC events
 ************************/

typedef TapeAth0TestSpawnEvent

  TapeAth0LSemPEvent,
  TapeAth0LSignalEvent,
  TapeAth0LPassEvent,
  TapeAth0LPassAndReuseEvent;

#endif

