/*
 * ath0_tape_events.h:
 *     Assignment of Athapascan-0 event identifiers
 *
 */

#ifndef _ATH0_TAPE_EVENTS_H_
#define _ATH0_TAPE_EVENTS_H_

#define base_ath0    500            /* base index of ath0 events */
#define slot_ath0    250            /* size of ath0 index slot */

#define ATH0EVENT(t) (t>=base_ath0&&t<base_ath0+slot_ath0)

#define event_Ath0ServiceStart        base_ath0 
#define event_Ath0ServiceEnd        ( base_ath0 + 1 )
#define event_Ath0Call              ( base_ath0 + 2 )
#define event_Ath0DoCall            ( base_ath0 + 3 )
#define event_Ath0Spawn             ( base_ath0 + 4 )
#define event_Ath0DoSpawn           ( base_ath0 + 5 ) 
#define event_Ath0TestSpawn         ( base_ath0 + 6 )
#define event_Ath0WaitSpawn         ( base_ath0 + 7 )
#define event_Ath0WaitSpawnRes      ( base_ath0 + 8 )
#define event_Ath0Pack              ( base_ath0 + 9 )
#define event_Ath0UnPack            ( base_ath0 + 10 )
#define event_Ath0LSemP             ( base_ath0 + 11 )
#define event_Ath0WaitLSignal       ( base_ath0 + 12 )
#define event_Ath0LPass             ( base_ath0 + 13 )
#define event_Ath0LPassAndReuse     ( base_ath0 + 14 )

#endif
