/* TAPE/PVM %W% %G% */

/* 250895/maillet: on-line event compacting is now optional
 * 260895/maillet: 'longueur' is no longer constructed while
 *                 computing 'chaine' but through a single 
 *                 strlen call after 'chaine' is built.
 * 151295/maillet: tape_event now measures intrusion delays
 *                 tape_trace event now becomes obsolete
 *                 (flush event generation has been suppressed)
 */

#include <stdio.h>
#include <sys/time.h>
#include <string.h>
#include <stdarg.h>
#include <memory.h>

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"

#define MFL   96   /* maximum length of a % format */
#define MEL 4096   /* maximum event length */



/* tape_event is a wrapper for tape_v_event. This introduces some
   overhead but gives more flexibility. Users can define other wrapper
   functions which provide automatic dating for instance. Wrapper functions
   initialize the event header (first 6 ints), and pass control to tape_v_event 
   which does the actual event formatting.
 */

void
tape_event(int evtId,
	   int genId,
	   int fileId,
	   int lineNo,
	   int sec,
	   int usec,
	   char *format,
	   ...)
{
  struct timeval tv0, tv1;
  va_list ap;

  tape_clock(&tv0);
  va_start(ap,format);
  tape_v_event(tape_perturb,evtId,genId,fileId,lineNo,sec,usec,format,ap);
  va_end(ap);
  tape_clock(&tv1);

  /* update perturbation of last event generation */
  tape_perturb = (tv1.tv_sec-tv0.tv_sec)*1000000+
                  tv1.tv_usec-tv0.tv_usec+
		  tape_minpert;

}


/* main event formating function */

void 
tape_v_event(long precpert,
	     int evtId,
	     int genId,
	     int fileId,
	     int lineNo,
	     int sec,
	     int usec,
	     char *format,
	     va_list ap)

/* stores event into local event buffer and flushes buffer if necessary

        pre   : ap is a va list initialized to a list of args whose
                format is described by 'format'
           
        ints  : form the constant header of event

	format:	variables	%d	integer
				%f	float (6 digits after point)
				%.nf	float (n digits after point)
				%t	table of integers
				%s	string
		NULL            no variable arg list

	args:	int
		double
		double
		(struct tableau *)
		char *
*/

{
register int i,j;
int longueur;       /* current event length */

int n;
char chaine[MEL];   /* the event is constructed in chaine ("$1:$2:...:$n;") */
char pval[MFL];     /* single formats are built in pval before being */
                    /* appended to chaine */
struct tableau *ptr;
int esize;          /* effective event storage space (after compact) */
int nbstrings=0;    /* number of string fields (%s) in event */

chaine[0]=0;

  /* format constant part of arg list */


sprintf(chaine,"%ld",precpert);
/* longueur=strlen(chaine); */

sprintf(pval,"%d",evtId);
strcat(strcat(chaine,":"),pval);
/* longueur+=strlen(pval)+1; */

sprintf(pval,"%d",genId);
strcat(strcat(chaine,":"),pval);
/* longueur+=strlen(pval)+1; */

sprintf(pval,"%d",fileId);
strcat(strcat(chaine,":"),pval);
/* longueur+=strlen(pval)+1; */

sprintf(pval,"%d",lineNo);
strcat(strcat(chaine,":"),pval);
/* longueur+=strlen(pval)+1; */

sprintf(pval,"%d",sec);
strcat(strcat(chaine,":"),pval);
/* longueur+=strlen(pval)+1; */

sprintf(pval,"%d",usec);
strcat(strcat(chaine,":"),pval);
/* longueur+=strlen(pval)+1; */

  /* skip variable part in case no format string is given */
if( format==NULL || strlen(format)==0 )
  goto end_vararg;

strcat(chaine,":");
/* longueur++; */

  /* format variable part of arg list */

  /* read event format */
for(i=0;i<strlen(format);i++)
   {
   pval[0]=0;
   if(format[i]=='%')
      {		/* prefixe pour une variable */
      switch (format[++i])
         {
	 case 'd':
	 sprintf(pval,"%d",va_arg(ap,int));
	 /* longueur+=strlen(pval); */
	 strcat(chaine,pval);
	/* on concatene a la chaine l'entier en ASCII */
	 break;
	 case 't':
	 ptr=(struct tableau *)va_arg(ap,int*);
	 for(j=0;j<ptr->num-1;j++)
	    {
	    sprintf(pval,"%d:",ptr->tab[j]);
	    /* longueur+=strlen(pval); */
	    strcat(chaine,pval);
	    }
	 sprintf(pval,"%d",ptr->tab[j]);
	 /* longueur+=strlen(pval); */
	 strcat(chaine,pval);
	/* on concatene a la chaine les entiers en ASCII */
	 break;
	 case '.':
	 n=0;
	 while(format[++i]>'/'&&format[i]<':')
	    n=n*10+format[i]-'0';
	 if (format[i]!='f')
	    printf("Erreur de format\n");
	 sprintf(pval,"%.*f",n,va_arg(ap,double));
	 /* longueur+=strlen(pval); */
	 strcat(chaine,pval);
	/* on concatene a la chaine le reel en ASCII */
	 break;
	 case 'f':
	 sprintf(pval,"%f",va_arg(ap,double));
	 /* longueur+=strlen(pval); */
	 strcat(chaine,pval);
	 /* on concatene les caracteres a la chaine */
	 break;
	 case 's':
	 if(tape_compact) {
	   sprintf(pval,"%s",va_arg(ap,char *));
	   /* longueur++; */
	   strcat(chaine,"/");
	   for(j=0;j<strlen(pval);j++)
	     {
	       if(pval[j]=='/')
		 {
		   /* longueur++; */
		   strcat(chaine,"/");
		 }
	       /* longueur++; */
	       strncat(chaine,pval+j,1);
	     }
	   /* longueur++; */
	   strcat(chaine,"/");
	 } else
	   strcat(chaine,va_arg(ap,char *));
	 nbstrings++;
	 break;
         default:
	 printf("Erreur de format\n");
	 }
      }
   else
      {		/* sinon on propage les separateurs */
      if (format[i]==' ')
	 {
	 /* longueur++; */
	 strcat(chaine,":");
	 }
      }
   }

end_vararg: strcat(chaine,";");
/* longueur++ */

/* Event format finished (constant and variable part).
 * 'chaine' contains a string of the following form:
 *
 *               "$1:$2:..:$n;"
 *
 * where the $i are the event's fields, ":" is the field
 * separator and ";" is the end marker. n>=7 (n=7 in case
 * no format was given)
 */

#ifdef DEBUG
printf("%s\n",chaine);
#endif


/* compute buffer space required for chaine depending on
 * whether on-line compacting is on or off
 */

longueur=strlen(chaine);

if(tape_compact&&!nbstrings)
  esize=(longueur+1)/2;
else
  esize=longueur;

/* store chaine into event buffer - flush to disk when necessary */

if(buffer_index+esize>buffer_size-2)

  {		/* surcharge du buffer=>on stocke dans un fichier temporaire
			et local */
    long int dif_s,dif_us;
    FILE *F;

    ++buffer_index;   /* span rest of buffer with nulls */
    memset(buffer+buffer_index,0,buffer_size-buffer_index);
    
    if(!(F=fopen(file_name,"a"))) {
      fprintf(stderr,"tape warning, cannot open local trace file, buffer lost.\n");
      fflush(stderr); }
    else {
      fwrite(buffer,buffer_size,1,F);
      fclose(F);	/* sauvegarde dans le temporaire local */
      nb_buffer++;
    }
    
    if(longueur>buffer_size-2) {
      fprintf(stderr,"tape warning, event is longer than buffer size, event lost.\n");
      fflush(stderr); }
    else {
      /* initialize new buffer */
      buffer[0]=0;
      /* write event into the new buffer */
      buffer_index=compactage(chaine,longueur,buffer,tape_compact);
    }
  }

else
  buffer_index+=compactage(chaine,longueur,buffer+buffer_index,tape_compact);
/* compactage et entree dans le buffer de l'evenement */

}

