/* TAPE/PVM %W% %G% */
#include "clockstats.h"
#include "insert.h"

void swap_int(int *x, int *y) {
  int a;
  a=*x;*x=*y;*y=a;
}

void swap_double(double *x, double *y) {
  double a;
  a=*x;*x=*y;*y=a;
}

void get_median_point(int m, struct point *t, struct point *p)

/* t: sorted (on Y) table of points
   m: number of points in t
   p: will contain the medium point in t
*/

{
  if(m%2) { /* odd number of points */
    p->X=t[m/2].X;
    p->Y=t[m/2].Y;
  }
  else    { /* even number of points */
    p->X=(t[m/2-1].X+t[m/2].X)/2.0;
    p->Y=(t[m/2-1].Y+t[m/2].Y)/2.0;
  }
}
      
     
void insert_sort(int m, struct point *t, int *r, struct point e, int i)

/* t: table of points
   r: rank of points
   m: size of t and r
   e: new elemt to be inserted
   i: number of elements in the table at call

   condition: table t and r are *not* full, the i elements of the
      table are sorted by Y, ranks of elements are a permutation of [1:i]
   result: the i+1 elements of the table are sorted by Y, rank of the
      inserted element is m-i
*/

{
  int k=0,l;
  while(k<i&&e.Y>t[k].Y) k++;
  if(k==i) {
    /* new element is the biggest one */
    t[i].X=e.X;
    t[i].Y=e.Y;
    r[i]=m-i;
  } else {
    /* new element has to be inserted */
    for(l=i;l>k;l--) {
      t[l].X=t[l-1].X;
      t[l].Y=t[l-1].Y;
      r[l]=r[l-1];
    }
    t[k].X=e.X;
    t[k].Y=e.Y;
    r[k]=m-i;
  }
}

  
void insert_point(int m, struct point *t, int *r, struct point e)

/* t: table of points
   r: rank of the points in the table
   m: size of t and r
   e: new element to be inserted

   condition: tables t and r are full (m elements), elements sorted by
      Y field, ranks of elements are a permutation of [1:m]
   result: point of rank m thrown out of table, new element inserted
      with rank 1, ranks of other elements incremented by 1
*/

{
  struct point elem_i;     /* current element to be inserted */
  int rank_i=1;            /* rank of that element */
  int i=0;
  int filled=0;
  
  elem_i.X=e.X; elem_i.Y=e.Y;

  while(r[i]!=m) {
    r[i]++;
    if(t[i].Y>elem_i.Y) {
      swap_double(&t[i].X, &elem_i.X);
      swap_double(&t[i].Y, &elem_i.Y);
      swap_int(&r[i], &rank_i);
    }
    i++;
  }

  while(i<m-1&&!filled) {
    if(elem_i.Y>t[i+1].Y) {
      t[i].X=t[i+1].X;
      t[i].Y=t[i+1].Y;
      r[i]=r[i+1]+1;
      i++; }
    else {
      t[i].X=elem_i.X;
      t[i].Y=elem_i.Y;
      r[i]=rank_i;
      filled=1;
    }
  }

  if(i==m-1) {
    t[i].X=elem_i.X;
    t[i].Y=elem_i.Y;
    r[i]=rank_i; }
  else {
    int k;
    for(k=i+1;k<m;k++) r[k]++;
  }
}
