/* TAPE/PVM %W% %G% */

#include <stdio.h>
#include <sys/time.h>
#include <sys/param.h>
#include <stdlib.h>
#include "pvm3.h"
#include "tag.h"

#ifdef pvm3_2_6
#define PVMHOSTINFO hostinfo
#else
#define PVMHOSTINFO pvmhostinfo
#endif

void tape_clock(struct timeval*);
char *getwd(char*);
void init_tid(int *);

/* globals */

char *buffer;
int buffer_size;
int buffer_index;
int taille_buf;
int nb_buffer;
int *table_phase; /* table for phase recursion */
int max_phase;
int phase_index;
int pvm_actif;
int base_s;       /* global time basis in secs */
int control;
unsigned int mselect;
int taskid;
char *file_name;

/* function to report errors in mallocs */

void fatalMallocFailure(char* fi,int ln) {
   fprintf(stderr,"[%s] fatal malloc error in line %d.\n", fi, ln);
   fflush(stdout);
 }


void tape_init(int max_buf, int nb_phase, int masq_param, int control_param, 
               int base_param, int nb_pingpong_param, double temps_attente_param,
               int wsize)
{
char pathname[MAXPATHLEN];

pvm_actif=1;

base_s = base_param;

/* si taskid!=0 alors pvm_mytid deja effectue */
taskid=0;
init_tid(&taskid);      /* task enroled here, creation of tracefile in /tmp */
taille_buf = max_buf*1;
buffer_size = taille_buf*1;
if (!(buffer = (char *)malloc((unsigned)buffer_size)))
   fprintf(stderr,"[tape] fatal error, unable to allocate trace buffer.\n");
buffer_index = 0;
buffer[0]=0;
nb_buffer= 1;

if(!(table_phase=(int *)calloc(sizeof(int),nb_phase)))
  fatalMallocFailure(__FILE__,__LINE__);
max_phase=nb_phase;
phase_index=0;

mselect = (unsigned) masq_param;
control = control_param;

#ifdef DEBUG
printf("La valeur de control_param est : %d\n",control_param);
#endif

if (!control) /* code du maitre (no -C in args) */
   {
   int new_buf, old_buf;

   taskid=pvm_mytid();

   /* we leave it up to pvm where to place tape's control task */

   pvm_spawn("tape_control",0,PvmTaskDefault,0,1,&control);

   /* get current working directory pathname */
   getwd(pathname);

   /* send command line information to tape_control */
   new_buf=pvm_mkbuf(0);
   old_buf=pvm_setsbuf(new_buf);
   pvm_pkint(&taille_buf,1,1);
   pvm_pkint(&nb_pingpong_param,1,1);
   pvm_pkdouble(&temps_attente_param,1,1);
   pvm_pkint(&wsize,1,1);
   pvm_pkstr(pathname);
   pvm_send(control,msgtag_taille);
   pvm_setsbuf(old_buf);
   pvm_freebuf(new_buf);

   /* wait for permission to start execution and get base time */
   pvm_recv(control,msgtag_init);
   pvm_upkint(&base_s,1,1);
   }

}

